/*
 * Decompiled with CFR 0.152.
 */
package tmechworks.lib.util;

public class CoordTuple
implements Comparable {
    public final int x;
    public final int y;
    public final int z;

    public CoordTuple(int posX, int posY, int posZ) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
    }

    public CoordTuple(double posX, double posY, double posZ) {
        this.x = (int)Math.floor(posX);
        this.y = (int)Math.floor(posY);
        this.z = (int)Math.floor(posZ);
    }

    public CoordTuple(CoordTuple tuple) {
        this.x = tuple.x;
        this.y = tuple.y;
        this.z = tuple.z;
    }

    public boolean equalCoords(int posX, int posY, int posZ) {
        return this.x == posX && this.y == posY && this.z == posZ;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            CoordTuple coord = (CoordTuple)obj;
            if (this.x == coord.x && this.y == coord.y && this.z == coord.z) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        return "X: " + this.x + ", Y: " + this.y + ", Z: " + this.z;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException("Object cannot be null");
        }
        CoordTuple coord = (CoordTuple)o;
        if (this.x < coord.x) {
            return -1;
        }
        if (this.x > coord.x) {
            return 1;
        }
        if (this.y < coord.y) {
            return -1;
        }
        if (this.y > coord.y) {
            return 1;
        }
        if (this.z < coord.z) {
            return -1;
        }
        if (this.z > coord.z) {
            return 1;
        }
        return 0;
    }
}

