/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cpw.mods.fml.common.network.PacketDispatcher;
import erogenousbeef.bigreactors.common.interfaces.IMultipleFluidHandler;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityPoweredInventory;
import erogenousbeef.bigreactors.net.PacketWrapper;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityPoweredInventoryFluid
extends TileEntityPoweredInventory
implements IFluidHandler,
IMultipleFluidHandler {
    private FluidTank[] tanks = new FluidTank[this.getNumTanks()];
    private int[] tankExposure;
    private FluidTank[] exposedTankCache;
    protected static final FluidTank[] kEmptyFluidTankList = new FluidTank[0];
    public static final int FLUIDTANK_NONE = -1;

    public TileEntityPoweredInventoryFluid() {
        for (int i = 0; i < this.getNumTanks(); ++i) {
            this.tanks[i] = new FluidTank(this.getTankSize(i));
        }
        this.tankExposure = new int[6];
        this.resetFluidExposures();
    }

    public void setExposedTank(ForgeDirection side, int tankIdx) {
        if (side == ForgeDirection.UNKNOWN) {
            return;
        }
        if (this.tankExposure[side.ordinal()] == tankIdx) {
            return;
        }
        this.tankExposure[side.ordinal()] = tankIdx;
        if (!this.field_70331_k.field_72995_K) {
            Packet250CustomPayload updatePacket = PacketWrapper.createPacket("BigReactors", 7, new Object[]{this.field_70329_l, this.field_70330_m, this.field_70327_n, side.ordinal(), tankIdx});
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)50.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)updatePacket);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
    }

    public int getExposedTankFromReferenceSide(ForgeDirection side) {
        if (side == ForgeDirection.UNKNOWN) {
            return -1;
        }
        return this.tankExposure[side.ordinal()];
    }

    private void readFluidsFromNBT(NBTTagCompound tag) {
        int i;
        for (int i2 = 0; i2 < this.tanks.length; ++i2) {
            this.tanks[i2].setFluid(null);
        }
        if (tag.func_74764_b("fluids")) {
            NBTTagList tagList = tag.func_74761_m("fluids");
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound fluidTag = (NBTTagCompound)tagList.func_74743_b(i);
                int fluidIdx = fluidTag.func_74762_e("tagIdx");
                FluidStack newFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
                this.tanks[fluidIdx].setFluid(newFluid);
            }
        }
        this.resetFluidExposures();
        if (tag.func_74764_b("fluidExposures")) {
            NBTTagList exposureList = tag.func_74761_m("fluidExposures");
            for (i = 0; i < exposureList.func_74745_c(); ++i) {
                NBTTagCompound exposureTag = (NBTTagCompound)exposureList.func_74743_b(i);
                int exposureIdx = exposureTag.func_74762_e("exposureIdx");
                this.tankExposure[exposureIdx] = exposureTag.func_74762_e("direction");
            }
        }
    }

    private void writeFluidsToNBT(NBTTagCompound tag) {
        NBTTagList fluidTagList = new NBTTagList();
        for (int i = 0; i < this.getNumTanks(); ++i) {
            if (this.tanks[i] == null || this.tanks[i].getFluid() == null) continue;
            NBTTagCompound fluidTag = new NBTTagCompound();
            fluidTag.func_74768_a("tagIdx", i);
            this.tanks[i].getFluid().writeToNBT(fluidTag);
            fluidTagList.func_74742_a((NBTBase)fluidTag);
        }
        if (fluidTagList.func_74745_c() > 0) {
            tag.func_74782_a("fluids", (NBTBase)fluidTagList);
        }
        NBTTagList exposureTagList = new NBTTagList();
        for (int i = 0; i < 6; ++i) {
            if (this.tankExposure[i] == -1) continue;
            NBTTagCompound exposureTag = new NBTTagCompound();
            exposureTag.func_74768_a("exposureIdx", i);
            exposureTag.func_74768_a("direction", this.tankExposure[i]);
            exposureTagList.func_74742_a((NBTBase)exposureTag);
        }
        if (exposureTagList.func_74745_c() > 0) {
            tag.func_74782_a("fluidExposures", (NBTBase)exposureTagList);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.readFluidsFromNBT(tag);
    }

    @Override
    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        this.writeFluidsToNBT(tag);
    }

    @Override
    protected void onSendUpdate(NBTTagCompound updateTag) {
        super.onSendUpdate(updateTag);
        this.writeFluidsToNBT(updateTag);
    }

    @Override
    public void onReceiveUpdate(NBTTagCompound updateTag) {
        super.onReceiveUpdate(updateTag);
        this.readFluidsFromNBT(updateTag);
    }

    @Override
    public void onReceiveGuiButtonPress(String buttonName, DataInputStream dataStream) throws IOException {
        if (buttonName.equals("changeInvSide")) {
            int side = dataStream.readInt();
            if (this.tankExposure[side] != -1) {
                this.iterateFluidTankExposure(side);
            } else if (this.func_70302_i_() <= 0) {
                this.iterateFluidTankExposure(side);
            } else {
                boolean wasExposed = this.getExposedSlotFromReferenceSide(side) != -1;
                this.iterateInventoryExposure(side);
                if (wasExposed && this.getExposedSlotFromReferenceSide(side) == -1) {
                    this.iterateFluidTankExposure(side);
                }
            }
        } else {
            super.onReceiveGuiButtonPress(buttonName, dataStream);
        }
    }

    protected void iterateFluidTankExposure(int side) {
        int newExposure = this.tankExposure[side] == -1 ? 0 : this.tankExposure[side] + 1;
        if (newExposure >= this.getNumTanks()) {
            newExposure = -1;
        }
        this.setExposedTank(ForgeDirection.getOrientation((int)side), newExposure);
    }

    public abstract int getNumTanks();

    public abstract int getTankSize(int var1);

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int tankToFill = -1;
        tankToFill = from != ForgeDirection.UNKNOWN ? this.tankExposure[this.getRotatedSide(from.ordinal())] : this.getDefaultTankForFluid(resource.getFluid());
        if (tankToFill == -1) {
            return 0;
        }
        return this.fill(tankToFill, resource, doFill);
    }

    public int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (!this.isFluidValidForTank(tankIndex, resource)) {
            return 0;
        }
        int res = this.tanks[tankIndex].fill(resource, doFill);
        return res;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int tankToDrain = 0;
        if (from != ForgeDirection.UNKNOWN) {
            tankToDrain = this.tankExposure[this.getRotatedSide(from.ordinal())];
        }
        if (tankToDrain == -1) {
            return null;
        }
        return this.drain(tankToDrain, maxDrain, doDrain);
    }

    public FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.tanks[tankIndex].drain(maxDrain, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int tankToDrain = 0;
        if (from != ForgeDirection.UNKNOWN) {
            tankToDrain = this.tankExposure[this.getRotatedSide(from.ordinal())];
        }
        if (tankToDrain == -1) {
            return null;
        }
        if (!resource.isFluidEqual(this.tanks[tankToDrain].getFluid())) {
            return null;
        }
        return this.drain(tankToDrain, resource.amount, doDrain);
    }

    public IFluidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return this.tanks;
        }
        int exposure = this.tankExposure[this.getRotatedSide(direction.ordinal())];
        if (exposure == -1) {
            return kEmptyFluidTankList;
        }
        IFluidTank[] exposedTanks = new IFluidTank[]{this.tanks[exposure]};
        return exposedTanks;
    }

    public IFluidTank getTank(ForgeDirection direction, FluidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        int tankIdx = this.tankExposure[this.getRotatedSide(direction.ordinal())];
        if (tankIdx == -1) {
            return null;
        }
        FluidTank t = this.tanks[tankIdx];
        if (type == null || this.isFluidValidForTank(tankIdx, type)) {
            return t;
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        int tankIdx = 0;
        if (from != ForgeDirection.UNKNOWN) {
            tankIdx = this.tankExposure[this.getRotatedSide(from.ordinal())];
        }
        if (tankIdx == -1) {
            return false;
        }
        FluidTank tank = this.tanks[tankIdx];
        if (tank.getFluidAmount() <= 0) {
            return true;
        }
        return tank.getFluid().fluidID == fluid.getID();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int tankIdx = 0;
        if (from != ForgeDirection.UNKNOWN) {
            tankIdx = this.tankExposure[this.getRotatedSide(from.ordinal())];
        }
        if (tankIdx == -1) {
            return false;
        }
        FluidTank tank = this.tanks[tankIdx];
        if (tank.getFluidAmount() <= 0) {
            return false;
        }
        return tank.getFluid().fluidID == fluid.getID();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfo();
    }

    @Override
    public FluidTankInfo[] getTankInfo() {
        FluidTankInfo[] infos = new FluidTankInfo[this.tanks.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            infos[i] = this.tanks[i].getInfo();
        }
        return infos;
    }

    protected abstract boolean isFluidValidForTank(int var1, FluidStack var2);

    private void resetFluidExposures() {
        for (int i = 0; i < 6; ++i) {
            this.tankExposure[i] = -1;
        }
    }

    protected abstract int getDefaultTankForFluid(Fluid var1);
}

