/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.exnihilo;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.bdew.neiaddons.utils.ItemStackWithTip;
import net.bdew.neiaddons.utils.PositionedStackWithTip;
import net.minecraft.item.ItemStack;

public abstract class BaseRecipeHandler
extends TemplateRecipeHandler {
    public abstract String getRecipeName();

    public abstract String getRecipeId();

    public abstract List<ItemStack> getTools();

    public abstract boolean isValidTool(ItemStack var1);

    public abstract boolean isPossibleInput(ItemStack var1);

    public abstract boolean isPossibleOutput(ItemStack var1);

    public abstract List<ItemStackWithTip> getProcessingResults(ItemStack var1);

    public abstract List<ItemStack> getInputsFor(ItemStack var1);

    public abstract List<ItemStack> getAllValidInputs();

    private void addAllRecipes() {
        for (ItemStack source : this.getAllValidInputs()) {
            this.arecipes.add(new CachedExnihiloRecipe(source, this.getProcessingResults(source)));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            this.addAllRecipes();
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (!this.isPossibleOutput(result)) {
            return;
        }
        for (ItemStack source : this.getInputsFor(result)) {
            this.arecipes.add(new CachedExnihiloRecipe(source, this.getProcessingResults(source)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (this.isValidTool(ingredient)) {
            this.addAllRecipes();
        }
        if (!this.isPossibleInput(ingredient)) {
            return;
        }
        List<ItemStackWithTip> drops = this.getProcessingResults(ingredient);
        if (drops.size() > 0) {
            this.arecipes.add(new CachedExnihiloRecipe(ingredient, drops));
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(27, 31, 22, 15), this.getRecipeId(), new Object[0]));
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        if (stack != null) {
            for (PositionedStackWithTip x : ((CachedExnihiloRecipe)((Object)this.arecipes.get((int)recipe))).output) {
                if (!gui.isMouseOver((PositionedStack)x, recipe)) continue;
                currenttip.addAll(x.tip);
            }
        }
        return super.handleTooltip(gui, currenttip, recipe);
    }

    public String getGuiTexture() {
        return "neiaddons:textures/gui/exnihilo.png";
    }

    public class CachedExnihiloRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack tool;
        PositionedStack input;
        List<PositionedStackWithTip> output;

        public CachedExnihiloRecipe(ItemStack source, List<ItemStackWithTip> drops) {
            super((TemplateRecipeHandler)BaseRecipeHandler.this);
            this.tool = new PositionedStack(BaseRecipeHandler.this.getTools(), 30, 13);
            this.input = new PositionedStack((Object)source, 3, 24);
            this.output = new ArrayList<PositionedStackWithTip>();
            int pos = 0;
            for (ItemStackWithTip x : drops) {
                this.output.add(new PositionedStackWithTip(x, 57 + pos % 6 * 18, 6 + pos / 6 * 18));
                ++pos;
            }
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public ArrayList<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
            if (this.output.size() > 1) {
                for (int i = 1; i < this.output.size(); ++i) {
                    list.add(this.output.get(i));
                }
            }
            this.tool.setPermutationToRender(BaseRecipeHandler.this.cycleticks / 20 % BaseRecipeHandler.this.getTools().size());
            list.add(this.tool);
            return list;
        }

        public PositionedStack getResult() {
            if (this.output.size() > 0) {
                return this.output.get(0);
            }
            return null;
        }
    }
}

