/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.utils;

import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.OffsetPositioner;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.DefaultOverlayRenderer;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.List;
import net.bdew.neiaddons.ClientHandler;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.PacketHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CustomOverlayHandler
implements IOverlayHandler {
    private boolean invert;
    private String command;
    private int xOffs;
    private int yOffs;
    private Class<? extends Slot> craftingSlot;

    public CustomOverlayHandler(String command, int xOffs, int yOffs, boolean invert, Class<? extends Slot> craftingSlot) {
        this.command = command;
        this.xOffs = xOffs;
        this.yOffs = yOffs;
        this.craftingSlot = craftingSlot;
    }

    private Slot findMatchingSlot(GuiContainer cont, PositionedStack pstack) {
        for (Object slotob : cont.field_74193_d.field_75151_b) {
            Slot slot = (Slot)slotob;
            if (slot.field_75223_e != pstack.relx + this.xOffs || slot.field_75221_f != pstack.rely + this.yOffs) continue;
            return slot;
        }
        NEIAddons.logWarning("Failed to find matching slot - (%d,%d) in %s", pstack.relx + this.xOffs, pstack.rely + this.yOffs, cont.toString());
        return null;
    }

    private Boolean isValidSlot(Slot slot) {
        return slot.field_75224_c == Minecraft.func_71410_x().field_71439_g.field_71071_by || slot.getClass() == Slot.class;
    }

    private Slot findItem(GuiContainer cont, PositionedStack p) {
        for (ItemStack teststack : p.items) {
            for (Object slotob : cont.field_74193_d.field_75151_b) {
                ItemStack stack;
                Slot slot = (Slot)slotob;
                if (!this.isValidSlot(slot).booleanValue() || (stack = slot.func_75211_c()) == null || !NEIServerUtils.areStacksSameType((ItemStack)stack, (ItemStack)teststack)) continue;
                return slot;
            }
        }
        return null;
    }

    public void overlayRecipe(GuiContainer cont, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        List ingr = recipe.getIngredientStacks(recipeIndex);
        if (this.invert) {
            boolean bl = shift = !shift;
        }
        if (!shift) {
            OffsetPositioner positioner = new OffsetPositioner(this.xOffs, this.yOffs);
            DefaultOverlayRenderer renderer = new DefaultOverlayRenderer(ingr, (IStackPositioner)positioner);
            LayoutManager.overlayRenderer = renderer;
        } else if (ClientHandler.enabledCommands.contains(this.command)) {
            NBTTagList stacksnbt = new NBTTagList();
            for (int i = 0; i < ingr.size(); ++i) {
                PositionedStack pstack = (PositionedStack)ingr.get(i);
                if (pstack != null) {
                    int x = (pstack.relx - 25) / 18;
                    int y = (pstack.rely - 6) / 18;
                    ItemStack stack = pstack.item;
                    NBTTagCompound stacknbt = stack.func_77955_b(new NBTTagCompound());
                    stacknbt.func_74768_a("slot", y * 3 + x);
                    stacksnbt.func_74742_a((NBTBase)stacknbt);
                }
                ItemStack stack = recipe.getResultStack((int)recipeIndex).items[0];
                NBTTagCompound stacknbt = stack.func_77955_b(new NBTTagCompound());
                stacknbt.func_74768_a("slot", 9);
                stacksnbt.func_74742_a((NBTBase)stacknbt);
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74782_a("stacks", (NBTBase)stacksnbt);
            PacketHelper.sendToServer(this.command, data);
        } else {
            if (NEIClientUtils.getHeldItem() != null) {
                return;
            }
            NEIAddons.logInfo("Don't have server support, moving recipe manually", new Object[0]);
            for (Object slotob : cont.field_74193_d.field_75151_b) {
                if (!this.craftingSlot.isInstance(slotob)) continue;
                Slot slot = (Slot)slotob;
                cont.sendMouseClick(slot, slot.field_75222_d, 0, 0);
            }
            for (int i = 0; i < ingr.size(); ++i) {
                Slot slotFrom;
                Slot slotTo;
                PositionedStack pstack = (PositionedStack)ingr.get(i);
                if (pstack == null || (slotTo = this.findMatchingSlot(cont, pstack)) == null || (slotFrom = this.findItem(cont, pstack)) == null) continue;
                NEIAddons.logInfo("Moving from slot %s[%d] to %s[%d]", slotFrom.toString(), slotFrom.field_75222_d, slotTo.toString(), slotTo.field_75222_d);
                cont.sendMouseClick(slotFrom, slotFrom.field_75222_d, 0, 0);
                cont.sendMouseClick(slotTo, slotTo.field_75222_d, 1, 0);
                cont.sendMouseClick(slotFrom, slotFrom.field_75222_d, 0, 0);
            }
        }
    }
}

