/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.growthcraft.action;

import growthcraft.api.fishtrap.FishTrapEntry;
import modtweaker.growthcraft.GrowthcraftHacks;
import modtweaker.growthcraft.action.FishTrapAddLootAction;
import modtweaker.util.ItemHelper;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItemStack;

public class FishTrapRemoveLootAction
implements IUndoableAction {
    private final TweakerItemStack result;
    private final FishTrapAddLootAction.Rarity rarity;
    private FishTrapEntry entry;

    public FishTrapRemoveLootAction(TweakerItemStack output, FishTrapAddLootAction.Rarity rarity) {
        this.result = output;
        this.rarity = rarity;
    }

    public void apply() {
        if (this.rarity == FishTrapAddLootAction.Rarity.FISH) {
            for (FishTrapEntry e : GrowthcraftHacks.fishList) {
                if (!ItemHelper.areEqual(this.result.get(), e.fishable)) continue;
                this.entry = e;
                break;
            }
            GrowthcraftHacks.fishList.remove(this.entry);
        } else if (this.rarity == FishTrapAddLootAction.Rarity.JUNK) {
            for (FishTrapEntry e : GrowthcraftHacks.junkList) {
                if (!ItemHelper.areEqual(this.result.get(), e.fishable)) continue;
                this.entry = e;
                break;
            }
            GrowthcraftHacks.junkList.remove(this.entry);
        } else if (this.rarity == FishTrapAddLootAction.Rarity.TREASURE) {
            for (FishTrapEntry e : GrowthcraftHacks.treasureList) {
                if (!ItemHelper.areEqual(this.result.get(), e.fishable)) continue;
                this.entry = e;
                break;
            }
            GrowthcraftHacks.treasureList.remove(this.entry);
        }
    }

    public boolean canUndo() {
        switch (this.rarity) {
            case FISH: {
                return GrowthcraftHacks.fishList != null;
            }
            case TREASURE: {
                return GrowthcraftHacks.treasureList != null;
            }
            case JUNK: {
                return GrowthcraftHacks.junkList != null;
            }
        }
        return false;
    }

    public void undo() {
        switch (this.rarity) {
            case FISH: {
                GrowthcraftHacks.fishList.add(this.entry);
                break;
            }
            case TREASURE: {
                GrowthcraftHacks.treasureList.add(this.entry);
                break;
            }
            case JUNK: {
                GrowthcraftHacks.junkList.add(this.entry);
            }
        }
    }

    public String describe() {
        return "Removing Growthcraft Loot: " + this.result.getDisplayName() + " from " + this.rarity.name().toLowerCase();
    }

    public String describeUndo() {
        return "Restoring Growthcraft Loot: " + this.result.getDisplayName() + " from " + this.rarity.name().toLowerCase();
    }
}

