/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mariculture.action;

import mariculture.api.core.FuelInfo;
import mariculture.core.helpers.OreDicHelper;
import modtweaker.mariculture.MaricultureHacks;
import modtweaker.util.ItemHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;

public class CrucibleRemoveFuelAction
implements IUndoableAction {
    private final Object fuel;
    private FuelInfo info;

    public CrucibleRemoveFuelAction(Object fuel) {
        this.fuel = fuel;
    }

    public void apply() {
        String key = null;
        if (this.fuel instanceof ItemStack) {
            key = OreDicHelper.convert((Object)((ItemStack)this.fuel));
        }
        if (this.fuel instanceof FluidStack) {
            key = ItemHelper.getName((FluidStack)this.fuel);
        }
        this.info = (FuelInfo)MaricultureHacks.fuels.get(this.fuel);
        if (key != null) {
            MaricultureHacks.fuels.remove(key);
        }
    }

    public boolean canUndo() {
        return MaricultureHacks.fuels != null;
    }

    public void undo() {
        MaricultureHacks.fuels.put(this.fuel, this.info);
    }

    public String asString() {
        if (this.fuel instanceof ItemStack) {
            return ((ItemStack)this.fuel).func_82833_r();
        }
        if (this.fuel instanceof FluidStack) {
            return ((FluidStack)this.fuel).getFluid().getLocalizedName();
        }
        return "";
    }

    public String describe() {
        return "Removing Crucible Furnace Fuel: " + this.asString();
    }

    public String describeUndo() {
        return "Restoring Crucible Furnace Fuel: " + this.asString();
    }
}

