/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mariculture.action;

import java.util.Arrays;
import java.util.List;
import mariculture.api.core.RecipeVat;
import modtweaker.mariculture.MaricultureHacks;
import modtweaker.util.ItemHelper;
import stanhebben.minetweaker.api.IUndoableAction;

public class VatAddRecipeAction
implements IUndoableAction {
    private List<? extends Object> key;
    private final RecipeVat recipe;

    public VatAddRecipeAction(RecipeVat recipe) {
        this.recipe = recipe;
    }

    public void apply() {
        this.key = this.recipe.inputFluid2 != null && this.recipe.inputItem != null ? Arrays.asList(ItemHelper.getName(this.recipe.inputFluid1), ItemHelper.getName(this.recipe.inputFluid2), ItemHelper.getName(this.recipe.inputItem)) : (this.recipe.inputItem != null ? Arrays.asList(ItemHelper.getName(this.recipe.inputFluid1), ItemHelper.getName(this.recipe.inputItem)) : (this.recipe.inputFluid2 != null ? Arrays.asList(ItemHelper.getName(this.recipe.inputFluid1), ItemHelper.getName(this.recipe.inputFluid2)) : Arrays.asList(this.recipe.inputFluid1)));
        MaricultureHacks.vat.put(this.key, this.recipe);
    }

    public boolean canUndo() {
        return MaricultureHacks.vat != null;
    }

    public void undo() {
        MaricultureHacks.vat.remove(this.key);
    }

    public String asString(RecipeVat vat) {
        String str = "";
        if (vat.inputFluid1 != null) {
            str = str + vat.inputFluid1.getFluid().getLocalizedName();
        }
        if (vat.inputFluid2 != null) {
            str = str + " + " + vat.inputFluid2.getFluid().getLocalizedName();
        }
        if (vat.inputItem != null) {
            str = str + " + " + vat.inputItem.func_82833_r();
        }
        str = str + " = ";
        if (vat.outputFluid != null) {
            str = str + " " + vat.outputFluid.getFluid().getLocalizedName();
        }
        if (vat.outputItem != null) {
            str = str + (vat.outputFluid == null ? "" : " + ") + vat.outputItem.func_82833_r();
        }
        return str;
    }

    public String describe() {
        return "Adding Vat Recipe: " + this.asString(this.recipe);
    }

    public String describeUndo() {
        return "Removing Vat Recipe: " + this.asString(this.recipe);
    }
}

