/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mekanism;

import java.util.Iterator;
import java.util.Map;
import mekanism.api.ChanceOutput;
import mekanism.api.ChemicalPair;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfusionOutput;
import mekanism.common.recipe.RecipeHandler;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;

public class MekanismRemoveRecipeAction
implements IUndoableAction {
    public Object input;
    public Object output;
    public final Object tmpOutput;
    public final RecipeHandler.Recipe handler;

    public MekanismRemoveRecipeAction(RecipeHandler.Recipe handler, Object output) {
        this.handler = handler;
        this.output = output;
        this.tmpOutput = output;
    }

    public void apply() {
        try {
            Iterator it = this.handler.get().entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pairs = it.next();
                Object value = pairs.getValue();
                if (value != null) {
                    ChemicalPair par2;
                    ChemicalPair par1;
                    if (this.tmpOutput instanceof ItemStack && value instanceof ItemStack && ((ItemStack)this.tmpOutput).func_77969_a((ItemStack)value)) {
                        this.input = pairs.getKey();
                        break;
                    }
                    if (this.tmpOutput instanceof FluidStack && value instanceof FluidStack && ((FluidStack)this.tmpOutput).isFluidEqual((FluidStack)value)) {
                        this.input = pairs.getKey();
                        break;
                    }
                    if (this.tmpOutput instanceof GasStack && value instanceof GasStack && ((GasStack)this.tmpOutput).isGasEqual((GasStack)value)) {
                        this.input = pairs.getKey();
                        break;
                    }
                    if (this.tmpOutput instanceof ItemStack && value instanceof InfusionOutput && ((ItemStack)this.tmpOutput).func_77969_a(((InfusionOutput)value).resource)) {
                        this.input = pairs.getKey();
                        break;
                    }
                    if (this.tmpOutput instanceof ChemicalPair && value instanceof ChemicalPair) {
                        par1 = (ChemicalPair)this.tmpOutput;
                        par2 = (ChemicalPair)value;
                        if (par1.leftGas.isGasEqual(par2.leftGas) && par1.rightGas.isGasEqual(par2.rightGas)) {
                            this.input = pairs.getKey();
                            break;
                        }
                    }
                    if (this.tmpOutput instanceof ChanceOutput && value instanceof ChanceOutput) {
                        par1 = (ChanceOutput)this.tmpOutput;
                        par2 = (ChanceOutput)value;
                        if (par1.primaryOutput.func_77969_a(par2.primaryOutput) && (par1.secondaryOutput == null || par1.secondaryOutput != null && par2.secondaryOutput != null && par1.secondaryOutput.func_77969_a(par2.secondaryOutput))) {
                            this.input = pairs.getKey();
                            break;
                        }
                    }
                }
                it.remove();
            }
            this.output = this.handler.get().get(this.input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.handler.get().remove(this.input);
    }

    public boolean canUndo() {
        return this.handler.get() != null;
    }

    public void undo() {
        this.handler.put(this.input, this.output);
    }

    public String describe() {
        if (this.output instanceof ItemStack) {
            return "Removing Mekanism Recipe: " + this.handler.toString() + " : " + ((ItemStack)this.output).func_82833_r();
        }
        if (this.output instanceof FluidStack) {
            return "Removing Mekanism Recipe: " + this.handler.toString() + " : " + ((FluidStack)this.output).getFluid().getName();
        }
        if (this.output instanceof GasStack) {
            return "Removing Mekanism Recipe: " + this.handler.toString() + " : " + ((GasStack)this.output).getGas().getName();
        }
        return "Removing Mekanism Recipe: " + this.output.toString();
    }

    public String describeUndo() {
        if (this.output instanceof ItemStack) {
            return "Restoring Mekanism Recipe: " + this.handler.toString() + " : " + ((ItemStack)this.output).func_82833_r();
        }
        if (this.output instanceof FluidStack) {
            return "Restoring Mekanism Recipe: " + this.handler.toString() + " : " + ((FluidStack)this.output).getFluid().getName();
        }
        if (this.output instanceof GasStack) {
            return "Restoring Mekanism Recipe: " + this.handler.toString() + " : " + ((GasStack)this.output).getGas().getName();
        }
        return "Restoring Mekanism Recipe: " + this.output.toString();
    }
}

