/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.tconstruct;

import modtweaker.tconstruct.TConstructHacks;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;
import tconstruct.library.crafting.AlloyMix;
import tconstruct.library.crafting.Smeltery;

public class AlloyAddRecipe
extends TweakerBaseFunction {
    public static final AlloyAddRecipe INSTANCE = new AlloyAddRecipe();

    private AlloyAddRecipe() {
        super("tconstruct.smeltery.addAlloy");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(2, args)) {
            FluidStack output = TweakerHelper.getFluid();
            FluidStack[] input = TweakerHelper.getFluids();
            Tweaker.apply((IUndoableAction)new Action(output, input));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 2);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final FluidStack output;
        private final FluidStack[] mixers;

        public Action(FluidStack output, FluidStack[] mixers) {
            this.output = output;
            this.mixers = mixers;
        }

        public void apply() {
            Smeltery.addAlloyMixing((FluidStack)this.output, (FluidStack[])this.mixers);
        }

        public boolean canUndo() {
            return TConstructHacks.alloys != null;
        }

        public void undo() {
            int k;
            for (k = 0; k < TConstructHacks.alloys.size(); ++k) {
                int i;
                AlloyMix mix = TConstructHacks.alloys.get(k);
                if (!mix.result.isFluidStackIdentical(this.output)) continue;
                int j = 0;
                for (i = 0; i < mix.mixers.size(); ++i) {
                    FluidStack stack = (FluidStack)mix.mixers.get(i);
                    if (i >= this.mixers.length || !stack.isFluidStackIdentical(this.mixers[i])) continue;
                    ++j;
                }
                if (j == i) break;
            }
            TConstructHacks.alloys.remove(k);
        }

        public String describe() {
            return "Adding Alloy Recipe: " + this.output.getFluid().getLocalizedName();
        }

        public String describeUndo() {
            return "Removing Alloy Recipe: " + this.output.getFluid().getLocalizedName();
        }
    }
}

