/*
 * Decompiled with CFR 0.152.
 */
package appeng.common;

import appeng.api.Blocks;
import appeng.api.IAppEngApi;
import appeng.api.Materials;
import appeng.api.Util;
import appeng.common.AppEngApi;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngRegistration;
import appeng.common.AppEngWorldSettings;
import appeng.common.VersionChecker;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.common.grid.MEGridEvents;
import appeng.common.network.AppEngClientPacketHandler;
import appeng.common.network.AppEngConnectionHandler;
import appeng.common.network.AppEngServerPacketHandler;
import appeng.common.registries.entries.AppEngHandler;
import appeng.common.registries.entries.BasicCellHandler;
import appeng.common.registries.entries.BasicTerminalHandler;
import appeng.common.registries.entries.CreativeCellHandler;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IAEMod;
import appeng.me.cache.P2PCache;
import appeng.me.cache.SpatialPylonCache;
import appeng.me.tile.TileTransitionPlane;
import appeng.proxy.IProxyBC;
import appeng.proxy.IProxyBS;
import appeng.proxy.IProxyFactorization;
import appeng.proxy.IProxyForestry;
import appeng.proxy.IProxyGregTech;
import appeng.proxy.IProxyIC2;
import appeng.proxy.IProxyLP;
import appeng.proxy.IProxyMFR;
import appeng.proxy.IProxyMekanism;
import appeng.proxy.IProxyTE;
import appeng.proxy.IProxyUE;
import appeng.proxy.ProxyBC;
import appeng.proxy.ProxyBS;
import appeng.proxy.ProxyFactorization;
import appeng.proxy.ProxyForestry;
import appeng.proxy.ProxyGregTech;
import appeng.proxy.ProxyIC2;
import appeng.proxy.ProxyLP;
import appeng.proxy.ProxyMFR;
import appeng.proxy.ProxyMekanism;
import appeng.proxy.ProxyTE;
import appeng.proxy.ProxyUE;
import appeng.proxy.helpers.BCPipeHandler;
import appeng.proxy.helpers.BSCrateHandler;
import appeng.proxy.helpers.FacadeProxyNull;
import appeng.proxy.helpers.FactorizationHandler;
import appeng.proxy.helpers.GregTechHandler;
import appeng.proxy.helpers.IFacadeProxy;
import appeng.proxy.helpers.MFRDSUHandler;
import appeng.recipes.AERecipes;
import appeng.recipes.AETrading;
import appeng.recipes.OreDictionaryHandler;
import appeng.render.AppEngBlockRenderer;
import appeng.render.MERenderEvents;
import appeng.sided.AEGenericTick;
import appeng.sided.ClientSide;
import appeng.sided.IAESidedProxy;
import appeng.sided.ServerSide;
import appeng.util.AEItemStack;
import appeng.util.Platform;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.xcompwiz.mystcraft.api.MystAPI;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IConnectionHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import portalgun.api.Api;

@Mod(modid="AppliedEnergistics", name="Applied Energistics", version="rv14.finale3", dependencies="required-after:AppliedEnergistics-Core;required-after:Forge@[9.10.1.870,)")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"AE"}, packetHandler=AppEngClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"AE"}, packetHandler=AppEngServerPacketHandler.class))
public class AppEng
implements IWorldGenerator,
IAEMod {
    public static final String dependencies = "required-after:AppliedEnergistics-Core;required-after:Forge@[9.10.1.870,)";
    public boolean buildCraftMode = false;
    private static AppEng myInstance = null;
    public final IFacadeProxy nFacadeProxy = new FacadeProxyNull();
    public AppEngConfiguration config;
    public String currentVersion;
    public Thread vc;
    public MEGridEvents GridManager;
    public OreDictionaryHandler oreDictionary;
    public IProxyIC2 IC2Proxy;
    public IProxyTE TEProxy;
    public IProxyBC BCProxy;
    public IProxyLP LPProxy;
    public IProxyFactorization FactorizationProxy;
    public IProxyGregTech GregTechProxy;
    public IProxyMFR MFRProxy;
    public IProxyUE UEProxy;
    public IProxyBS BSProxy;
    public IProxyForestry ForestryProxy;
    public IProxyMekanism MekanismProxy;
    public AppEngRegistration registration;
    public AERecipes ReceipDefinitions;
    private AppEngApi ApiInstance;
    long totalStartTime = 0L;
    public AEGenericTick AEGenericTick_client;
    public AEGenericTick AEGenericTick_server;
    public IAESidedProxy SideProxy;

    public static AppEng getInstance() {
        return myInstance;
    }

    public static IAppEngApi getApiInstance() {
        return AppEng.getInstance().ApiInstance;
    }

    public AppEng() {
        myInstance = this;
    }

    public static void log(String msg) {
        if (AppEngConfiguration.allowLogging) {
            FMLLog.info((String)("[AppEng] " + msg), (Object[])new Object[0]);
        }
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new AppEngConfiguration(event.getSuggestedConfigurationFile());
        this.currentVersion = "rv14.finale3";
        this.ApiInstance = new AppEngApi();
        Util.getAppEngApi();
        if (AppEngConfiguration.enableVersionChecker) {
            this.vc = new Thread(new VersionChecker(this.config.lastLoaded));
            this.vc.start();
        }
        try {
            InputStream is = this.getClass().getResourceAsStream("/assets/appeng/lang/lang.list");
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while (in.ready()) {
                String lang = in.readLine();
                LanguageRegistry.instance().loadLocalization("/assets/appeng/lang/" + lang + ".properties", lang, false);
            }
        }
        catch (Exception e) {
            String lang = "en_US";
            LanguageRegistry.instance().loadLocalization("/assets/appeng/lang/" + lang + ".properties", lang, false);
        }
    }

    @Override
    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.registration = new AppEngRegistration();
        this.registration.registerBlocks(this.config);
        long StartTime = System.currentTimeMillis();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)AppEngGuiHandler.GUI_Handler);
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new AppEngBlockRenderer());
        MinecraftForge.EVENT_BUS.register((Object)AppEng.getApiInstance().getLocateableRegistry());
        AppEng.getApiInstance().getWirelessRegistry().registerWirelessHandler(new BasicTerminalHandler());
        this.AEGenericTick_server = new AEGenericTick();
        TickRegistry.registerTickHandler((ITickHandler)this.AEGenericTick_server, (Side)Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)this.AEGenericTick_server);
        this.oreDictionary = new OreDictionaryHandler();
        MinecraftForge.EVENT_BUS.register((Object)this.oreDictionary);
        this.GridManager = new MEGridEvents();
        TickRegistry.registerTickHandler((ITickHandler)this.GridManager, (Side)Side.SERVER);
        MinecraftForge.EVENT_BUS.register((Object)this.GridManager);
        if (Platform.isClient()) {
            MERenderEvents re = new MERenderEvents();
            TickRegistry.registerTickHandler((ITickHandler)re, (Side)Side.CLIENT);
            this.AEGenericTick_client = new AEGenericTick();
            TickRegistry.registerTickHandler((ITickHandler)this.AEGenericTick_client, (Side)Side.CLIENT);
            MinecraftForge.EVENT_BUS.register((Object)this.AEGenericTick_client);
            MinecraftForge.EVENT_BUS.register((Object)re);
            this.SideProxy = new ClientSide();
        } else {
            this.SideProxy = new ServerSide();
        }
        this.SideProxy.initSided();
        this.registration.registerItems(this.config);
        NetworkRegistry.instance().registerConnectionHandler((IConnectionHandler)new AppEngConnectionHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)this);
        this.registration.initWorld(this.config, false);
        OreDictionary.registerOre((String)"oreCertusQuartz", (ItemStack)Blocks.blkQuartzOre);
        OreDictionary.registerOre((String)"crystalCertusQuartz", (ItemStack)Materials.matQuartz);
        OreDictionary.registerOre((String)"dustCertusQuartz", (ItemStack)Materials.matQuartzDust);
        OreDictionary.registerOre((String)"dustNetherQuartz", (ItemStack)Materials.matQuartzDustNether);
        OreDictionary.registerOre((String)"dustEnderPearl", (ItemStack)Materials.matEnderPearlDust);
        OreDictionary.registerOre((String)"dustGold", (ItemStack)Materials.matGoldDust);
        OreDictionary.registerOre((String)"dustIron", (ItemStack)Materials.matIronDust);
        OreDictionary.registerOre((String)"dustWheat", (ItemStack)Materials.matFlour);
        for (int x = 0; x < AppEngConfiguration.blackListTransition.length; ++x) {
            FMLInterModComms.sendMessage((String)"AppliedEnergistics", (String)"blacklist-transitionplane", (String)AppEngConfiguration.blackListTransition[x].replace(':', ','));
        }
        FMLInterModComms.sendMessage((String)"AppliedEnergistics", (String)"blacklist-transitionplane", (String)(Block.field_71986_z.field_71990_ca + ""));
        if (AppEngConfiguration.enableVillagerTrading) {
            VillagerRegistry.instance().registerVillageTradeHandler(3, (VillagerRegistry.IVillageTradeHandler)new AETrading());
        }
        this.totalStartTime += System.currentTimeMillis() - StartTime;
    }

    @Override
    @Mod.EventHandler
    public void processIMC(FMLInterModComms.IMCEvent event) {
        Splitter splitter = Splitter.on((String)",").trimResults();
        for (FMLInterModComms.IMCMessage m : event.getMessages()) {
            Integer n;
            Integer n2;
            Integer inMeta;
            Integer inId;
            String[] array = (String[])Iterables.toArray((Iterable)splitter.split((CharSequence)m.getStringValue()), String.class);
            if (m.key.equals("moveabletile") || m.key.equals("movabletile")) {
                if (array.length == 1) {
                    try {
                        Class<?> c = Class.forName(array[0]);
                        AppEng.getApiInstance().getMovableRegistry().whiteListTileEntity(c);
                    }
                    catch (Throwable t) {
                        FMLLog.severe((String)"[AppEng] Unable to whitelist tile entity, error follows.", (Object[])new Object[0]);
                        t.printStackTrace();
                    }
                    continue;
                }
                FMLLog.severe((String)"[AppEng] invalid argument for ICM movabletile", (Object[])new Object[0]);
                continue;
            }
            if (m.key.equals("blacklist-cell")) {
                if (array.length == 0 || array.length > 2) {
                    FMLLog.warning((String)"[AppEng] IMC failed - blacklist-cell itemid[,meta]", (Object[])new Object[0]);
                    continue;
                }
                inId = Ints.tryParse((String)array[0]);
                inMeta = array.length > 1 ? Ints.tryParse((String)array[1]) : Short.MAX_VALUE;
                if (inId == null || inMeta == null) {
                    FMLLog.warning((String)"[AppEng] IMC failed - blacklist-cell itemid[,meta]", (Object[])new Object[0]);
                    continue;
                }
                if (inMeta == null) {
                    inMeta = 0;
                    while (inMeta < 16) {
                        Util.addBasicBlackList(inId, inMeta);
                        n2 = inMeta;
                        n = inMeta = Integer.valueOf(inMeta + 1);
                    }
                    continue;
                }
                Util.addBasicBlackList(inId, inMeta);
                continue;
            }
            if (m.key.equals("blacklist-transitionplane")) {
                if (array.length == 0 || array.length > 2) {
                    FMLLog.warning((String)"[AppEng] IMC failed - blacklist-transitionplane expects items[,meta]", (Object[])new Object[0]);
                    continue;
                }
                inId = Ints.tryParse((String)array[0]);
                Integer n3 = inMeta = array.length > 1 ? Ints.tryParse((String)array[1]) : null;
                if (inId == null) {
                    FMLLog.warning((String)"[AppEng] IMC failed - blacklist-transitionplane expects items[,meta]", (Object[])new Object[0]);
                    continue;
                }
                if (inMeta == null) {
                    inMeta = 0;
                    while (inMeta < 16) {
                        TileTransitionPlane.blacklist(inId, inMeta);
                        n2 = inMeta;
                        n = inMeta = Integer.valueOf(inMeta + 1);
                    }
                    continue;
                }
                TileTransitionPlane.blacklist(inId, inMeta);
                continue;
            }
            if (m.key.equals("add-grindable")) {
                if (array.length != 5) {
                    FMLLog.warning((String)"[AppEng] IMC failed - add-grindable expects itemid,meta,itemid,meta,rotations", (Object[])new Object[0]);
                    continue;
                }
                inId = Ints.tryParse((String)array[0]);
                inMeta = Ints.tryParse((String)array[1]);
                Integer outId = Ints.tryParse((String)array[2]);
                Integer outMeta = Ints.tryParse((String)array[3]);
                Integer effort = Ints.tryParse((String)array[4]);
                if (inId == null || inMeta == null || outId == null || outMeta == null || effort == null) {
                    FMLLog.warning((String)"[AppEng] IMC failed - add-grindable expects itemid,meta,itemid,meta,rotations", (Object[])new Object[0]);
                    continue;
                }
                ItemStack i = new ItemStack(inId.intValue(), 1, inMeta.intValue());
                ItemStack o = new ItemStack(outId.intValue(), 1, outMeta.intValue());
                this.ApiInstance.getGrinderRecipeManage().addRecipe(i, o, effort);
                continue;
            }
            FMLLog.warning((String)("[AppEng] IMC failed - " + m.key + " - is not a valid ICM for AE."), (Object[])new Object[0]);
        }
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ItemStack dustRecipe;
        long StartTime = System.currentTimeMillis();
        this.ReceipDefinitions = new AERecipes();
        this.config.confirmOwnership();
        Util.getExternalStorageRegistry().addExternalStorageInterface(new AppEngHandler());
        SpatialPylonCache.index = this.ApiInstance.getGridCacheRegistry().registerGridCache(SpatialPylonCache.class);
        P2PCache.index = this.ApiInstance.getGridCacheRegistry().registerGridCache(P2PCache.class);
        Util.getCellRegistry().addCellHandler(new BasicCellHandler());
        Util.getCellRegistry().addCellHandler(new CreativeCellHandler());
        ItemStack isA = Materials.matQuartz.func_77946_l();
        ItemStack isB = Materials.matQuartzDust.func_77946_l();
        ChestGenHooks d = ChestGenHooks.getInfo((String)"mineshaftCorridor");
        d.addItem(new WeightedRandomChestContent(isA, 1, 4, 2));
        d.addItem(new WeightedRandomChestContent(isB, 1, 4, 2));
        try {
            this.BCProxy = new ProxyBC();
            this.BCProxy.addFacade(Blocks.blkQuartz);
            Util.getExternalStorageRegistry().addExternalStorageInterface(new BCPipeHandler());
            FMLLog.info((String)"[AppEng] BC Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] BC Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.LPProxy = new ProxyLP();
            FMLLog.info((String)"[AppEng] LP Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] LP Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.GregTechProxy = new ProxyGregTech();
            Util.getExternalStorageRegistry().addExternalStorageInterface(new GregTechHandler());
            FMLLog.info((String)"[AppEng] GregTech Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] GregTech Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.FactorizationProxy = new ProxyFactorization();
            Util.getExternalStorageRegistry().addExternalStorageInterface(new FactorizationHandler());
            FMLLog.info((String)"[AppEng] Factorization Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] Factorization Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.MFRProxy = new ProxyMFR();
            Util.getExternalStorageRegistry().addExternalStorageInterface(new MFRDSUHandler());
            FMLLog.info((String)"[AppEng] Mine Factory Reloaded Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] Mine Factory Reloaded Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.BSProxy = new ProxyBS();
            Util.getExternalStorageRegistry().addExternalStorageInterface(new BSCrateHandler());
            FMLLog.info((String)"[AppEng] Better Storage Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] Better Storage Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.UEProxy = new ProxyUE();
            FMLLog.info((String)"[AppEng] Universal Electricity Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] Universal Electricity Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.IC2Proxy = new ProxyIC2();
            this.IC2Proxy.addMaceratorRecipe(new ItemStack(Item.field_77685_T, 1), Materials.matFlour);
            this.IC2Proxy.addMaceratorRecipe(Blocks.blkQuartzOre, Materials.matQuartz);
            this.IC2Proxy.addMaceratorRecipe(Materials.matQuartz, Materials.matQuartzDust);
            this.IC2Proxy.addMaceratorRecipe(new ItemStack(Item.field_77730_bn, 1), Materials.matEnderPearlDust);
            this.IC2Proxy.addCompressorRecipe(Materials.matQuartzDust, Materials.matQuartz);
            if (!AppEngConfiguration.disableNetherQuartzRecipes) {
                dustRecipe = Materials.matQuartzDustNether.func_77946_l();
                dustRecipe.field_77994_a = 1;
                this.IC2Proxy.addMaceratorRecipe(new ItemStack(Item.field_94583_ca), dustRecipe);
                this.IC2Proxy.addCompressorRecipe(dustRecipe, new ItemStack(Item.field_94583_ca));
            }
            FMLLog.info((String)"[AppEng] IC Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] IC Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.MekanismProxy = new ProxyMekanism();
            this.MekanismProxy.addMaceratorRecipe(new ItemStack(Item.field_77685_T, 1), Materials.matFlour);
            this.MekanismProxy.addMaceratorRecipe(Blocks.blkQuartzOre, Materials.matQuartz);
            this.MekanismProxy.addMaceratorRecipe(Materials.matQuartz, Materials.matQuartzDust);
            this.MekanismProxy.addMaceratorRecipe(new ItemStack(Item.field_77730_bn, 1), Materials.matEnderPearlDust);
            if (!AppEngConfiguration.disableNetherQuartzRecipes) {
                this.MekanismProxy.addMaceratorRecipe(new ItemStack(Item.field_94583_ca), Materials.matQuartzDustNether);
            }
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] Mekanism Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.ForestryProxy = new ProxyForestry();
            AppEng.getApiInstance().getSpecialComparsonRegistry().addComparisonProvider(this.ForestryProxy.getGeneticsComparisonProvider());
            FMLLog.info((String)"[AppEng] Forestry Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] Forestry Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            MystAPI.symbol.blacklistIdentifier("Biome" + this.registration.storageBiome.field_76756_M);
            FMLLog.info((String)"[AppEng] MystCraft Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] MystCraft Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        try {
            this.TEProxy = new ProxyTE();
            this.TEProxy.addPulverizerRecipe(80, new ItemStack(Item.field_77685_T, 1), Materials.matFlour);
            this.TEProxy.addPulverizerRecipe(240, Blocks.blkQuartzOre, Materials.matQuartz, Materials.matQuartzDust);
            this.TEProxy.addPulverizerRecipe(240, Materials.matQuartz, Materials.matQuartzDust);
            this.TEProxy.addPulverizerRecipe(240, new ItemStack(Item.field_77730_bn, 1), Materials.matEnderPearlDust);
            dustRecipe = Materials.matQuartzDustNether.func_77946_l();
            dustRecipe.field_77994_a = 1;
            if (!AppEngConfiguration.disableNetherQuartzRecipes) {
                this.TEProxy.addPulverizerRecipe(240, new ItemStack(Item.field_94583_ca), dustRecipe);
            }
            FMLLog.info((String)"[AppEng] TE Integration Enabled.", (Object[])new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.info((String)"[AppEng] TE Integration Disabled.", (Object[])new Object[0]);
            this.LogIntegration(e);
        }
        for (AppEngMultiBlock mb : AppEngMultiBlock.multiBLocks) {
            int blacklisted = 0;
            for (int x = 0; x < 16; ++x) {
                AppEngSubBlock sb = mb.getSubBlock(x);
                if (sb == null || !sb.hasTileEntity()) continue;
                ++blacklisted;
            }
            int o = 0;
            int[] meta = new int[blacklisted];
            for (int x = 0; x < 16; ++x) {
                AppEngSubBlock sb = mb.getSubBlock(x);
                if (sb == null || !sb.hasTileEntity()) continue;
                meta[o++] = x;
            }
            try {
                Api.addBlockIDToGrabList((int)mb.field_71990_ca, (int[])meta);
            }
            catch (Throwable _) {
                // empty catch block
            }
            try {
                gravigun.api.Api.addBlockIDToGrabList((int)mb.field_71990_ca, (int[])meta);
            }
            catch (Throwable _) {}
        }
        if (AppEngConfiguration.enableMassCannon) {
            this.registration.itemMassCannon.initAmmo();
        }
        this.registration.initWorld(this.config, true);
        this.registration.initTiles();
        this.totalStartTime += System.currentTimeMillis() - StartTime;
        AppEng.log("Startup Time: " + this.totalStartTime + "ms");
    }

    @Mod.ServerStopping
    public void serverStopping(FMLServerStoppingEvent event) {
        AppEngWorldSettings.getInstance().shutdown();
    }

    @Mod.ServerStarting
    public void serverStarting(FMLServerStartingEvent event) {
        AppEngWorldSettings.getInstance().init();
    }

    public void LogIntegration(Throwable e) {
        if (AppEngConfiguration.logIntegration) {
            FMLLog.getLogger().logp(Level.INFO, "Appeng", "PostInit", "Integration Failure", e);
        }
    }

    public void generate(Random r, int var2, int var3, World w, IChunkProvider var5, IChunkProvider var6) {
        int sealevel = w.field_73011_w.func_76557_i() + 1;
        if (AppEngConfiguration.enableWorldGenQuartz && Blocks.blkQuartzOre != null) {
            double oreDepthMultiplier = 15 * sealevel / 64;
            int scale = (int)Math.round(r.nextGaussian() * Math.sqrt(oreDepthMultiplier) + oreDepthMultiplier);
            for (int x = 0; x < scale / 2; ++x) {
                int a = var2 * 16 + r.nextInt(22);
                int b = r.nextInt(40 * sealevel / 64) + r.nextInt(22 * sealevel / 64) + 12 * sealevel / 64;
                int c = var3 * 16 + r.nextInt(22);
                new WorldGenMinable(Blocks.blkQuartzOre.field_77993_c, Blocks.blkQuartzOre.func_77960_j(), 4 + AppEngConfiguration.additionalOresPerCluster, Block.field_71981_t.field_71990_ca).func_76484_a(w, r, a, b, c);
            }
        }
    }

    public synchronized String getCurrentVersion() {
        return this.currentVersion;
    }

    public synchronized void setCurrentVersion(String version) {
        this.currentVersion = version;
    }

    public static void craftingLog(String NetworkID, Object o, String string) {
        ItemStack req = null;
        req = o instanceof AEItemStack ? ((AEItemStack)o).getSharedItemStack() : (ItemStack)o;
        if (req != null && AppEngConfiguration.logCrafting) {
            AppEng.log(NetworkID + ": " + req.func_77977_a() + " - " + string);
        }
    }
}

