/*
 * Decompiled with CFR 0.152.
 */
package appeng.common.base;

import appeng.api.Materials;
import appeng.api.me.items.IStorageComponent;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngTextureRegistry;
import appeng.common.AutoID;
import appeng.common.AutoIcon;
import appeng.common.base.IAEItemOrBlock;
import appeng.entity.EntityQuantumItems;
import appeng.util.Platform;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class AppEngMaterials
extends Item
implements IAEItemOrBlock,
IStorageComponent {
    private List<Integer> orderList = new ArrayList<Integer>();
    private HashMap<Integer, MaterialDef> Defs = new HashMap();

    private ItemStack addMaterial(MaterialType mt) {
        if (this.Defs.containsKey(mt.meta)) {
            throw new RuntimeException("Invalid Material Configuration, two materials are shareing the same id.");
        }
        this.orderList.add(mt.meta);
        this.Defs.put(mt.meta, new MaterialDef(mt.uName, mt.meta, mt.ai));
        return new ItemStack((Item)this, 1, mt.meta);
    }

    public AppEngMaterials(AutoID id) {
        super(id.get());
        id.setItemID(this, this.field_77779_bT);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77637_a(AppEngConfiguration.creativeTab);
        GameRegistry.registerItem((Item)this, (String)"AppEngMaterials");
        Materials.matConversionMatrix = this.addMaterial(MaterialType.ConversionMatrix);
        Materials.matStorageCell = this.addMaterial(MaterialType.StorageCell);
        Materials.matStorageSegment = this.addMaterial(MaterialType.StorageSegment);
        Materials.matStorageBlock = this.addMaterial(MaterialType.StorageBlock);
        Materials.matStorageCluster = this.addMaterial(MaterialType.StorageCluster);
        Materials.matWireless = this.addMaterial(MaterialType.Wireless);
        Materials.matWirelessBooster = this.addMaterial(MaterialType.WirelessBooster);
        Materials.matQuartz = this.addMaterial(MaterialType.Quartz);
        Materials.matQuartzDustNether = this.addMaterial(MaterialType.QuartzDustNether);
        Materials.matQuartzDust = this.addMaterial(MaterialType.QuartzDust);
        Materials.matIronDust = this.addMaterial(MaterialType.IronDust);
        Materials.matGoldDust = this.addMaterial(MaterialType.GoldDust);
        Materials.matWoodenGear = this.addMaterial(MaterialType.WoodenGear);
        Materials.matCrank = this.addMaterial(MaterialType.Crank);
        Materials.matFlour = this.addMaterial(MaterialType.Flour);
        Materials.matSilicon = this.addMaterial(MaterialType.Silicon);
        Materials.matFluxDust = this.addMaterial(MaterialType.FluxDust);
        Materials.matFluxCrystal = this.addMaterial(MaterialType.FluxCrystal);
        Materials.matFluxPearl = this.addMaterial(MaterialType.FluxPearl);
        Materials.matBlankPattern = this.addMaterial(MaterialType.BlankPattern);
        Materials.matProcessorBasic = this.addMaterial(MaterialType.ProcessorBasic);
        Materials.matProcessorAdvanced = this.addMaterial(MaterialType.ProcessorAdvanced);
        Materials.matProcessorBasicUncooked = this.addMaterial(MaterialType.ProcessorBasicUncooked);
        Materials.matProcessorAdvancedUncooked = this.addMaterial(MaterialType.ProcessorAdvancedUncooked);
        Materials.matStorageCellHouseing = this.addMaterial(MaterialType.StorageCellHouseing);
        Materials.matIronNugget = this.addMaterial(MaterialType.IronNugget);
        Materials.matMatterBall = this.addMaterial(MaterialType.MatterBall);
        Materials.matSingularity = this.addMaterial(MaterialType.Singularity);
        Materials.matEnderPearlDust = this.addMaterial(MaterialType.EnderPearlDust);
        Materials.matQuantumEntangledSingularity = this.addMaterial(MaterialType.QuantumEntangledSingularity);
        Materials.matSpatialStorageCell = this.addMaterial(MaterialType.SpatialStorageCell);
        Materials.matSpatialStorageBlock = this.addMaterial(MaterialType.SpatialStorageBlock);
        Materials.matSpatialStorageCluster = this.addMaterial(MaterialType.SpatialStorageCluster);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        AppEngTextureRegistry.loadTextures(par1IconRegister, AppEngTextureRegistry.Materials);
    }

    public boolean shouldPassSneakingClickToBlock(World par2World, int par4, int par5, int par6) {
        return true;
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        if (this.Defs.containsKey(par1ItemStack.func_77960_j())) {
            return "AppEng.Materials." + this.Defs.get((Object)Integer.valueOf((int)par1ItemStack.func_77960_j())).unlocalizedName;
        }
        return "Materials.NULL";
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77617_a(int par1) {
        if (this.Defs.containsKey(par1)) {
            return this.Defs.get((Object)Integer.valueOf((int)par1)).icon.get();
        }
        return AppEngTextureRegistry.Blocks.NullIcon.get();
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem instanceof EntityQuantumItems) {
            return false;
        }
        if (entityItem.func_92059_d().func_77960_j() != MaterialType.Singularity.meta) {
            return false;
        }
        EntityQuantumItems is = new EntityQuantumItems(entityItem.field_70170_p, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, entityItem.func_92059_d());
        if (Platform.isServer()) {
            is.field_70159_w = entityItem.field_70159_w;
            is.field_70181_x = entityItem.field_70181_x;
            is.field_70179_y = entityItem.field_70179_y;
            is.field_70142_S = entityItem.field_70142_S;
            is.field_70137_T = entityItem.field_70137_T;
            is.field_70136_U = entityItem.field_70136_U;
            is.field_70293_c = entityItem.field_70293_c;
            is.field_70292_b = entityItem.field_70292_b;
            is.field_70160_al = entityItem.field_70160_al;
            entityItem.field_70170_p.func_72838_d((Entity)is);
            entityItem.func_70106_y();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int x : this.orderList) {
            if (Materials.matIronNugget.field_77993_c != this.field_77779_bT && x == MaterialType.IronNugget.meta || x == MaterialType.QuantumEntangledSingularity.meta || AppEng.getInstance().buildCraftMode && x == MaterialType.WoodenGear.meta) continue;
            par3List.add(new ItemStack((Item)this, 1, x));
        }
    }

    @Override
    public int getBytes(ItemStack is) {
        if (Materials.matStorageCell.func_77960_j() == is.func_77960_j()) {
            return 1024;
        }
        if (Materials.matStorageSegment.func_77960_j() == is.func_77960_j()) {
            return 4096;
        }
        if (Materials.matStorageBlock.func_77960_j() == is.func_77960_j()) {
            return 16384;
        }
        if (Materials.matStorageCluster.func_77960_j() == is.func_77960_j()) {
            return 65536;
        }
        return 0;
    }

    @Override
    public boolean isStorageComponent(ItemStack is) {
        return Materials.matStorageCell.func_77960_j() == is.func_77960_j() || Materials.matStorageSegment.func_77960_j() == is.func_77960_j() || Materials.matStorageBlock.func_77960_j() == is.func_77960_j() || Materials.matStorageCluster.func_77960_j() == is.func_77960_j();
    }

    static class MaterialDef {
        String unlocalizedName;
        int meta;
        AutoIcon icon;

        public MaterialDef(String a, int b, AutoIcon ai) {
            this.unlocalizedName = a;
            this.meta = b;
            this.icon = ai;
        }
    }

    public static enum MaterialType {
        ConversionMatrix("ConversionMatrix", 0, AppEngTextureRegistry.Materials.ConversionMatrix),
        StorageCell("StorageCell", 1, AppEngTextureRegistry.Materials.Cell),
        StorageSegment("StorageSegment", 17, AppEngTextureRegistry.Materials.Segment),
        StorageBlock("StorageBlock", 2, AppEngTextureRegistry.Materials.Block),
        StorageCluster("StorageCluster", 3, AppEngTextureRegistry.Materials.Cluster),
        Wireless("WirelessReceiver", 4, AppEngTextureRegistry.Materials.Wireless),
        WirelessBooster("WirelessBooster", 5, AppEngTextureRegistry.Materials.WirelessBooster),
        Quartz("QuartzCrystal", 6, AppEngTextureRegistry.Materials.Crystal),
        QuartzDustNether("QuartzDustNether", 22, AppEngTextureRegistry.Materials.QuartzDustNether),
        QuartzDust("QuartzDust", 7, AppEngTextureRegistry.Materials.QuartzDust),
        IronDust("IronDust", 8, AppEngTextureRegistry.Materials.IronDust),
        GoldDust("GoldDust", 9, AppEngTextureRegistry.Materials.GoldDust),
        WoodenGear("WoodenGear", 10, AppEngTextureRegistry.Materials.WoodenGear),
        Crank("WoodenCrank", 11, AppEngTextureRegistry.Materials.WoodenCrank),
        Flour("Flour", 12, AppEngTextureRegistry.Materials.Flour),
        Silicon("Silicon", 13, AppEngTextureRegistry.Materials.Silicon),
        FluxDust("FluxQuartzDust", 14, AppEngTextureRegistry.Materials.FluxDust),
        FluxCrystal("FluxQuartz", 23, AppEngTextureRegistry.Materials.FluxCrystal),
        FluxPearl("FluxPearl", 24, AppEngTextureRegistry.Materials.FluxPearl),
        BlankPattern("MEBlankPattern", 16, AppEngTextureRegistry.Materials.BlankPattern),
        ProcessorBasic("MEBasicProcessor", 18, AppEngTextureRegistry.Materials.BasicProcessor),
        ProcessorAdvanced("MEAdvancedProcessor", 19, AppEngTextureRegistry.Materials.AdvProcessor),
        ProcessorBasicUncooked("BasicProcessorAssembly", 20, AppEngTextureRegistry.Materials.BasicProcessAsm),
        ProcessorAdvancedUncooked("AdvancedProcessorAssembly", 21, AppEngTextureRegistry.Materials.AdvProcessAsm),
        StorageCellHouseing("StorageCellHousing", 15, AppEngTextureRegistry.Materials.CellHousing),
        IronNugget("IronNugget", 25, AppEngTextureRegistry.Materials.IronNugget),
        MatterBall("MatterBall", 26, AppEngTextureRegistry.Materials.MatterBall),
        Singularity("Singularity", 27, AppEngTextureRegistry.Materials.Singularity),
        EnderPearlDust("EnderPearlDust", 28, AppEngTextureRegistry.Materials.EnderPearlDust),
        QuantumEntangledSingularity("QuantumEntangledSingularity", 29, AppEngTextureRegistry.Materials.QuantumEntangledSingularity),
        SpatialStorageCell("SpatialStorageCell", 30, AppEngTextureRegistry.Materials.SpatialCell),
        SpatialStorageBlock("SpatialStorageBlock", 31, AppEngTextureRegistry.Materials.SpatialBlock),
        SpatialStorageCluster("SpatialStorageCluster", 32, AppEngTextureRegistry.Materials.SpatialCluster);

        public String uName;
        public int meta;
        public AutoIcon ai;

        private MaterialType(String s, int Meta, AutoIcon i) {
            this.uName = s;
            this.meta = Meta;
            this.ai = i;
        }
    }
}

