/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.config.FuzzyMode;
import appeng.api.config.ItemFlow;
import appeng.api.config.ListMode;
import appeng.api.exceptions.AppEngException;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventory;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.me.MEInventoryHandlerWrapper;
import appeng.util.ItemList;
import appeng.util.Platform;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class MEInventoryArray
implements IMEInventoryHandler {
    IMEInventoryHandler p;
    int priority = 1;
    List<IMEInventoryHandler> Cells;
    List<TileEntity> src;
    ItemFlow flow = ItemFlow.READ_WRITE;
    ListMode lmode = ListMode.WHITELIST;
    FuzzyMode fmode = FuzzyMode.Percent_99;
    protected static Comparator<IMEInventoryHandler> COMPARATOR = new Comparator<IMEInventoryHandler>(){

        @Override
        public int compare(IMEInventoryHandler o1, IMEInventoryHandler o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };
    List<IAEItemStack> filter;
    IGridInterface g;
    boolean fuzzyFilter;

    @Override
    public IMEInventoryHandler getParent() {
        return this.p;
    }

    @Override
    public void setParent(IMEInventoryHandler _p) {
        this.p = _p;
    }

    @Override
    public void setUpdateTarget(TileEntity e) {
        if (this.src == null) {
            this.src = new ArrayList<TileEntity>();
        }
        this.src.add(e);
    }

    protected MEInventoryArray(List<IMEInventoryHandler> List2) throws AppEngException {
        this.Cells = List2;
        for (IMEInventoryHandler c : this.Cells) {
            if (c != null && c instanceof IMEInventoryHandler) {
                c.setParent(this);
                continue;
            }
            throw new AppEngException("Tainted List, expected clean list of IMEInventories for CellArray, got something else.");
        }
        Collections.sort(this.Cells, COMPARATOR);
    }

    public static IMEInventoryHandler getMEInventoryArray(List<IMEInventoryHandler> o) {
        try {
            return new MEInventoryArray(o);
        }
        catch (AppEngException appEngException) {
            return null;
        }
    }

    @Override
    public long totalBytes() {
        int totalBytes = 0;
        for (IMEInventoryHandler c : this.Cells) {
            totalBytes = (int)((long)totalBytes + c.totalBytes());
        }
        return totalBytes;
    }

    @Override
    public long freeBytes() {
        int freeBytes = 0;
        for (IMEInventoryHandler c : this.Cells) {
            freeBytes = (int)((long)freeBytes + c.freeBytes());
        }
        return freeBytes;
    }

    @Override
    public long usedBytes() {
        int usedBytes = 0;
        for (IMEInventoryHandler c : this.Cells) {
            usedBytes = (int)((long)usedBytes + c.usedBytes());
        }
        return usedBytes;
    }

    @Override
    public long storedItemTypes() {
        int storedItemTypes = 0;
        for (IMEInventoryHandler c : this.Cells) {
            storedItemTypes = (int)((long)storedItemTypes + c.storedItemTypes());
        }
        return (short)storedItemTypes;
    }

    @Override
    public long storedItemCount() {
        int storedItemCount = 0;
        for (IMEInventoryHandler c : this.Cells) {
            storedItemCount = (int)((long)storedItemCount + c.storedItemCount());
        }
        return storedItemCount;
    }

    @Override
    public long remainingItemTypes() {
        int remainingItemTypes = 0;
        for (IMEInventoryHandler c : this.Cells) {
            remainingItemTypes = (int)((long)remainingItemTypes + c.remainingItemTypes());
        }
        return remainingItemTypes;
    }

    @Override
    public long remainingItemCount() {
        long remainingItemCount = 0L;
        for (IMEInventoryHandler c : this.Cells) {
            remainingItemCount += c.remainingItemCount();
        }
        return remainingItemCount;
    }

    @Override
    public long unusedItemCount() {
        long unusedItemCount = 0L;
        for (IMEInventoryHandler c : this.Cells) {
            unusedItemCount += c.unusedItemCount();
        }
        return unusedItemCount;
    }

    @Override
    public long getTotalItemTypes() {
        long getTotalItemTypes = 0L;
        for (IMEInventoryHandler c : this.Cells) {
            getTotalItemTypes += c.getTotalItemTypes();
        }
        return getTotalItemTypes;
    }

    @Override
    public boolean canHoldNewItem() {
        if (this.flow == ItemFlow.READ) {
            return false;
        }
        for (IMEInventoryHandler c : this.Cells) {
            if (!c.canHoldNewItem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsItemType(IAEItemStack i) {
        for (IMEInventoryHandler c : this.Cells) {
            if (!c.containsItemType(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public long countOfItemType(IAEItemStack i) {
        if (this.flow == ItemFlow.WRITE) {
            return 0L;
        }
        long total = 0L;
        for (IMEInventoryHandler c : this.Cells) {
            total += c.countOfItemType(i);
        }
        return total;
    }

    @Override
    public IItemList getAvailableItems(IItemList out) {
        if (this.flow == ItemFlow.WRITE) {
            return out;
        }
        for (IMEInventoryHandler c : this.Cells) {
            out.setCurrentPriority(c.getPriority());
            out = c.getAvailableItems(out);
        }
        return out;
    }

    @Override
    public IAEItemStack calculateItemAddition(IAEItemStack input) {
        if (this.flow == ItemFlow.WRITE) {
            return input;
        }
        if (!this.canAccept(input)) {
            return input;
        }
        for (IMEInventoryHandler inv : this.Cells) {
            input = inv.calculateItemAddition(input);
            if (input != null) continue;
            return input;
        }
        return input;
    }

    @Override
    public IAEItemStack addItems(IAEItemStack input) {
        if (input == null) {
            return null;
        }
        if (input.getStackSize() == 0L) {
            return null;
        }
        if (this.flow == ItemFlow.READ) {
            return input;
        }
        if (!this.canAccept(input)) {
            return input;
        }
        IAEItemStack begin = input.copy();
        for (IMEInventoryHandler inv : this.Cells) {
            if (!inv.containsItemType(input) || (input = inv.addItems(input)) != null) continue;
            this.updateSrc(begin.getStackSize(), begin);
            return input;
        }
        for (IMEInventoryHandler inv : this.Cells) {
            if (!inv.isPreformatted() || !inv.canAccept(input) || (input = inv.addItems(input)) != null) continue;
            this.updateSrc(begin.getStackSize(), begin);
            return input;
        }
        for (IMEInventoryHandler inv : this.Cells) {
            input = inv.addItems(input);
            if (input != null) continue;
            this.updateSrc(begin.getStackSize(), begin);
            return input;
        }
        this.updateSrc(begin.getStackSize() - input.getStackSize(), begin);
        return input;
    }

    private void updateSrc(long old, IAEItemStack input) {
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request) {
        if (this.flow == ItemFlow.WRITE) {
            return null;
        }
        IAEItemStack Gathered = request.copy();
        IAEItemStack Req = request.copy();
        int request_stackSize = (int)request.getStackSize();
        if (request_stackSize > request.getItem().func_77639_j()) {
            request_stackSize = request.getItem().func_77639_j();
        }
        Req.setStackSize(request_stackSize);
        Gathered.setStackSize(0L);
        for (IMEInventoryHandler inv : Lists.reverse(this.Cells)) {
            IAEItemStack retrieved = inv.extractItems(Req);
            if (retrieved != null) {
                Gathered.incStackSize(retrieved.getStackSize());
                Req.decStackSize(retrieved.getStackSize());
            }
            if ((long)request_stackSize != Gathered.getStackSize()) continue;
            this.updateSrc(-request_stackSize, Req);
            return Gathered;
        }
        if (Gathered.getStackSize() == 0L) {
            return null;
        }
        this.updateSrc(-Gathered.getStackSize(), Req);
        return Gathered;
    }

    @Override
    public long getAvailableSpaceByItem(IAEItemStack i, long maxNeeded) {
        if (this.flow == ItemFlow.READ) {
            return 0L;
        }
        long totalSpace = 0L;
        for (IMEInventory iMEInventory : this.Cells) {
            if (maxNeeded == -1L || (totalSpace += iMEInventory.getAvailableSpaceByItem(i, maxNeeded)) <= maxNeeded) continue;
            return maxNeeded;
        }
        return totalSpace;
    }

    @Override
    public List<ItemStack> getPreformattedItems() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean isPreformatted() {
        return this.filter != null;
    }

    @Override
    public void setPreformattedItems(IItemList in, FuzzyMode mode, ListMode m) {
        this.fmode = mode;
        this.lmode = m;
        if (in != null) {
            this.filter = new ArrayList<IAEItemStack>();
            for (IAEItemStack a : in) {
                this.filter.add(a);
            }
        } else {
            this.filter = null;
        }
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int p) {
        this.priority = p;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public void setGrid(IGridInterface grid) {
        this.g = grid;
    }

    @Override
    public IGridInterface getGrid() {
        return this.g;
    }

    @Override
    public void removeGrid(IGridInterface grid, IMEInventoryHandler ignore, List<IMEInventoryHandler> duplicates) {
        for (IMEInventoryHandler h : this.Cells) {
            if (h == ignore || h instanceof MEInventoryHandlerWrapper && ((MEInventoryHandlerWrapper)h).getTarget() == ignore) continue;
            if (h.getGrid() == grid) {
                duplicates.add(h);
                continue;
            }
            h.removeGrid(grid, ignore, duplicates);
        }
    }

    @Override
    public void validate(List<IMEInventoryHandler> duplicates) {
        if (duplicates.indexOf(this) != -1) {
            return;
        }
        if (this.getGrid() != null) {
            IMEInventoryHandler top = this;
            while (top.getParent() != null) {
                top = top.getParent();
            }
            top.removeGrid(this.getGrid(), this, duplicates);
        }
        for (IMEInventoryHandler c : this.Cells) {
            c.validate(duplicates);
        }
    }

    @Override
    public boolean isFuzzyPreformatted() {
        return this.fuzzyFilter;
    }

    @Override
    public void setFuzzyPreformatted(boolean nf) {
        this.fuzzyFilter = nf;
    }

    public boolean canFilterAccept(IAEItemStack s) {
        if (this.isPreformatted()) {
            boolean hasWhiteList = false;
            for (int x = 0; x < this.filter.size(); ++x) {
                IAEItemStack is = this.filter.get(x);
                if (is.getStackSize() > 0L) {
                    hasWhiteList = true;
                }
                if (this.isFuzzyPreformatted()) {
                    if (!Platform.isSameItemFuzzy(is, s, this.getFuzzyModePreformatted())) continue;
                    return is.getStackSize() > 0L;
                }
                if (!Platform.isSameItemPrecise(is, s)) continue;
                return is.getStackSize() > 0L;
            }
            return !hasWhiteList;
        }
        return true;
    }

    @Override
    public boolean canAccept(IAEItemStack input) {
        if (!this.canFilterAccept(input)) {
            return false;
        }
        for (IMEInventoryHandler h : this.Cells) {
            if (!h.canAccept(input)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IItemList getAvailableItems() {
        return this.getAvailableItems(new ItemList());
    }

    @Override
    public ItemFlow getFlow() {
        return this.flow;
    }

    @Override
    public void setFlow(ItemFlow p) {
        this.flow = p;
    }

    @Override
    public FuzzyMode getFuzzyModePreformatted() {
        return this.fmode;
    }

    @Override
    public ListMode getListMode() {
        return this.lmode;
    }
}

