/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.block;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.common.AppEng;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngSubBlock;
import appeng.interfaces.IDismantleable;
import appeng.me.tile.TileTransitionPlane;
import appeng.util.Platform;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BlockTransitionPlane
extends AppEngSubBlock
implements IDismantleable {
    public BlockTransitionPlane(AppEngMultiBlock mb, boolean en) {
        super(mb, en);
        this.unlocalizedName = "TransitionPlane";
    }

    @Override
    public boolean onBlockActivated(World w, int x, int y, int z, EntityPlayer p, int side) {
        TileEntity te;
        if (super.onBlockActivated(w, x, y, z, p, side)) {
            return true;
        }
        TileEntity tileEntity = w.func_72796_p(x, y, z);
        if (tileEntity == null || p.func_70093_af()) {
            return false;
        }
        ItemStack eq = p.func_71045_bC();
        if (Platform.isWrench(p, eq, x, y, z) && (te = w.func_72796_p(x, y, z)) instanceof TileTransitionPlane) {
            TileTransitionPlane ate = (TileTransitionPlane)te;
            ate.cycleOrientation();
            ate.markForUpdate();
            ate.notifyNeightbors();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(ate, w, new WorldCoord(x, y, z)));
            if (AppEng.getInstance().BCProxy != null) {
                AppEng.getInstance().BCProxy.wrenchUsed(eq.func_77973_b(), p, x, y, z);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isOpaqueCube() {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World w) {
        return new TileTransitionPlane();
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public void onEntityCollidedWithBlock(World w, int x, int y, int z, Entity entitiy) {
        TileEntity te;
        if (entitiy instanceof EntityItem && (te = w.func_72796_p(x, y, z)) instanceof TileTransitionPlane) {
            ((TileTransitionPlane)te).addItem((EntityItem)entitiy);
        }
    }

    @Override
    public Icon getBlockTextureFromSide(int side) {
        if (side == 0) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == 1) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        if (side == 2) {
            return AppEngTextureRegistry.Blocks.BlockTransPlane.get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }
}

