/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.api.me.tiles.IColoredMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IOrientableTile;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.network.IAppEngNetworkTile;
import appeng.me.basetiles.TileME;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class TileCraftingMonitor
extends TileME
implements IOrientableTile,
IAppEngNetworkTile,
IGridMachine,
IColoredMETile {
    protected ForgeDirection orientation;
    protected boolean hasPower = false;
    protected int color = Colors.length;

    @Override
    public boolean isColored(ForgeDirection d) {
        return this.color != Colors.length;
    }

    public TileCraftingMonitor() {
        this.orientation = ForgeDirection.NORTH;
    }

    @Override
    public int getLightValue() {
        return this.hasPower ? 7 : 0;
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return true;
    }

    @Override
    public void setOrientationBySide(EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        super.setOrientationBySide(player, side, hitX, hitY, hitZ);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)side);
        WorldCoord pos = new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        pos.add(orientation, -1);
        TileEntity te = this.field_70331_k.func_72796_p(pos.x, pos.y, pos.z);
        if (te instanceof IColoredMETile && ((IColoredMETile)te).isColored(ForgeDirection.UNKNOWN)) {
            this.color = ((IColoredMETile)te).getColor();
            MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(this, this.field_70331_k, this.getLocation()));
        }
    }

    @Override
    public void placedBy(EntityLivingBase entityliving) {
        this.orientation = this.getOrientationFromLivingEntity(entityliving, true);
    }

    private Icon defTextures(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        if (side == ForgeDirection.UP) {
            return AppEngTextureRegistry.Blocks.GenericTop.get();
        }
        return AppEngTextureRegistry.Blocks.GenericSide.get();
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (this.color < 0) {
            this.color = 0;
        }
        Icon frontFace = AppEngTextureRegistry.Blocks.MECraftingMonitors[this.color].get();
        if (this.orientation == side) {
            return frontFace;
        }
        return this.defTextures(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a("r", (int)this.getAERotationFromDirection(this.orientation));
        par1nbtTagCompound.func_74768_a("c", this.color);
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        this.orientation = this.getDirectionFromAERotation((byte)par1nbtTagCompound.func_74762_e("r"));
        this.color = par1nbtTagCompound.func_74762_e("c");
    }

    public boolean[] noScreen() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        return new boolean[]{rotation == 5, rotation == 4, rotation == 2, rotation == 0, rotation == 1, rotation == 3};
    }

    public boolean[] screenOnly() {
        byte rotation = this.getAERotationFromDirection(this.orientation);
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (this.hasPower) {
            AppEngMultiBlock b = (AppEngMultiBlock)block;
            b.dontrender = this.noScreen();
            renderer.func_78570_q(block, x, y, z);
            b.dontrender = this.screenOnly();
            if (!this.networkReady) {
                this.renderBusyScreen(block, renderer, this.getBlockTextureFromSide(this.orientation), this.orientation);
            } else {
                int bn = 15;
                Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                Tessellator.field_78398_a.func_78380_c(bn << 20 | bn << 4);
                this.renderFace(block, renderer, this.orientation);
            }
            b.dontrender = null;
        } else {
            renderer.func_78570_q(block, x, y, z);
        }
        return true;
    }

    @Override
    public boolean isBlockNormalCube() {
        return true;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        ForgeDirection oldOrientation = this.orientation;
        int oldColor = this.color;
        boolean oldHasPower = this.hasPower;
        boolean oldnetworkReady = this.networkReady;
        this.orientation = this.getDirectionFromAERotation(stream.readByte());
        this.color = stream.readByte();
        byte flags = stream.readByte();
        this.hasPower = (flags & 1) == 1;
        this.networkReady = (flags & 2) == 2;
        return oldColor != this.color || oldHasPower != this.hasPower || oldOrientation != this.orientation || oldnetworkReady != this.networkReady;
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeByte(this.getAERotationFromDirection(this.orientation));
        data.writeByte(this.color);
        data.writeByte((this.hasPower ? 1 : 0) | (this.networkReady ? 2 : 0));
    }

    @Override
    public void setPowerStatus(boolean _hasPower) {
        super.setPowerStatus(_hasPower);
        this.hasPower = _hasPower;
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.markForUpdate();
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    @Override
    public void setColor(int offset) {
        this.color = offset;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public ForgeDirection getPrimaryOrientation() {
        return this.orientation;
    }

    @Override
    public int getSpin() {
        return 0;
    }

    @Override
    public void setPrimaryOrientation(ForgeDirection s) {
        this.orientation = s;
    }

    @Override
    public void setSpin(int spin) {
    }
}

