/*
 * Decompiled with CFR 0.152.
 */
package appeng.proxy;

import appeng.api.exceptions.AppEngException;
import appeng.common.AppEng;
import appeng.me.tile.TileStorageBus;
import appeng.proxy.IProxyIC2;
import appeng.util.Platform;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.event.PaintEvent;
import ic2.api.item.ElectricItem;
import ic2.api.item.Items;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.Recipes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;

public class ProxyIC2
implements IProxyIC2 {
    @ForgeSubscribe
    public void onPaint(PaintEvent pe) {
        try {
            if (AppEng.getApiInstance().paintBlock(pe.world, pe.x, pe.y, pe.z, pe.color)) {
                pe.painted = true;
            }
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
    }

    public ProxyIC2() throws AppEngException {
        if (!Platform.isModLoaded("IC2")) {
            throw new AppEngException("IC2 is not available.");
        }
        TileStorageBus.blackListed.put(IEnergySource.class, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void addToEnergyNet(TileEntity t) {
        if (t instanceof IEnergyTile && Platform.isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)t));
        }
    }

    @Override
    public void removeFromEnergyNet(TileEntity t) {
        if (t instanceof IEnergyTile && Platform.isServer()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)t));
        }
    }

    @Override
    public boolean canUse(ItemStack i, int powerusage) {
        return ElectricItem.canUse((ItemStack)i, (int)powerusage);
    }

    @Override
    public boolean use(ItemStack i, int powerusage, EntityPlayer p) {
        return ElectricItem.use((ItemStack)i, (int)powerusage, (EntityPlayer)p);
    }

    @Override
    public int discharge(ItemStack i, int powerusage, int tier, boolean ignoreTransferLimit, boolean simulate) {
        return ElectricItem.discharge((ItemStack)i, (int)powerusage, (int)tier, (boolean)ignoreTransferLimit, (boolean)simulate);
    }

    @Override
    public void addCompressorRecipe(ItemStack in, ItemStack out) {
        try {
            Recipes.compressor.addRecipe((IRecipeInput)new RecipeInputItemStack(in, in.field_77994_a), null, new ItemStack[]{out});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public ItemStack getItem(String string) {
        return Items.getItem((String)string);
    }

    @Override
    public void addMaceratorRecipe(ItemStack in, ItemStack out) {
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputItemStack(in, in.field_77994_a), null, new ItemStack[]{out});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

