/*
 * Decompiled with CFR 0.152.
 */
package appeng.render;

import appeng.api.Blocks;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngMultiBlock;
import appeng.common.base.AppEngTile;
import appeng.me.block.BlockCable;
import appeng.me.block.BlockColorlessCable;
import appeng.me.block.BlockColorlessCableCovered;
import appeng.me.block.BlockController;
import appeng.me.block.BlockDarkCable;
import appeng.me.block.BlockInputCableBasic;
import appeng.me.block.BlockInputCableFuzzy;
import appeng.me.block.BlockInputCablePrecision;
import appeng.me.block.BlockLevelEmitter;
import appeng.me.block.BlockOutputCableBasic;
import appeng.me.block.BlockOutputCableFuzzy;
import appeng.me.block.BlockOutputCablePrecision;
import appeng.me.block.BlockP2PTunnel;
import appeng.me.block.BlockQuantumLinkChamber;
import appeng.me.block.BlockQuantumRing;
import appeng.me.block.BlockSpatialPylon;
import appeng.me.block.BlockStorageBus;
import appeng.me.block.BlockStorageBusFuzzy;
import appeng.tech1.block.BlockQuartzGlass;
import appeng.tech1.block.BlockQuartzPillar;
import appeng.util.Platform;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class AppEngBlockRenderer
implements ISimpleBlockRenderingHandler {
    int myRenderID = -1;
    public static AppEngBlockRenderer instance;
    public static Icon overrideTexture;
    public static int overrideRenderColor;
    public static int overrideBrightness;

    public AppEngBlockRenderer() {
        instance = this;
    }

    public Icon GetTexture(RenderBlocks renderer, Block block) {
        if (renderer.field_78664_d != null) {
            return renderer.field_78664_d;
        }
        return overrideTexture;
    }

    public void renderBox(Block block, RenderBlocks renderer, int metadata, float offset, float Thickness) {
        float offX = 0.0f;
        float offY = 0.0f;
        float offZ = 0.0f;
        float centerX = 0.5f;
        float centerY = 0.5f;
        float centerZ = 0.5f;
        float thickX = (double)Math.abs(0.0f) > 0.1 ? 0.076f : Thickness;
        float thickY = (double)Math.abs(0.0f) > 0.1 ? 0.076f : Thickness;
        float thickZ = (double)Math.abs(0.0f) > 0.1 ? 0.076f : Thickness;
        renderer.func_83020_a((double)(centerX + offX - thickX), (double)((centerY += 0.0f) + offY - thickY), (double)((centerZ += 0.0f) + offZ - thickZ), (double)((centerX += 0.0f) + offX + thickX), (double)(centerY + offY + thickY), (double)(centerZ + offZ + thickZ));
        Icon tex = this.GetTexture(renderer, block);
        GL11.glPushMatrix();
        Tessellator var5 = Tessellator.field_78398_a;
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        var5.func_78382_b();
        var5.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, tex);
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, tex);
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, tex);
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, tex);
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, tex);
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, tex);
        var5.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public void setOverrideBrightness(int i) {
        overrideBrightness = i;
    }

    public void setOverrideBlockTexture(Block b, Icon t) {
        overrideTexture = t;
    }

    public void renderTipPart(Block block, RenderBlocks renderer, int metadata, float offset, float Thickness, Icon texture) {
        this.setOverrideBlockTexture(block, texture);
        AppEngMultiBlock b = (AppEngMultiBlock)block;
        ForgeDirection orientation = ForgeDirection.WEST;
        float offX = (float)orientation.offsetX / 2.0f;
        float offY = (float)orientation.offsetY / 2.0f;
        float offZ = (float)orientation.offsetZ / 2.0f;
        float centerX = 0.5f;
        float centerY = 0.5f;
        float centerZ = 0.5f;
        float thickX = (double)Math.abs(orientation.offsetX) > 0.1 ? 0.076f : Thickness;
        float thickY = (double)Math.abs(orientation.offsetY) > 0.1 ? 0.076f : Thickness;
        float thickZ = (double)Math.abs(orientation.offsetZ) > 0.1 ? 0.076f : Thickness;
        renderer.func_83020_a((double)(centerX + offX - thickX), (double)((centerY += (float)orientation.offsetY * -offset) + offY - thickY), (double)((centerZ += (float)orientation.offsetZ * -offset) + offZ - thickZ), (double)((centerX += (float)orientation.offsetX * -offset) + offX + thickX), (double)(centerY + offY + thickY), (double)(centerZ + offZ + thickZ));
        Icon tex = this.GetTexture(renderer, block);
        GL11.glPushMatrix();
        Tessellator var5 = Tessellator.field_78398_a;
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (b.dontrender == null || !b.dontrender[5]) {
            var5.func_78382_b();
            var5.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_78613_a(block, 0.0, 0.0, 0.0, tex);
            var5.func_78381_a();
        }
        if (b.dontrender == null || !b.dontrender[4]) {
            var5.func_78382_b();
            var5.func_78375_b(0.0f, 1.0f, 0.0f);
            renderer.func_78617_b(block, 0.0, 0.0, 0.0, tex);
            var5.func_78381_a();
        }
        if (b.dontrender == null || !b.dontrender[2]) {
            var5.func_78382_b();
            var5.func_78375_b(0.0f, 0.0f, -1.0f);
            renderer.func_78611_c(block, 0.0, 0.0, 0.0, tex);
            var5.func_78381_a();
        }
        if (b.dontrender == null || !b.dontrender[0]) {
            var5.func_78382_b();
            var5.func_78375_b(0.0f, 0.0f, 1.0f);
            renderer.func_78622_d(block, 0.0, 0.0, 0.0, tex);
            var5.func_78381_a();
        }
        if (b.dontrender == null || !b.dontrender[1]) {
            var5.func_78382_b();
            var5.func_78375_b(-1.0f, 0.0f, 0.0f);
            renderer.func_78573_e(block, 0.0, 0.0, 0.0, tex);
            var5.func_78381_a();
        }
        if (b.dontrender == null || !b.dontrender[3]) {
            var5.func_78382_b();
            var5.func_78375_b(1.0f, 0.0f, 0.0f);
            renderer.func_78605_f(block, 0.0, 0.0, 0.0, tex);
            var5.func_78381_a();
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
        this.setOverrideBlockTexture(block, null);
    }

    public void addVertexWithUV(double x, double y, double z, double u, double v) {
        Tessellator var12 = Tessellator.field_78398_a;
        z -= 0.5;
        double m = x -= 0.5;
        x = -(y -= 0.5);
        y = m;
        var12.func_78374_a(x += 0.5, y += 0.5, z += 0.5, u, v);
    }

    public void renderTorchAtAngle() {
        int var13 = 34;
        double par2 = 0.0;
        double par4 = 0.0;
        double par6 = 0.0;
        par4 += 0.4;
        double par10 = 0.0;
        double par11 = 0.0;
        double par8 = 0.0;
        boolean isOn = true;
        Icon icon = isOn ? AppEngTextureRegistry.Blocks.LevelEmitterTorchOn.get() : AppEngTextureRegistry.Blocks.LevelEmitterTorchOff.get();
        float var16 = icon.func_94209_e();
        float var18 = icon.func_94206_g();
        float var17 = icon.func_94212_f();
        float var19 = icon.func_94210_h();
        double var20 = icon.func_94214_a(7.0);
        double var22 = icon.func_94207_b(6.0 + (isOn ? 0.0 : 1.0));
        double var24 = icon.func_94214_a(9.0);
        double var26 = icon.func_94207_b(8.0 + (isOn ? 0.0 : 1.0));
        double var28 = icon.func_94214_a(7.0);
        double var30 = icon.func_94207_b(13.0);
        double var32 = icon.func_94214_a(9.0);
        double var34 = icon.func_94207_b(15.0);
        double var36 = (par2 += 0.5) - 0.5;
        double var38 = par2 + 0.5;
        double var40 = (par6 += 0.5) - 0.5;
        double var42 = par6 + 0.5;
        double var44 = 0.0625;
        double var46 = 0.625;
        double toff = 0.0;
        if (!isOn) {
            toff = 0.0625;
        }
        GL11.glPushMatrix();
        Tessellator var5 = Tessellator.field_78398_a;
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        var5.func_78382_b();
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) - var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) - var44, var20, var22);
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) - var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) + var44, var20, var26);
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) + var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) + var44, var24, var26);
        this.addVertexWithUV(par2 + par8 * (1.0 - var46) + var44, par4 + var46 - toff, par6 + par10 * (1.0 - var46) - var44, var24, var22);
        this.addVertexWithUV(par2 + var44 + par8, par4, par6 - var44 + par10, var32, var30);
        this.addVertexWithUV(par2 + var44 + par8, par4, par6 + var44 + par10, var32, var34);
        this.addVertexWithUV(par2 - var44 + par8, par4, par6 + var44 + par10, var28, var34);
        this.addVertexWithUV(par2 - var44 + par8, par4, par6 - var44 + par10, var28, var30);
        this.addVertexWithUV(par2 - var44, par4 + 1.0, var40, var16, var18);
        this.addVertexWithUV(par2 - var44 + par8, par4 + 0.0, var40 + par10, var16, var19);
        this.addVertexWithUV(par2 - var44 + par8, par4 + 0.0, var42 + par10, var17, var19);
        this.addVertexWithUV(par2 - var44, par4 + 1.0, var42, var17, var18);
        this.addVertexWithUV(par2 + var44, par4 + 1.0, var42, var16, var18);
        this.addVertexWithUV(par2 + par8 + var44, par4 + 0.0, var42 + par10, var16, var19);
        this.addVertexWithUV(par2 + par8 + var44, par4 + 0.0, var40 + par10, var17, var19);
        this.addVertexWithUV(par2 + var44, par4 + 1.0, var40, var17, var18);
        this.addVertexWithUV(var36, par4 + 1.0, par6 + var44, var16, var18);
        this.addVertexWithUV(var36 + par8, par4 + 0.0, par6 + var44 + par10, var16, var19);
        this.addVertexWithUV(var38 + par8, par4 + 0.0, par6 + var44 + par10, var17, var19);
        this.addVertexWithUV(var38, par4 + 1.0, par6 + var44, var17, var18);
        this.addVertexWithUV(var38, par4 + 1.0, par6 - var44, var16, var18);
        this.addVertexWithUV(var38 + par8, par4 + 0.0, par6 - var44 + par10, var16, var19);
        this.addVertexWithUV(var36 + par8, par4 + 0.0, par6 - var44 + par10, var17, var19);
        this.addVertexWithUV(var36, par4 + 1.0, par6 - var44, var17, var18);
        var5.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
    }

    public boolean[] BackSide() {
        int rotation = 5;
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    public boolean[] FrontSide() {
        int rotation = 4;
        return new boolean[]{rotation != 5, rotation != 4, rotation != 2, rotation != 0, rotation != 1, rotation != 3};
    }

    public boolean[] NotFrontSide() {
        int rotation = 4;
        return new boolean[]{rotation == 5, rotation == 4, rotation == 2, rotation == 0, rotation == 1, rotation == 3};
    }

    public boolean[] SidesOnly() {
        int rotation = 4;
        int orotation = 5;
        return new boolean[]{rotation == 5 || orotation == 5, rotation == 4 || orotation == 4, rotation == 2 || orotation == 2, rotation == 0 || orotation == 0, rotation == 1 || orotation == 1, rotation == 3 || orotation == 3};
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (((AppEngMultiBlock)block).notValidBlock(metadata)) {
            return;
        }
        if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockController) {
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            GL11.glPushMatrix();
            Tessellator var5 = Tessellator.field_78398_a;
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            var5.func_78382_b();
            var5.func_78375_b(0.0f, -1.0f, 0.0f);
            renderer.func_78611_c(block, 0.0, 0.0, 0.0, AppEngTextureRegistry.Blocks.ControllerPanel.get());
            var5.func_78381_a();
            GL11.glPopMatrix();
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockLevelEmitter) {
            Tessellator tess = Tessellator.field_78398_a;
            this.renderTorchAtAngle();
            this.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.MECable.get());
            this.renderBox(block, renderer, metadata, 0.0f, 0.2f);
            this.setOverrideBlockTexture(block, null);
            double Thickness = 0.18;
            renderer.func_83020_a(0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockP2PTunnel) {
            AppEngMultiBlock b = (AppEngMultiBlock)block;
            renderer.field_78661_f = false;
            b.nonOpaqueMode = true;
            b.dontrender = this.FrontSide();
            this.renderTipPart(block, renderer, metadata, 0.071f, 0.251f, AppEngTextureRegistry.Blocks.BlockQuartz.get());
            this.renderTipPart(block, renderer, metadata, 0.071f, 0.375f, AppEngTextureRegistry.Blocks.BlockP2PTunnel1.get());
            b.dontrender = this.SidesOnly();
            this.renderTipPart(block, renderer, metadata, 0.031f, 0.375f, AppEngTextureRegistry.Blocks.BlockP2PTunnel2.get());
            b.dontrender = this.BackSide();
            this.renderTipPart(block, renderer, metadata, 0.031f, 0.375f, AppEngTextureRegistry.Blocks.BlockP2PTunnel2.get());
            b.dontrender = this.NotFrontSide();
            this.renderTipPart(block, renderer, metadata, 0.142f, 0.3125f, AppEngTextureRegistry.Blocks.BlockP2PTunnel2.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.15625f, AppEngTextureRegistry.Blocks.MECableCorner.get());
            b.nonOpaqueMode = false;
            b.dontrender = null;
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockSpatialPylon) {
            Tessellator tess = Tessellator.field_78398_a;
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockSpatialPylon[0].get());
            this.renderBox(block, renderer, metadata, 0.0f, 0.5f);
            this.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockSpatialPylon[1].get());
            this.renderBox(block, renderer, metadata, 0.0f, 0.5f);
            this.setOverrideBlockTexture(block, null);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockQuartzGlass) {
            Tessellator tess = Tessellator.field_78398_a;
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockQuartzGlassFrame.get());
            this.renderBox(block, renderer, metadata, 0.0f, 0.5f);
            this.setOverrideBlockTexture(block, AppEngTextureRegistry.Blocks.BlockQuartzGlass.get());
            this.renderBox(block, renderer, metadata, 0.0f, 0.5f);
            this.setOverrideBlockTexture(block, null);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockInputCablePrecision) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.3f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.152f, 0.25f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.2f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.15f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockStorageBusFuzzy) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.5f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.152f, 0.45f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.3f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.15f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockStorageBus) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.5f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.152f, 0.45f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.3f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.15f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockOutputCablePrecision) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.1f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.152f, 0.15f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.2f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.25f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockInputCableFuzzy) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.3f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.152f, 0.25f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.2f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.15f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockOutputCableFuzzy) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.1f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.152f, 0.15f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.2f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.25f, AppEngTextureRegistry.Blocks.BlockFuzzyInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockInputCableBasic) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.2f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.1f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.1f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockOutputCableBasic) {
            this.renderTipPart(block, renderer, metadata, 0.076f, 0.1f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.22799999f, 0.2f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            this.renderTipPart(block, renderer, metadata, 0.304f, 0.1f, AppEngTextureRegistry.Blocks.BlockInterface.get());
            double Thickness = 0.18;
            renderer.func_83020_a(0.38 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockDarkCable) {
            double Thickness = 0.18;
            renderer.func_83020_a(0.18 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockCable) {
            double Thickness = 0.18;
            renderer.func_83020_a(0.18 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockColorlessCable) {
            double Thickness = 0.18;
            renderer.func_83020_a(0.18 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockColorlessCableCovered) {
            double Thickness = 0.18;
            renderer.func_83020_a(0.18 - Thickness, 0.5 - Thickness, 0.5 - Thickness, 0.82 + Thickness, 0.5 + Thickness, 0.5 + Thickness);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockQuartzPillar) {
            renderer.field_78679_j = 2;
            renderer.field_78685_i = 2;
            renderer.field_78662_g = 2;
            renderer.field_78683_h = 2;
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockQuantumRing) {
            renderer.func_83020_a(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
        } else if (((AppEngMultiBlock)block).getSubBlock(metadata) instanceof BlockQuantumLinkChamber) {
            renderer.func_83020_a(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
        } else {
            renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        GL11.glPushMatrix();
        Tessellator var5 = Tessellator.field_78398_a;
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        var5.func_78382_b();
        var5.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(0, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(1, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(2, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(3, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(4, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(5, metadata));
        var5.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glPopMatrix();
        renderer.field_78675_l = 0;
        renderer.field_78681_k = 0;
        renderer.field_78685_i = 0;
        renderer.field_78679_j = 0;
        renderer.field_78683_h = 0;
        renderer.field_78662_g = 0;
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (block instanceof AppEngMultiBlock && ((AppEngMultiBlock)block).hasSpecialRenderer(world, x, y, z)) {
            return ((AppEngMultiBlock)block).specialRenderer(world, x, y, z, renderer);
        }
        if (te instanceof AppEngTile) {
            AppEngTile ate = (AppEngTile)te;
            return ate.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        }
        return AppEngTile.defaultRenderWorldBlock(world, x, y, z, block, modelId, renderer);
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        if (this.myRenderID == -1) {
            this.myRenderID = RenderingRegistry.getNextAvailableRenderId();
        }
        return this.myRenderID;
    }

    public void renderBlock(IItemRenderer.ItemRenderType type, ItemStack item, RenderBlocks renderer) {
        Block block = Block.field_71973_m[item.field_77993_c];
        int metadata = item.func_77960_j();
        if (Platform.isSameItemType(Blocks.blkEnergyCell, item)) {
            int max = AppEngTextureRegistry.Blocks.MEEnergyCell.length;
            int cur = 0;
            if (item.func_77942_o()) {
                NBTTagCompound c = item.func_77978_p();
                int storedEnergy = c.func_74762_e("storedEnergy");
                cur = storedEnergy * max / 200000;
            }
            if (cur >= max) {
                cur = max - 1;
            }
            overrideTexture = AppEngTextureRegistry.Blocks.MEEnergyCell[cur].get();
        }
        renderer.func_83020_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        Tessellator var5 = Tessellator.field_78398_a;
        var5.func_78382_b();
        var5.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_78613_a(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(0, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_78617_b(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(1, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_78611_c(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(2, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_78622_d(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(3, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_78573_e(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(4, metadata));
        var5.func_78381_a();
        var5.func_78382_b();
        var5.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_78605_f(block, 0.0, 0.0, 0.0, renderer.field_78664_d != null ? renderer.field_78664_d : block.func_71858_a(5, metadata));
        var5.func_78381_a();
        overrideTexture = null;
    }

    static {
        overrideTexture = null;
        overrideRenderColor = -1;
        overrideBrightness = -1;
    }
}

