/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import openblocks.common.HeightMapData;
import openmods.renderer.DynamicTextureAtlas;
import org.lwjgl.opengl.GL11;

public class HeightMapRenderer {
    public static final HeightMapRenderer instance = new HeightMapRenderer();
    public static final double PLANE_HEIGHT = 0.015625;
    private final Map<Integer, MapRenderData> cache = Maps.newHashMap();

    private HeightMapRenderer() {
    }

    protected void finalize() throws Throwable {
        for (MapRenderData data : this.cache.values()) {
            data.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int mapId, HeightMapData data) {
        MapRenderData renderData;
        Map<Integer, MapRenderData> map = this.cache;
        synchronized (map) {
            renderData = this.cache.get(mapId);
            if (renderData == null) {
                renderData = new MapRenderData();
                this.cache.put(mapId, renderData);
            }
        }
        if (renderData.needsUpdate(data)) {
            renderData.update(data);
        }
        renderData.render();
    }

    private static class MapRenderData {
        public int renderedDataHash;
        public DynamicTextureAtlas atlas;
        public Integer displayList;

        private MapRenderData() {
        }

        public void free() {
            if (this.displayList != null) {
                GL11.glDeleteLists((int)this.displayList, (int)1);
                this.displayList = null;
            }
        }

        private List<PlaneData> updateMapTexture(HeightMapData map) {
            TextureManager manager = Minecraft.func_71410_x().field_71446_o;
            if (this.atlas == null) {
                this.atlas = new DynamicTextureAtlas(manager, 64);
            }
            this.atlas.clearCells();
            ArrayList planes = Lists.newArrayList();
            this.createXZPlanes(map, planes);
            if (!planes.isEmpty()) {
                this.atlas.compile();
            }
            return planes;
        }

        private void createXZPlanes(HeightMapData map, List<PlaneData> planes) {
            int[][] levels = new int[256][];
            for (HeightMapData.LayerData layer : map.layers) {
                for (int x = 0; x < 64; ++x) {
                    for (int y = 0; y < 64; ++y) {
                        int index = 64 * y + x;
                        byte color = layer.colorMap[index];
                        if (color == 0) continue;
                        int height = layer.heightMap[index] & 0xFF;
                        int fullColor = MapColor.field_76281_a[color].field_76291_p;
                        int[] plane = MapRenderData.getPlane(levels, height);
                        plane[index] = fullColor | layer.alpha << 24;
                    }
                }
            }
            this.createPlanes(planes, levels, PlaneOrientation.XZ);
        }

        public static int[] getPlane(int[][] levels, int height) {
            int[] level = levels[height];
            if (level == null) {
                level = new int[4096];
                levels[height] = level;
            }
            return level;
        }

        private void createPlanes(List<PlaneData> planes, int[][] levels, PlaneOrientation orientation) {
            for (int z = 0; z < levels.length; ++z) {
                int[] level = levels[z];
                if (level == null) continue;
                PlaneData plane = new PlaneData();
                plane.orientation = orientation;
                plane.param = z;
                plane.texture = this.atlas.allocateCell();
                plane.texture.setPixels(level);
                planes.add(plane);
            }
        }

        private void compileDisplayList(List<PlaneData> planes) {
            if (this.displayList == null) {
                this.displayList = GL11.glGenLists((int)1);
            }
            GL11.glNewList((int)this.displayList, (int)4864);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            Tessellator tes = new Tessellator();
            tes.func_78382_b();
            tes.func_78376_a(255, 255, 255);
            for (PlaneData plane : planes) {
                DynamicTextureAtlas.AtlasCell tex = plane.texture;
                double param = 0.015625 * (double)plane.param;
                switch (plane.orientation) {
                    case XZ: {
                        tes.func_78374_a(0.0, param, 0.0, (double)tex.minU, (double)tex.minV);
                        tes.func_78374_a(0.0, param, 1.0, (double)tex.minU, (double)tex.maxV);
                        tes.func_78374_a(1.0, param, 1.0, (double)tex.maxU, (double)tex.maxV);
                        tes.func_78374_a(1.0, param, 0.0, (double)tex.maxU, (double)tex.minV);
                        break;
                    }
                    case XY: {
                        tes.func_78374_a(0.0, 0.0, param, (double)tex.minU, (double)tex.minV);
                        tes.func_78374_a(0.0, 1.0, param, (double)tex.minU, (double)tex.maxV);
                        tes.func_78374_a(1.0, 1.0, param, (double)tex.maxU, (double)tex.maxV);
                        tes.func_78374_a(1.0, 0.0, param, (double)tex.maxU, (double)tex.minV);
                        break;
                    }
                    case YZ: {
                        tes.func_78374_a(param, 0.0, 0.0, (double)tex.minU, (double)tex.minV);
                        tes.func_78374_a(param, 1.0, 0.0, (double)tex.minU, (double)tex.maxV);
                        tes.func_78374_a(param, 1.0, 1.0, (double)tex.maxU, (double)tex.maxV);
                        tes.func_78374_a(param, 0.0, 1.0, (double)tex.maxU, (double)tex.minV);
                        break;
                    }
                }
            }
            tes.func_78381_a();
            GL11.glEnable((int)2884);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
            GL11.glEndList();
        }

        public boolean needsUpdate(HeightMapData map) {
            return System.identityHashCode((Object)map) != this.renderedDataHash;
        }

        public void update(HeightMapData map) {
            List<PlaneData> planes = this.updateMapTexture(map);
            this.compileDisplayList(planes);
            this.renderedDataHash = System.identityHashCode((Object)map);
        }

        public void render() {
            Preconditions.checkNotNull((Object)this.displayList, (Object)"Display list not compiled");
            this.atlas.bind();
            GL11.glCallList((int)this.displayList);
        }
    }

    private static class PlaneData {
        public PlaneOrientation orientation;
        public int param;
        public DynamicTextureAtlas.AtlasCell texture;

        private PlaneData() {
        }
    }

    private static enum PlaneOrientation {
        XY,
        XZ,
        YZ;

    }
}

