/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.mutant;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import openblocks.api.IMutant;
import openblocks.api.IMutantRenderer;
import openblocks.utils.MutantUtils;

public class MutantRendererEnderman
implements IMutantRenderer {
    private static final ResourceLocation endermanEyesTexture = new ResourceLocation("textures/entity/enderman/enderman_eyes.png");
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/enderman/enderman.png");
    private ModelRenderer head;
    private ModelRenderer headwear;
    private ModelRenderer body;
    private ModelRenderer leftLeg;
    private ModelRenderer rightLeg;
    private ModelRenderer leftArm;
    private ModelRenderer rightArm;

    @Override
    public void initialize(ModelBase base) {
        this.head = new ModelRenderer(base, 0, 0);
        this.head.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.headwear = new ModelRenderer(base, 0, 16);
        this.headwear.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, -0.5f);
        this.rightLeg = new ModelRenderer(base, 56, 0);
        this.rightLeg.func_78789_a(-1.0f, 0.0f, -1.0f, 2, 30, 2);
        this.leftLeg = new ModelRenderer(base, 56, 0);
        this.leftLeg.field_78809_i = true;
        this.leftLeg.func_78789_a(-1.0f, 0.0f, -1.0f, 2, 30, 2);
        this.rightArm = new ModelRenderer(base, 56, 0);
        this.rightArm.func_78789_a(-1.0f, -2.0f, -1.0f, 2, 30, 2);
        this.leftArm = new ModelRenderer(base, 56, 0);
        this.leftArm.field_78809_i = true;
        this.leftArm.func_78789_a(-1.0f, -2.0f, -1.0f, 2, 30, 2);
        this.body = new ModelRenderer(base, 32, 16);
        this.body.func_78789_a(-4.0f, -0.0f, -2.0f, 8, 12, 4);
    }

    @Override
    public void renderHead(IMutant mutant, float scale, float yaw, float pitch) {
        this.head.field_78806_j = true;
        Vec3 headPoint = mutant.getBody().getHeadAttachmentPoint();
        MutantUtils.bindToAttachmentPoint(mutant, this.head, headPoint);
        MutantUtils.bindToAttachmentPoint(mutant, this.headwear, headPoint);
        MutantRendererEnderman.bindTexture();
        this.head.field_78795_f = pitch / 57.295776f;
        this.headwear.field_78796_g = this.head.field_78796_g = yaw / 57.295776f;
        this.headwear.field_78795_f = this.head.field_78795_f;
        this.head.func_78785_a(scale);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(endermanEyesTexture);
        this.headwear.func_78785_a(scale);
    }

    @Override
    public void renderLegs(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererEnderman.bindTexture();
        Vec3[] legAttachmentPoints = mutant.getBody().getLegAttachmentPoints(mutant.getLegs().getNumberOfLegs());
        MutantUtils.bindToAttachmentPoint(mutant, this.leftLeg, legAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.rightLeg, legAttachmentPoints[1]);
        this.rightLeg.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 1.4f * prevLegSwing;
        this.leftLeg.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 1.4f * prevLegSwing;
        this.rightLeg.field_78796_g = 0.0f;
        this.leftLeg.field_78796_g = 0.0f;
        this.rightLeg.field_78795_f *= 0.5f;
        this.leftLeg.field_78795_f *= 0.5f;
        float var9 = 0.4f;
        if (this.rightLeg.field_78795_f > var9) {
            this.rightLeg.field_78795_f = var9;
        }
        if (this.leftLeg.field_78795_f > var9) {
            this.leftLeg.field_78795_f = var9;
        }
        if (this.rightLeg.field_78795_f < -var9) {
            this.rightLeg.field_78795_f = -var9;
        }
        if (this.leftLeg.field_78795_f < -var9) {
            this.leftLeg.field_78795_f = -var9;
        }
        this.leftLeg.func_78785_a(scale);
        this.rightLeg.func_78785_a(scale);
    }

    @Override
    public void renderBody(IMutant mutant, float scale) {
        this.body.func_78793_a(0.0f, 24.0f - (float)mutant.getLegHeight() - (float)mutant.getBodyHeight(), 0.0f);
        MutantRendererEnderman.bindTexture();
        this.body.func_78785_a(scale);
    }

    @Override
    public void renderWings(IMutant mutant, float scale, float wingSwing) {
    }

    @Override
    public void renderArms(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
        MutantRendererEnderman.bindTexture();
        Vec3[] armAttachmentPoints = mutant.getBody().getArmAttachmentPoints();
        MutantUtils.bindToAttachmentPoint(mutant, this.leftArm, armAttachmentPoints[0]);
        MutantUtils.bindToAttachmentPoint(mutant, this.rightArm, armAttachmentPoints[1]);
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f + (float)Math.PI)) * 2.0f * prevLegSwing * 0.5f;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(legSwing * 0.6662f)) * 2.0f * prevLegSwing * 0.5f;
        this.rightArm.field_78795_f *= 0.5f;
        this.leftArm.field_78795_f *= 0.5f;
        float var9 = 0.4f;
        if (this.rightArm.field_78795_f > var9) {
            this.rightArm.field_78795_f = var9;
        }
        if (this.leftArm.field_78795_f > var9) {
            this.leftArm.field_78795_f = var9;
        }
        if (this.rightArm.field_78795_f < -var9) {
            this.rightArm.field_78795_f = -var9;
        }
        if (this.leftArm.field_78795_f < -var9) {
            this.leftArm.field_78795_f = -var9;
        }
        this.leftArm.func_78785_a(scale);
        this.rightArm.func_78785_a(scale);
    }

    @Override
    public void renderTail(IMutant mutant, float scale, float legSwing, float prevLegSwing) {
    }

    private static void bindTexture() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }
}

