/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.Config;
import openblocks.OpenBlocks;
import openmods.api.INeighbourAwareTile;
import openmods.api.ISurfaceAttachment;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncableBoolean;
import openmods.tileentity.SyncedTileEntity;
import openmods.utils.BlockUtils;
import openmods.utils.EntityUtils;

public class TileEntityTarget
extends SyncedTileEntity
implements ISurfaceAttachment,
INeighbourAwareTile {
    private int strength = 0;
    private int tickCounter = -1;
    private SyncableBoolean active;
    private static final List<Class<?>> predictedProjectileClasses = Lists.newArrayList();

    protected void createSyncedFields() {
        this.active = new SyncableBoolean();
    }

    public void func_70316_g() {
        super.func_70316_g();
        --this.tickCounter;
        this.predictOtherProjectiles();
        if (this.tickCounter == 0) {
            this.tickCounter = -1;
            this.strength = 0;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, Config.blockTargetId);
        }
    }

    private void predictOtherProjectiles() {
        if (!this.field_70331_k.field_72995_K) {
            for (Class<?> klazz : predictedProjectileClasses) {
                if (klazz == null) continue;
                List projectiles = this.field_70331_k.func_72872_a(klazz, this.getBB().func_72314_b(20.0, 20.0, 20.0));
                for (Entity projectile : projectiles) {
                    MovingObjectPosition hit = EntityUtils.raytraceEntity((Entity)projectile);
                    if (!BlockUtils.isBlockHit((MovingObjectPosition)hit, (TileEntity)this)) continue;
                    OpenBlocks.Blocks.target.onTargetHit(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, hit.field_72307_f);
                }
            }
        }
    }

    public void setEnabled(boolean en) {
        this.active.setValue(en);
    }

    public boolean isEnabled() {
        return this.active.getValue();
    }

    public float getTargetRotation() {
        return this.isEnabled() ? 0.0f : -1.5707964f;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
        this.tickCounter = 10;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, Config.blockTargetId);
    }

    private void onRedstoneChanged() {
        boolean isPowered = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (isPowered == this.isEnabled()) {
            return;
        }
        if (!isPowered) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l - 0.1, (double)this.field_70330_m - 0.1, (double)this.field_70327_n - 0.1, (double)this.field_70329_l + 1.1, (double)this.field_70330_m + 1.1, (double)this.field_70327_n + 1.1);
            List arrows = this.field_70331_k.func_72872_a(EntityArrow.class, aabb);
            int pickableCount = 0;
            for (EntityArrow arrow : arrows) {
                if (arrow.field_70251_a == 1) {
                    ++pickableCount;
                }
                arrow.func_70106_y();
            }
            if (pickableCount > 0) {
                ItemStack newStack = new ItemStack(Item.field_77704_l, pickableCount, 0);
                BlockUtils.dropItemStackInWorld((World)this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (ItemStack)newStack);
            }
        }
        this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, isPowered ? "openblocks:open" : "openblocks:close", 0.5f, 1.0f);
        this.setEnabled(isPowered);
        this.sync();
    }

    public ForgeDirection getSurfaceDirection() {
        return ForgeDirection.DOWN;
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        super.prepareForInventoryRender(block, metadata);
        this.setEnabled(true);
    }

    public void onSynced(Set<ISyncableObject> changes) {
    }

    public void onNeighbourChanged(int blockId) {
        this.onRedstoneChanged();
    }

    static {
        predictedProjectileClasses.add(OpenBlocks.ClassReferences.flansmodsEntityBullet);
    }
}

