/*
 * Decompiled with CFR 0.152.
 */
package openblocks.integration.cc15;

import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.TurtleSide;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openblocks.common.entity.EntityMagnet;
import openblocks.integration.MagnetControlAdapterBase;

public class MagnetControlAdapter
extends MagnetControlAdapterBase {
    private final TurtleSide side;
    private final ITurtleAccess turtle;

    public MagnetControlAdapter(ITurtleAccess turtle, TurtleSide side) {
        this.turtle = turtle;
        this.side = side;
    }

    public World getWorld() {
        return this.turtle.getWorld();
    }

    @Override
    protected MagnetControlAdapterBase.OwnerBase createOwner() {
        return new Owner();
    }

    @Override
    protected boolean consumeFuel(int amount) {
        return this.turtle.consumeFuel(amount);
    }

    @Override
    protected MagnetControlAdapterBase.SpawnSide getSpawnSide() {
        switch (this.side) {
            case Left: {
                return MagnetControlAdapterBase.SpawnSide.Left;
            }
        }
        return MagnetControlAdapterBase.SpawnSide.Right;
    }

    @Override
    protected ForgeDirection getTurtleFacing() {
        return ForgeDirection.getOrientation((int)this.turtle.getFacingDir());
    }

    @Override
    protected Vec3 getTurtlePosition() {
        return this.turtle.getPosition();
    }

    public class Owner
    extends MagnetControlAdapterBase.OwnerBase {
        @Override
        public boolean isValid(EntityMagnet magnet) {
            return MagnetControlAdapter.this.turtle != null && MagnetControlAdapter.this.turtle.getWorld() != null;
        }

        @Override
        public Vec3 getTarget() {
            return this.getTarget(MagnetControlAdapter.this.getTurtlePosition(), MagnetControlAdapter.this.getTurtleFacing());
        }
    }
}

