/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.IAEItemStack;
import appeng.api.Util;
import appeng.api.WorldCoord;
import appeng.api.config.RedstoneModeInput;
import appeng.api.events.GridTileLoadEvent;
import appeng.api.events.GridTileUnloadEvent;
import appeng.api.me.tiles.IDirectionalMETile;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.tiles.IGridTileEntity;
import appeng.api.me.tiles.ITileCable;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.IMEInventoryHandler;
import extracells.BlockEnum;
import extracells.Extracells;
import extracells.ItemEnum;
import extracells.gui.widget.WidgetFluidModes;
import extracells.tileentity.ColorableECTile;
import extracells.util.ECPrivateInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBusFluidExport
extends ColorableECTile
implements IGridMachine,
IDirectionalMETile,
ITileCable {
    private boolean powerStatus = true;
    private boolean redstoneFlag = false;
    private boolean networkReady = true;
    private boolean redstoneStatus = false;
    private boolean fluidHandlerCached = false;
    private boolean redStoneCached = false;
    private IGridInterface grid;
    private String customName = StatCollector.func_74838_a((String)"tile.block.fluid.bus.export");
    private ECPrivateInventory inventory = new ECPrivateInventory(this.customName, 8, 1);
    private RedstoneModeInput redstoneMode = RedstoneModeInput.Ignore;
    private WidgetFluidModes.FluidMode fluidMode = WidgetFluidModes.FluidMode.DROPS;
    private IFluidHandler fluidHandler = null;
    private int currentTick = 0;
    private final int tickRate = Extracells.tickRateExport;

    public void func_70316_g() {
        if (!this.field_70331_k.field_72995_K) {
            ++this.currentTick;
            if (this.currentTick == this.tickRate) {
                this.currentTick = 0;
                this.doUpdateEntity();
            }
        }
    }

    public void doUpdateEntity() {
        if (!this.redStoneCached || !this.fluidHandlerCached) {
            BlockEnum.FLUIDEXPORT.getBlockInstance().func_71863_a(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 1);
            this.redStoneCached = true;
            this.fluidHandlerCached = true;
        }
        if (!this.field_70331_k.field_72995_K && this.isPowered() && this.grid != null && this.fluidHandler != null) {
            switch (this.getRedstoneMode()) {
                case WhenOn: {
                    if (!this.redstoneStatus) break;
                    this.doWork(this.fluidMode);
                    break;
                }
                case WhenOff: {
                    if (this.redstoneStatus) break;
                    this.doWork(this.fluidMode);
                    break;
                }
                case OnPulse: {
                    if (!this.redstoneStatus) {
                        this.redstoneFlag = false;
                        break;
                    }
                    if (!this.redstoneFlag) {
                        this.doWork(this.fluidMode);
                        break;
                    }
                    this.redstoneFlag = true;
                    this.doWork(this.fluidMode);
                    break;
                }
                case Ignore: {
                    this.doWork(this.fluidMode);
                    break;
                }
            }
        }
    }

    public void setFluidHandler(IFluidHandler handler) {
        this.fluidHandler = handler;
    }

    public void setRedstoneStatus(boolean redstone) {
        this.redstoneStatus = redstone;
    }

    public void func_70312_q() {
        super.func_70312_q();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileLoadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    public void func_70313_j() {
        super.func_70313_j();
        MinecraftForge.EVENT_BUS.post((Event)new GridTileUnloadEvent((IGridTileEntity)this, this.field_70331_k, this.getLocation()));
    }

    private void doWork(WidgetFluidModes.FluidMode mode) {
        List<Fluid> fluidFilter = this.getFilterFluids(this.inventory.slots);
        if (fluidFilter != null && fluidFilter.size() > 0) {
            IMEInventoryHandler cellArray = this.getGrid().getCellArray();
            for (Fluid entry : fluidFilter) {
                IAEItemStack entryToAEIS;
                long contained;
                if (entry == null || cellArray == null || (contained = cellArray.countOfItemType(entryToAEIS = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), 1, entry.getID())))) <= 0L) continue;
                int modeAmount = mode.getAmount() * this.tickRate;
                this.exportFluid(new FluidStack(entry, contained < (long)modeAmount ? (int)contained : modeAmount), this.fluidHandler, ForgeDirection.getOrientation((int)this.func_70322_n()).getOpposite(), mode);
            }
        }
    }

    public void exportFluid(FluidStack toExport, IFluidHandler tankToFill, ForgeDirection from, WidgetFluidModes.FluidMode mode) {
        IMEInventoryHandler cellArray = this.grid.getCellArray();
        if (cellArray != null) {
            if (toExport == null) {
                return;
            }
            int fillable = tankToFill.fill(from, toExport, false);
            if (fillable > 0) {
                IAEItemStack toExtract = Util.createItemStack((ItemStack)new ItemStack(ItemEnum.FLUIDDISPLAY.getItemInstance(), fillable, toExport.fluidID));
                IAEItemStack extracted = cellArray.extractItems(toExtract);
                this.grid.useMEEnergy(mode.getCost() * (float)this.tickRate, "Export Fluid");
                if (extracted != null) {
                    toExport.amount = (int)extracted.getStackSize();
                    tankToFill.fill(from, new FluidStack(toExport.fluidID, (int)extracted.getStackSize()), true);
                }
            }
        }
    }

    public List<Fluid> getFilterFluids(List<ItemStack> filterItemStacks) {
        ArrayList<Fluid> filterFluids = new ArrayList<Fluid>();
        if (filterItemStacks != null) {
            for (ItemStack entry : filterItemStacks) {
                FluidStack contained;
                if (entry == null) continue;
                if (entry.func_77973_b() instanceof IFluidContainerItem && (contained = ((IFluidContainerItem)entry.func_77973_b()).getFluid(entry)) != null) {
                    filterFluids.add(contained.getFluid());
                }
                if (!FluidContainerRegistry.isFilledContainer((ItemStack)entry)) continue;
                filterFluids.add(FluidContainerRegistry.getFluidForFilledItem((ItemStack)entry).getFluid());
            }
        }
        return filterFluids;
    }

    public RedstoneModeInput getRedstoneMode() {
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneModeInput mode) {
        this.redstoneMode = mode;
    }

    public WidgetFluidModes.FluidMode getFluidMode() {
        return this.fluidMode;
    }

    public void setFluidMode(WidgetFluidModes.FluidMode mode) {
        this.fluidMode = mode;
    }

    public Packet func_70319_e() {
        NBTTagCompound nbtTag = this.getColorDataForPacket();
        this.func_70310_b(nbtTag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, nbtTag);
    }

    @Override
    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        super.onDataPacket(net, packet);
        this.func_70307_a(packet.field_73331_e);
    }

    public WorldCoord getLocation() {
        return new WorldCoord(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return true;
    }

    public void setPowerStatus(boolean hasPower) {
        this.powerStatus = hasPower;
    }

    public boolean isPowered() {
        return this.powerStatus;
    }

    public IGridInterface getGrid() {
        return this.grid;
    }

    public void setGrid(IGridInterface gi) {
        this.grid = gi;
    }

    public World getWorld() {
        return this.field_70331_k;
    }

    public boolean canConnect(ForgeDirection dir) {
        return dir.ordinal() != this.field_70325_p;
    }

    public float getPowerDrainPerTick() {
        return 0.0f;
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74782_a("Items", (NBTBase)this.inventory.writeToNBT());
        if (this.getInventory().func_94042_c()) {
            nbt.func_74778_a("CustomName", this.customName);
        }
        nbt.func_74768_a("RedstoneMode", this.getRedstoneMode().ordinal());
        nbt.func_74768_a("FluidMode", this.getFluidMode().ordinal());
        nbt.func_74757_a("RedstoneState", this.redstoneStatus);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        NBTTagList nbttaglist = nbt.func_74761_m("Items");
        this.inventory.readFromNBT(nbttaglist);
        if (nbt.func_74764_b("CustomName")) {
            this.customName = nbt.func_74779_i("CustomName");
        }
        this.setRedstoneMode(RedstoneModeInput.values()[nbt.func_74762_e("RedstoneMode")]);
        this.setFluidMode(WidgetFluidModes.FluidMode.values()[nbt.func_74762_e("FluidMode")]);
        this.redstoneStatus = nbt.func_74767_n("RedstoneState");
    }

    public ECPrivateInventory getInventory() {
        return this.inventory;
    }

    public boolean coveredConnections() {
        return false;
    }

    public void setNetworkReady(boolean isReady) {
        this.networkReady = isReady;
    }

    public boolean isMachineActive() {
        return this.powerStatus && this.networkReady;
    }
}

