/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.render.IconRegistry;
import cofh.render.RenderHelper;
import cofh.util.FluidHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileReconfigurableInventory;
import thermalexpansion.block.device.BlockDevice;
import thermalexpansion.core.TEProps;

public class TileNullifier
extends TileReconfigurableInventory
implements IFluidHandler,
ISidedInventory {
    protected static int guiId;
    protected static final int[] SIDE_TEX;
    protected static final int[] SLOTS;
    protected static final Fluid renderFluid;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileNullifier.class, (String)"cofh.thermalexpansion.Nullifier");
        guiId = ThermalExpansion.proxy.registerGui("Nullifier", "device", true);
    }

    public TileNullifier() {
        this.inventory = new ItemStack[1];
    }

    public boolean canUpdate() {
        return false;
    }

    public int getBlockID() {
        return TEBlocks.blockDevice.field_71990_ca;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return BlockDevice.Types.NULLIFIER.ordinal();
    }

    public int getLightValue() {
        return FluidHelper.getFluidLuminosity((Fluid)renderFluid);
    }

    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    public boolean isSideAccessible(int side) {
        return this.sideCache[side] == 1 && this.redstoneControlOrDisable();
    }

    @Override
    public void readInventoryFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void writeInventoryToNBT(NBTTagCompound nbt) {
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int side) {
        if (side < 0 || side > 5) {
            return false;
        }
        this.facing = (byte)side;
        this.sideCache[this.facing] = 1;
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getBlockID());
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public int getNumConfig(int side) {
        return 2;
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            return side != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.redstoneControlOrDisable() ? RenderHelper.getFluidTexture((Fluid)renderFluid) : IconRegistry.getIcon((String)"DeviceFace_", (int)this.getType()));
        }
        if (side < 6) {
            return side != this.facing ? IconRegistry.getIcon((String)TEProps.textureSelection, (int)SIDE_TEX[this.sideCache[side]]) : (this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive_", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace_", (int)this.getType()));
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.isSideAccessible(from.ordinal()) ? resource.amount : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return null;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= amount) {
            amount = this.inventory[slot].field_77994_a;
        }
        ItemStack stack = this.inventory[slot].func_77979_a(amount);
        if (this.inventory[slot].field_77994_a <= 0) {
            this.inventory[slot] = null;
        }
        return stack;
    }

    @Override
    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] == null) {
            return null;
        }
        ItemStack stack = this.inventory[slot];
        this.inventory[slot] = null;
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            return;
        }
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int[] func_94128_d(int side) {
        return this.isSideAccessible(side) ? SLOTS : TEProps.EMPTY_INVENTORY;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.isSideAccessible(side);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    static {
        SIDE_TEX = new int[]{0, 1, 4};
        SLOTS = new int[]{0};
        renderFluid = FluidRegistry.LAVA;
    }
}

