/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.ender;

import cofh.api.energy.IEnergyHandler;
import cofh.api.tileentity.ISecureTile;
import cofh.api.transport.IEnderAttuned;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.EnergyHelper;
import cofh.util.FluidHelper;
import cofh.util.RegistryEnderAttuned;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileRSInventory;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.Utils;

public class TileTesseract
extends TileRSInventory
implements ISecureTile,
ISidedInventory,
IFluidHandler,
IEnergyHandler,
ITileInfoPacketHandler,
IEnderAttuned {
    protected static int guiId;
    protected static final int[] SLOTS;
    String owner = "[None]";
    public int frequency = -1;
    public byte modeItem = (byte)TransferMode.RECV.ordinal();
    public byte modeFluid = (byte)TransferMode.RECV.ordinal();
    public byte modeEnergy = (byte)TransferMode.RECV.ordinal();
    public ISecureTile.AccessMode access = ISecureTile.AccessMode.PUBLIC;
    public boolean isActive = false;
    int itemTrackerAdjacent;
    int itemTrackerRemote;
    int fluidTrackerAdjacent;
    int fluidTrackerRemote;
    int energyTrackerAdjacent;
    int energyTrackerRemote;
    boolean cached = false;
    IEnergyHandler[] adjacentEnergyHandlers = new IEnergyHandler[6];
    IFluidHandler[] adjacentFluidHandlers = new IFluidHandler[6];
    public boolean canAccess = true;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileTesseract.class, (String)"cofh.thermalexpansion.Tesseract");
        guiId = ThermalExpansion.proxy.registerGui("Tesseract", "ender", true);
    }

    public TileTesseract() {
        this.inventory = new ItemStack[1];
    }

    public void blockBroken() {
        this.removeFromRegistry();
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.blockBroken();
    }

    public void func_70312_q() {
        super.func_70312_q();
        if (this.frequency != -1) {
            this.addToRegistry();
        }
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    public String getName() {
        return "tile.thermalexpansion.tesseract.name";
    }

    public int getType() {
        return 0;
    }

    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (!this.cached) {
            this.updateAdjacentHandlers();
        }
        if (this.timeCheck() && this.inventory[0] != null) {
            this.sendItem(this.inventory[0]);
            if (this.inventory[0].field_77994_a <= 0) {
                this.inventory[0] = null;
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockTesseract.field_71990_ca);
            }
        }
    }

    public void setTileInfo(int theFreq) {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.frequency = theFreq;
            PacketUtils.sendToServer((Packet)Payload.getInfoPayload((TileEntity)this).addByte(PacketInfoID.TILE_INFO.ordinal()).addByte(this.modeItem).addByte(this.modeFluid).addByte(this.modeEnergy).addByte(this.access.ordinal()).addInt(theFreq).getPacket());
        }
    }

    public void addEntry(int theFreq, String freqName) {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)Payload.getInfoPayload((TileEntity)this).addByte(PacketInfoID.ALTER_NAME_LIST.ordinal()).addBool(false).addString(this.access.isPublic() ? "_public_" : this.owner.toLowerCase()).addString(String.valueOf(theFreq)).addString(freqName).getPacket());
        }
    }

    public void removeEntry(int theFreq, String freqName) {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)Payload.getInfoPayload((TileEntity)this).addByte(PacketInfoID.ALTER_NAME_LIST.ordinal()).addBool(true).addString(this.access.isPublic() ? "_public_" : this.owner.toLowerCase()).addString(String.valueOf(theFreq)).addString(freqName).getPacket());
        }
    }

    public List<IEnderAttuned> getValidItemOutputs() {
        List theTeleports = RegistryEnderAttuned.getLinkedItemOutputs((IEnderAttuned)this);
        LinkedList<IEnderAttuned> validOutputs = new LinkedList<IEnderAttuned>();
        if (theTeleports == null) {
            return validOutputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            IEnderAttuned curThing = (IEnderAttuned)theTeleports.get(i);
            if (!curThing.currentlyValidToReceiveItems((IEnderAttuned)this)) continue;
            validOutputs.add(curThing);
        }
        return validOutputs;
    }

    public List<IEnderAttuned> getValidFluidOutputs() {
        List theTeleports = RegistryEnderAttuned.getLinkedFluidOutputs((IEnderAttuned)this);
        LinkedList<IEnderAttuned> validOutputs = new LinkedList<IEnderAttuned>();
        if (theTeleports == null) {
            return validOutputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            IEnderAttuned curThing = (IEnderAttuned)theTeleports.get(i);
            if (!curThing.currentlyValidToReceiveFluid((IEnderAttuned)this)) continue;
            validOutputs.add(curThing);
        }
        return validOutputs;
    }

    public List<IEnderAttuned> getValidEnergyOutputs() {
        List theTeleports = RegistryEnderAttuned.getLinkedEnergyOutputs((IEnderAttuned)this);
        LinkedList<IEnderAttuned> validOutputs = new LinkedList<IEnderAttuned>();
        if (theTeleports == null) {
            return validOutputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            IEnderAttuned curThing = (IEnderAttuned)theTeleports.get(i);
            if (!curThing.currentlyValidToReceiveEnergy((IEnderAttuned)this)) continue;
            validOutputs.add(curThing);
        }
        return validOutputs;
    }

    public void addToRegistry() {
        RegistryEnderAttuned.add((IEnderAttuned)this);
    }

    public void removeFromRegistry() {
        RegistryEnderAttuned.remove((IEnderAttuned)this);
    }

    public void onChunkUnload() {
        this.removeFromRegistry();
    }

    public boolean openGui(EntityPlayer player) {
        if (CoreUtils.isFakePlayer((EntityPlayer)player)) {
            return true;
        }
        if (this.canPlayerAccess(player.field_71092_bJ)) {
            this.sendNamesList((EntityPlayerMP)player);
            player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        if (ServerHelper.isServerWorld((World)this.field_70331_k)) {
            player.func_71035_c(StringHelper.localize((String)"message.cofh.secure1") + " " + this.owner + "! " + StringHelper.localize((String)"message.cofh.secure2"));
        }
        return true;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int tileX, int tileY, int tileZ) {
        super.onNeighborTileChange(tileX, tileY, tileZ);
        this.updateAdjacentHandler(tileX, tileY, tileZ);
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            if (tile instanceof TileTesseract) continue;
            this.adjacentFluidHandlers[i] = FluidHelper.isFluidHandler((TileEntity)tile) ? (IFluidHandler)tile : null;
            this.adjacentEnergyHandlers[i] = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tile, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i ^ 1]) ? (IEnergyHandler)tile : null;
        }
        this.cached = true;
    }

    protected void updateAdjacentHandler(int x, int y, int z) {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        int side = BlockHelper.determineAdjacentSide((TileEntity)this, (int)x, (int)y, (int)z);
        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
        if (tile instanceof TileTesseract) {
            return;
        }
        this.adjacentFluidHandlers[side] = FluidHelper.isFluidHandler((TileEntity)tile) ? (IFluidHandler)tile : null;
        this.adjacentEnergyHandlers[side] = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tile, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[side ^ 1]) ? (IEnergyHandler)tile : null;
    }

    public boolean isOwner(String username) {
        return username == null ? false : username.equals(this.owner);
    }

    public String getOwnerString() {
        return this.access.isPublic() ? "_public_" : this.owner;
    }

    void sendItem(ItemStack item) {
        int i;
        List<IEnderAttuned> validOutputs = this.getValidItemOutputs();
        for (i = this.itemTrackerRemote; i < validOutputs.size() && item != null && item.field_77994_a > 0; ++i) {
            item = validOutputs.get(i).receiveItem(item);
        }
        for (i = 0; i < validOutputs.size() && i < this.itemTrackerRemote && item != null && item.field_77994_a > 0; ++i) {
            item = validOutputs.get(i).receiveItem(item);
        }
        this.itemTrackerRemote = this.incrRemoteTracker(this.itemTrackerRemote, validOutputs.size());
        if (item != null && item.field_77994_a > 0) {
            this.inventory[0] = item;
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockTesseract.field_71990_ca);
        }
    }

    int sendFluid(FluidStack fluid, boolean doFill) {
        int i;
        List<IEnderAttuned> validOutputs = this.getValidFluidOutputs();
        int startAmount = fluid.amount;
        if (validOutputs.size() <= 0 || startAmount <= 0) {
            return 0;
        }
        for (i = this.fluidTrackerRemote; i < validOutputs.size() && fluid != null && fluid.amount > 0; ++i) {
            fluid = validOutputs.get(i).receiveFluid(fluid, doFill);
        }
        for (i = 0; i < validOutputs.size() && i < this.fluidTrackerRemote && fluid != null && fluid.amount > 0; ++i) {
            fluid = validOutputs.get(i).receiveFluid(fluid, doFill);
        }
        this.fluidTrackerRemote = this.incrRemoteTracker(this.fluidTrackerRemote, validOutputs.size());
        return startAmount - fluid.amount;
    }

    int sendEnergy(int energy, boolean simulate) {
        int i;
        List<IEnderAttuned> validOutputs = this.getValidEnergyOutputs();
        int startAmount = energy;
        if (validOutputs.size() <= 0 || startAmount <= 0) {
            return 0;
        }
        for (i = this.energyTrackerRemote; i < validOutputs.size() && energy > 0; ++i) {
            energy = validOutputs.get(i).receiveEnergy(energy, simulate);
        }
        for (i = 0; i < validOutputs.size() && i < this.energyTrackerRemote && energy > 0; ++i) {
            energy = validOutputs.get(i).receiveEnergy(energy, simulate);
        }
        this.energyTrackerRemote = this.incrRemoteTracker(this.energyTrackerRemote, validOutputs.size());
        return startAmount - energy;
    }

    public ItemStack receiveItem(ItemStack stack) {
        int side;
        for (side = this.itemTrackerAdjacent; side < 6 && stack != null && stack.field_77994_a > 0; ++side) {
            if (!Utils.isAdjacentInventory((TileEntity)this, side)) continue;
            stack.field_77994_a = this.addToAdjInventory((TileEntity)this, side, stack.func_77946_l());
        }
        for (side = 0; side < this.itemTrackerAdjacent && stack != null && stack.field_77994_a > 0; ++side) {
            if (!Utils.isAdjacentInventory((TileEntity)this, side)) continue;
            stack.field_77994_a = this.addToAdjInventory((TileEntity)this, side, stack.func_77946_l());
        }
        this.incrItemTrackerAdjacent();
        return stack;
    }

    public FluidStack receiveFluid(FluidStack fluid, boolean doFill) {
        int side;
        for (side = this.fluidTrackerAdjacent; side < 6 && fluid.amount > 0; ++side) {
            if (this.adjacentFluidHandlers[side] == null) continue;
            fluid.amount -= this.adjacentFluidHandlers[side].fill(ForgeDirection.VALID_DIRECTIONS[side ^ 1], fluid, doFill);
        }
        for (side = 0; side < this.fluidTrackerAdjacent && side < 6 && fluid.amount > 0; ++side) {
            if (this.adjacentFluidHandlers[side] == null) continue;
            fluid.amount -= this.adjacentFluidHandlers[side].fill(ForgeDirection.VALID_DIRECTIONS[side ^ 1], fluid, doFill);
        }
        this.incrFluidTrackerAdjacent();
        return fluid;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        int side;
        for (side = this.energyTrackerAdjacent; side < 6 && energy > 0; ++side) {
            if (this.adjacentEnergyHandlers[side] == null) continue;
            energy -= this.adjacentEnergyHandlers[side].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[side ^ 1], energy, simulate);
        }
        for (side = 0; side < this.energyTrackerAdjacent && side < 6 && energy > 0; ++side) {
            if (this.adjacentEnergyHandlers[side] == null) continue;
            energy -= this.adjacentEnergyHandlers[side].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[side ^ 1], energy, simulate);
        }
        this.incrEnergyTrackerAdjacent();
        return energy;
    }

    public void incrItemTrackerAdjacent() {
        int side;
        ++this.itemTrackerAdjacent;
        for (side = this.itemTrackerAdjacent; side < 6; ++side) {
            if (!Utils.isAdjacentInventory((TileEntity)this, side)) continue;
            this.itemTrackerAdjacent = side;
            return;
        }
        this.itemTrackerAdjacent %= 6;
        for (side = 0; side < this.itemTrackerAdjacent; ++side) {
            if (!Utils.isAdjacentInventory((TileEntity)this, side)) continue;
            this.itemTrackerAdjacent = side;
            return;
        }
        this.itemTrackerAdjacent = 0;
    }

    public void incrFluidTrackerAdjacent() {
        int side;
        ++this.fluidTrackerAdjacent;
        for (side = this.fluidTrackerAdjacent; side < 6; ++side) {
            if (this.adjacentFluidHandlers[side] == null) continue;
            this.fluidTrackerAdjacent = side;
            return;
        }
        this.fluidTrackerAdjacent %= 6;
        for (side = 0; side < this.fluidTrackerAdjacent; ++side) {
            if (this.adjacentFluidHandlers[side] == null) continue;
            this.fluidTrackerAdjacent = side;
            return;
        }
        this.fluidTrackerAdjacent = 0;
    }

    public void incrEnergyTrackerAdjacent() {
        int side;
        ++this.energyTrackerAdjacent;
        for (side = this.energyTrackerAdjacent; side < 6; ++side) {
            if (this.adjacentEnergyHandlers[side] == null) continue;
            this.energyTrackerAdjacent = side;
            return;
        }
        this.energyTrackerAdjacent %= 6;
        for (side = 0; side < this.energyTrackerAdjacent; ++side) {
            if (this.adjacentEnergyHandlers[side] == null) continue;
            this.energyTrackerAdjacent = side;
            return;
        }
        this.energyTrackerAdjacent = 0;
    }

    public int incrRemoteTracker(int tracker, int max) {
        if (++tracker >= max) {
            tracker = 0;
        }
        return tracker;
    }

    public int addToAdjInventory(TileEntity tile, int from, ItemStack stack) {
        TileEntity tileInventory = BlockHelper.getAdjacentTileEntity((TileEntity)tile, (int)from);
        if (tileInventory instanceof TileTesseract) {
            return stack.field_77994_a;
        }
        return Utils.addToAdjacentInventory((TileEntity)this, from, stack);
    }

    public void incItemMode() {
        this.modeItem = (byte)(this.modeItem + 1);
        this.modeItem = (byte)(this.modeItem % 4);
    }

    public void decItemMode() {
        if (this.modeItem == 0) {
            this.modeItem = (byte)4;
        }
        this.modeItem = (byte)(this.modeItem - 1);
    }

    public void incFluidMode() {
        this.modeFluid = (byte)(this.modeFluid + 1);
        this.modeFluid = (byte)(this.modeFluid % 4);
    }

    public void decFluidMode() {
        if (this.modeFluid == 0) {
            this.modeFluid = (byte)4;
        }
        this.modeFluid = (byte)(this.modeFluid - 1);
    }

    public void incEnergyMode() {
        this.modeEnergy = (byte)(this.modeEnergy + 1);
        this.modeEnergy = (byte)(this.modeEnergy % 4);
    }

    public void decEnergyMode() {
        if (this.modeEnergy == 0) {
            this.modeEnergy = (byte)4;
        }
        this.modeEnergy = (byte)(this.modeEnergy - 1);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.access = ISecureTile.AccessMode.values()[nbt.func_74771_c("Access")];
        this.owner = nbt.func_74779_i("Owner");
        this.frequency = nbt.func_74762_e("Frequency");
        this.isActive = nbt.func_74767_n("Active");
        this.modeItem = nbt.func_74771_c("Item.Mode");
        this.modeFluid = nbt.func_74771_c("Fluid.Mode");
        this.modeEnergy = nbt.func_74771_c("Energy.Mode");
        this.itemTrackerAdjacent = nbt.func_74762_e("Item.Adj");
        this.itemTrackerRemote = nbt.func_74762_e("Item.Rem");
        this.fluidTrackerAdjacent = nbt.func_74762_e("Fluid.Adj");
        this.fluidTrackerRemote = nbt.func_74762_e("Fluid.Rem");
        this.energyTrackerAdjacent = nbt.func_74762_e("Energy.Adj");
        this.energyTrackerRemote = nbt.func_74762_e("Energy.Rem");
        this.addToRegistry();
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Access", (byte)this.access.ordinal());
        nbt.func_74778_a("Owner", this.owner);
        nbt.func_74768_a("Frequency", this.frequency);
        nbt.func_74757_a("Active", this.isActive);
        nbt.func_74774_a("Item.Mode", this.modeItem);
        nbt.func_74774_a("Fluid.Mode", this.modeFluid);
        nbt.func_74774_a("Energy.Mode", this.modeEnergy);
        nbt.func_74768_a("Item.Adj", this.itemTrackerAdjacent);
        nbt.func_74768_a("Item.Rem", this.itemTrackerRemote);
        nbt.func_74768_a("Fluid.Adj", this.fluidTrackerAdjacent);
        nbt.func_74768_a("Fluid.Rem", this.fluidTrackerRemote);
        nbt.func_74768_a("Energy.Adj", this.energyTrackerAdjacent);
        nbt.func_74768_a("Energy.Rem", this.energyTrackerRemote);
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addBool(this.isActive);
        payload.addByte(this.modeItem);
        payload.addByte(this.modeFluid);
        payload.addByte(this.modeEnergy);
        payload.addByte((byte)this.access.ordinal());
        payload.addInt(this.frequency);
        payload.addString(this.owner);
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        this.isActive = payload.getBool();
        this.modeItem = payload.getByte();
        this.modeFluid = payload.getByte();
        this.modeEnergy = payload.getByte();
        this.access = ISecureTile.AccessMode.values()[payload.getByte()];
        this.frequency = payload.getInt();
        this.owner = payload.getString();
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (PacketInfoID.values()[payload.getByte()]) {
            case NAME_LIST: {
                RegistryEnderAttuned.clearClientNames();
                int nameCount = payload.getInt();
                for (int i = 0; i < nameCount; ++i) {
                    RegistryEnderAttuned.addClientNames((String)payload.getString(), (String)payload.getString());
                }
                ThermalExpansion.proxy.updateTesseractGui();
                return;
            }
            case ALTER_NAME_LIST: {
                if (payload.getBool()) {
                    RegistryEnderAttuned.linkConf.getCategory(payload.getString()).remove((Object)payload.getString());
                } else {
                    RegistryEnderAttuned.linkConf.get(payload.getString(), payload.getString(), "").set(payload.getString());
                }
                this.sendNamesList((EntityPlayerMP)handler.getPlayer());
                RegistryEnderAttuned.linkConf.save();
                return;
            }
            case TILE_INFO: {
                this.removeFromRegistry();
                this.modeItem = payload.getByte();
                this.modeFluid = payload.getByte();
                this.modeEnergy = payload.getByte();
                this.access = ISecureTile.AccessMode.values()[payload.getByte()];
                this.frequency = payload.getInt();
                this.addToRegistry();
                this.isActive = this.frequency != -1;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockTesseract.field_71990_ca);
                this.sendNamesList((EntityPlayerMP)handler.getPlayer());
                return;
            }
        }
    }

    public void sendNamesList(EntityPlayerMP thePlayer) {
        String lookupName = this.access.isPublic() ? "_Public_" : this.owner;
        ConfigCategory curList = RegistryEnderAttuned.linkConf.getCategory(lookupName.toLowerCase());
        Payload myPayload = Payload.getInfoPayload((TileEntity)this);
        if (curList != null) {
            myPayload.addByte((byte)PacketInfoID.NAME_LIST.ordinal());
            myPayload.addInt(curList.size());
            for (Property curProp : curList.values()) {
                myPayload.addString(curProp.getName());
                myPayload.addString(curProp.getString());
            }
        } else {
            myPayload.addByte((byte)PacketInfoID.NAME_LIST.ordinal());
            myPayload.addInt(0);
        }
        thePlayer.field_71135_a.func_72567_b(myPayload.getPacket());
    }

    public void receiveGuiNetworkData(int i, int j) {
        this.canAccess = j != 0;
    }

    public void sendGuiNetworkData(Container container, ICrafting player) {
        int access = 0;
        if (this.canPlayerAccess(((EntityPlayer)player).field_71092_bJ)) {
            access = 1;
        }
        player.func_71112_a(container, 0, access);
    }

    @Override
    public int func_70302_i_() {
        return 1;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return null;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    @Override
    public ItemStack func_70304_b(int i) {
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        this.sendItem(stack);
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.frequency != -1 && this.canSendItems() && this.redstoneControlOrDisable() && this.inventory[0] == null;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.frequency == -1 || !this.canSendFluid() || !this.redstoneControlOrDisable() || ServerHelper.isClientWorld((World)this.field_70331_k) || resource == null) {
            return 0;
        }
        return this.sendFluid(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return TEProps.EMPTY_TANK_INFO;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.frequency == -1 || !this.canSendEnergy() || !this.redstoneControlOrDisable() || ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return 0;
        }
        return this.sendEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return 0;
    }

    public boolean setAccess(ISecureTile.AccessMode access) {
        this.access = access;
        this.sendUpdatePacket(Side.SERVER);
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.setTileInfo(-1);
        }
        return true;
    }

    public ISecureTile.AccessMode getAccess() {
        return this.access;
    }

    public boolean setOwnerName(String name) {
        if (this.owner.equals("[None]")) {
            this.owner = name;
            return true;
        }
        return false;
    }

    public String getOwnerName() {
        return this.owner;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean setFrequency(int frequency) {
        if (!this.access.isPublic() || frequency > 999 || frequency < 0) {
            return false;
        }
        this.removeFromRegistry();
        this.frequency = frequency;
        this.addToRegistry();
        this.isActive = true;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockTesseract.field_71990_ca);
        return true;
    }

    public boolean clearFrequency() {
        if (!this.access.isPublic()) {
            return false;
        }
        this.removeFromRegistry();
        this.frequency = -1;
        this.addToRegistry();
        this.isActive = false;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockTesseract.field_71990_ca);
        return true;
    }

    public boolean canSendItems() {
        return this.modeItem == TransferMode.SEND.ordinal() || this.modeItem == TransferMode.SENDRECV.ordinal();
    }

    public boolean canSendFluid() {
        return this.modeFluid == TransferMode.SEND.ordinal() || this.modeFluid == TransferMode.SENDRECV.ordinal();
    }

    public boolean canSendEnergy() {
        return this.modeEnergy == TransferMode.SEND.ordinal() || this.modeEnergy == TransferMode.SENDRECV.ordinal();
    }

    public boolean canReceiveItems() {
        return this.modeItem == TransferMode.RECV.ordinal() || this.modeItem == TransferMode.SENDRECV.ordinal();
    }

    public boolean canReceiveFluid() {
        return this.modeFluid == TransferMode.RECV.ordinal() || this.modeFluid == TransferMode.SENDRECV.ordinal();
    }

    public boolean canReceiveEnergy() {
        return this.modeEnergy == TransferMode.RECV.ordinal() || this.modeEnergy == TransferMode.SENDRECV.ordinal();
    }

    public boolean currentlyValidToReceiveItems(IEnderAttuned asker) {
        return !asker.equals((Object)this) && this.redstoneControlOrDisable() && this.canReceiveItems();
    }

    public boolean currentlyValidToReceiveFluid(IEnderAttuned asker) {
        return !asker.equals((Object)this) && this.redstoneControlOrDisable() && this.canReceiveFluid();
    }

    public boolean currentlyValidToReceiveEnergy(IEnderAttuned asker) {
        return !asker.equals((Object)this) && this.redstoneControlOrDisable() && this.canReceiveEnergy();
    }

    public boolean currentlyValidToSendItems(IEnderAttuned asker) {
        return !asker.equals((Object)this) && this.redstoneControlOrDisable() && this.canSendItems();
    }

    public boolean currentlyValidToSendFluid(IEnderAttuned asker) {
        return !asker.equals((Object)this) && this.redstoneControlOrDisable() && this.canSendFluid();
    }

    public boolean currentlyValidToSendEnergy(IEnderAttuned asker) {
        return !asker.equals((Object)this) && this.redstoneControlOrDisable() && this.canSendEnergy();
    }

    static {
        SLOTS = new int[]{0};
    }

    public static enum TransferMode {
        SEND,
        RECV,
        SENDRECV,
        BLOCKED;

    }

    public static enum PacketInfoID {
        NAME_LIST,
        ALTER_NAME_LIST,
        TILE_INFO;

    }
}

