/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.energycell;

import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.CoreUtils;
import cofh.util.ItemHelper;
import cofh.util.UpgradeRecipe;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.BlockTEBase;
import thermalexpansion.block.energycell.ItemBlockEnergyCell;
import thermalexpansion.block.energycell.TileEnergyCell;
import thermalexpansion.block.energycell.TileEnergyCellCreative;
import thermalexpansion.core.TEProps;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.crafting.PulverizerManager;
import thermalexpansion.util.crafting.TransposerManager;

public class BlockEnergyCell
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "hardened", "reinforced", "resonant"};
    public static final float[] HARDNESS = new float[]{-1.0f, 5.0f, 15.0f, 20.0f, 20.0f};
    public static final int[] RESISTANCE = new int[]{1200, 15, 90, 120, 120};
    public static boolean[] enable = new boolean[Types.values().length];
    public static final String TEXTURE_DEFAULT = "EnergyCellConfig_";
    public static final String TEXTURE_CB = "EnergyCellConfig_CB_";
    public static String textureSelection;
    public static ItemStack cellCreative;
    public static ItemStack cellBasic;
    public static ItemStack cellHardened;
    public static ItemStack cellReinforced;
    public static ItemStack cellResonant;
    public static ItemStack cellBasicFrame;
    public static ItemStack cellReinforcedFrameEmpty;
    public static ItemStack cellReinforcedFrameFull;
    public static final int BASIC_FRAME_ID = 64;
    public static final int REINFORCED_FRAME_EMPTY_ID = 72;
    public static final int REINFORCED_FRAME_FULL_ID = 73;

    public BlockEnergyCell(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(20.0f);
        this.func_71894_b(120.0f);
        this.func_71864_b("thermalexpansion.energycell");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata >= Types.values().length) {
            return null;
        }
        if (metadata == Types.CREATIVE.ordinal()) {
            return new TileEnergyCellCreative(metadata);
        }
        return new TileEnergyCell(metadata);
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            if (i != Types.CREATIVE.ordinal()) {
                list.add(ItemBlockEnergyCell.setDefaultTag(new ItemStack(itemId, 1, i), 0));
            }
            list.add(ItemBlockEnergyCell.setDefaultTag(new ItemStack(itemId, 1, i), TileEnergyCell.STORAGE[i]));
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        if (stack.field_77990_d != null) {
            TileEnergyCell tile = (TileEnergyCell)world.func_72796_p(x, y, z);
            tile.setEnergyStored(stack.field_77990_d.func_74762_e("Energy"));
            tile.energySend = stack.field_77990_d.func_74762_e("Send");
            tile.energyReceive = stack.field_77990_d.func_74762_e("Receive");
            int facing = BlockHelper.determineXZPlaceFacing((EntityLivingBase)living);
            byte storedFacing = stack.field_77990_d.func_74771_c("Facing");
            byte[] sideCache = stack.field_77990_d.func_74770_j("SideCache");
            if (sideCache.length <= 0) {
                sideCache = (byte[])TileEnergyCell.DEFAULT_SIDES.clone();
            }
            tile.sideCache[0] = sideCache[0];
            tile.sideCache[1] = sideCache[1];
            tile.sideCache[facing] = sideCache[storedFacing];
            tile.sideCache[BlockHelper.getLeftSide((int)facing)] = sideCache[BlockHelper.getLeftSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getRightSide((int)facing)] = sideCache[BlockHelper.getRightSide((int)storedFacing)];
            tile.sideCache[BlockHelper.getOppositeSide((int)facing)] = sideCache[BlockHelper.getOppositeSide((int)storedFacing)];
            tile.setControlDisable(stack.field_77990_d.func_74767_n("Disable"));
            tile.setControlSetting(stack.field_77990_d.func_74767_n("Setting"));
        }
        super.func_71860_a(world, x, y, z, living, stack);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        return HARDNESS[world.func_72805_g(x, y, z)];
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return RESISTANCE[world.func_72805_g(x, y, z)];
    }

    public int func_71856_s_() {
        return 1;
    }

    public int func_71857_b() {
        return TEProps.renderIdEnergyCell;
    }

    @Override
    public Icon func_71858_a(int side, int metadata) {
        return IconRegistry.getIcon((String)("Cell" + 2 * metadata));
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister ir) {
        for (int i = 0; i < 9; ++i) {
            IconRegistry.addIcon((String)("CellMeter" + i), (String)("thermalexpansion:energycell/Cell_Meter_" + i), (IconRegister)ir);
        }
        IconRegistry.addIcon((String)"CellMeterCreative", (String)"thermalexpansion:energycell/Cell_Meter_Creative", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell0", (String)"thermalexpansion:energycell/Cell_Creative", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell1", (String)"thermalexpansion:energycell/Cell_Creative_Inner", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell2", (String)"thermalexpansion:energycell/Cell_Basic", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell3", (String)"thermalexpansion:energycell/Cell_Basic_Inner", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell4", (String)"thermalexpansion:energycell/Cell_Hardened", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell5", (String)"thermalexpansion:energycell/Cell_Hardened_Inner", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell6", (String)"thermalexpansion:energycell/Cell_Reinforced", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell7", (String)"thermalexpansion:energycell/Cell_Reinforced_Inner", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell8", (String)"thermalexpansion:energycell/Cell_Resonant", (IconRegister)ir);
        IconRegistry.addIcon((String)"Cell9", (String)"thermalexpansion:energycell/Cell_Resonant_Inner", (IconRegister)ir);
        IconRegistry.addIcon((String)"EnergyCellConfig_0", (String)"thermalexpansion:config/Config_None", (IconRegister)ir);
        IconRegistry.addIcon((String)"EnergyCellConfig_1", (String)"thermalexpansion:energycell/Cell_Config_Orange", (IconRegister)ir);
        IconRegistry.addIcon((String)"EnergyCellConfig_2", (String)"thermalexpansion:energycell/Cell_Config_Blue", (IconRegister)ir);
        IconRegistry.addIcon((String)"EnergyCellConfig_CB_0", (String)"thermalexpansion:config/Config_None", (IconRegister)ir);
        IconRegistry.addIcon((String)"EnergyCellConfig_CB_1", (String)"thermalexpansion:energycell/Cell_Config_Orange_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"EnergyCellConfig_CB_2", (String)"thermalexpansion:energycell/Cell_Config_Blue_CB", (IconRegister)ir);
        IconRegistry.addIcon((String)"StorageRedstone", (String)"thermalexpansion:energycell/Cell_Center_Solid", (IconRegister)ir);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int x, int y, int z) {
        TileEnergyCell tile = (TileEnergyCell)world.func_72796_p(x, y, z);
        NBTTagCompound tag = null;
        if (tile != null) {
            tag = new NBTTagCompound();
            tag.func_74773_a("SideCache", tile.sideCache);
            tag.func_74774_a("Facing", (byte)tile.getFacing());
            tag.func_74768_a("Energy", tile.getEnergy());
            tag.func_74768_a("Send", tile.energySend);
            tag.func_74768_a("Receive", tile.energyReceive);
            tag.func_74757_a("Disable", tile.getControlDisable());
            tag.func_74757_a("Setting", tile.getControlSetting());
        }
        return tag;
    }

    public boolean func_96468_q_() {
        return true;
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) == Types.CREATIVE.ordinal() && !CoreUtils.isOp((EntityPlayer)player)) {
            return false;
        }
        return super.canDismantle(player, world, x, y, z);
    }

    public boolean initialize() {
        cellBasicFrame = TEItems.itemComponent.addItem(64, "cellBasicFrame");
        cellReinforcedFrameEmpty = TEItems.itemComponent.addItem(72, "cellReinforcedFrameEmpty", 1);
        cellReinforcedFrameFull = TEItems.itemComponent.addItem(73, "cellReinforcedFrameFull", 1);
        TileEnergyCell.initialize();
        TileEnergyCellCreative.initialize();
        cellCreative = new ItemStack((Block)this, 1, Types.CREATIVE.ordinal());
        cellBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        cellHardened = new ItemStack((Block)this, 1, Types.HARDENED.ordinal());
        cellReinforced = new ItemStack((Block)this, 1, Types.REINFORCED.ordinal());
        cellResonant = new ItemStack((Block)this, 1, Types.RESONANT.ordinal());
        ItemBlockEnergyCell.setDefaultTag(cellCreative, 0);
        ItemBlockEnergyCell.setDefaultTag(cellBasic, 0);
        ItemBlockEnergyCell.setDefaultTag(cellHardened, 0);
        ItemBlockEnergyCell.setDefaultTag(cellReinforced, 0);
        ItemBlockEnergyCell.setDefaultTag(cellResonant, 0);
        GameRegistry.registerCustomItemStack((String)"cellCreative", (ItemStack)cellCreative);
        GameRegistry.registerCustomItemStack((String)"cellBasic", (ItemStack)cellBasic);
        GameRegistry.registerCustomItemStack((String)"cellHardened", (ItemStack)cellHardened);
        GameRegistry.registerCustomItemStack((String)"cellReinforced", (ItemStack)cellReinforced);
        GameRegistry.registerCustomItemStack((String)"cellResonant", (ItemStack)cellResonant);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellBasic, new Object[]{" I ", "IXI", " P ", Character.valueOf('I'), "ingotCopper", Character.valueOf('X'), cellBasicFrame, Character.valueOf('P'), TEItems.powerCoilElectrum}));
            PulverizerManager.addRecipe(4000, cellBasic, ItemHelper.cloneStack((Item)Item.field_77767_aC, (int)8), ItemHelper.cloneStack((ItemStack)TEItems.ingotLead, (int)3));
        }
        if (enable[Types.HARDENED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(cellHardened, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), cellBasic}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellHardened, new Object[]{"IYI", "YXY", "IPI", Character.valueOf('I'), "ingotInvar", Character.valueOf('X'), cellBasicFrame, Character.valueOf('Y'), "ingotCopper", Character.valueOf('P'), TEItems.powerCoilElectrum}));
            PulverizerManager.addRecipe(4000, cellHardened, ItemHelper.cloneStack((Item)Item.field_77767_aC, (int)8), ItemHelper.cloneStack((ItemStack)TEItems.ingotInvar, (int)3));
        }
        if (enable[Types.REINFORCED.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellReinforced, new Object[]{" X ", "YCY", "IPI", Character.valueOf('C'), cellReinforcedFrameFull, Character.valueOf('I'), "ingotLead", Character.valueOf('P'), TEItems.powerCoilElectrum, Character.valueOf('X'), "ingotElectrum", Character.valueOf('Y'), "ingotElectrum"}));
        }
        if (enable[Types.RESONANT.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new UpgradeRecipe(cellResonant, new Object[]{" I ", "IXI", " I ", Character.valueOf('I'), "ingotEnderium", Character.valueOf('X'), cellReinforced}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellBasicFrame, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotLead", Character.valueOf('G'), "glass", Character.valueOf('X'), Block.field_94341_cq}));
        PulverizerManager.addRecipe(4000, cellBasicFrame, ItemHelper.cloneStack((Item)Item.field_77767_aC, (int)8), ItemHelper.cloneStack((ItemStack)TEItems.ingotLead, (int)3));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(cellReinforcedFrameEmpty, new Object[]{"IGI", "GXG", "IGI", Character.valueOf('I'), "ingotElectrum", Character.valueOf('G'), "glassHardened", Character.valueOf('X'), Item.field_77702_n}));
        TransposerManager.addTEFillRecipe(16000, cellReinforcedFrameEmpty, cellReinforcedFrameFull, new FluidStack(TEFluids.fluidRedstone, 4000), false);
        return true;
    }

    static {
        String category = "block.feature";
        BlockEnergyCell.enable[Types.CREATIVE.ordinal()] = ThermalExpansion.config.get(category, "Cell.Creative", true);
        BlockEnergyCell.enable[Types.BASIC.ordinal()] = ThermalExpansion.config.get(category, "Cell.Basic", true);
        BlockEnergyCell.enable[Types.HARDENED.ordinal()] = ThermalExpansion.config.get(category, "Cell.Hardened", true);
        BlockEnergyCell.enable[Types.REINFORCED.ordinal()] = ThermalExpansion.config.get(category, "Cell.Reinforced", true);
        BlockEnergyCell.enable[Types.RESONANT.ordinal()] = ThermalExpansion.config.get(category, "Cell.Resonant", true);
        textureSelection = TEXTURE_DEFAULT;
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        HARDENED,
        REINFORCED,
        RESONANT;

    }
}

