/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.energycell;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyStorage;
import cofh.network.ITileInfoPacketHandler;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.render.IconRegistry;
import cofh.util.BlockHelper;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileReconfigurableBase;
import thermalexpansion.block.energycell.BlockEnergyCell;
import thermalexpansion.core.TEProps;

public class TileEnergyCell
extends TileReconfigurableBase
implements ITileInfoPacketHandler,
IEnergyHandler {
    protected static int guiId;
    public static final int[] MAX_SEND;
    public static final int[] MAX_RECEIVE;
    public static final int[] STORAGE;
    public static final byte[] DEFAULT_SIDES;
    public byte type;
    int energyTracker;
    int compareTracker;
    byte outputTracker;
    EnergyStorage energyStorage;
    boolean cached = false;
    IEnergyHandler[] adjacentHandlers = new IEnergyHandler[6];
    public int energyReceive;
    public int energySend;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileEnergyCell.class, (String)"cofh.thermalexpansion.EnergyCell");
        guiId = ThermalExpansion.proxy.registerGui("EnergyCell", null, "TEBase", null, true);
    }

    public TileEnergyCell() {
        this.energyStorage = new EnergyStorage(STORAGE[1], MAX_RECEIVE[1]);
    }

    public TileEnergyCell(int metadata) {
        this.energyStorage = new EnergyStorage(STORAGE[metadata], MAX_RECEIVE[metadata]);
        this.type = (byte)metadata;
    }

    public int getComparatorInput(int side) {
        return this.compareTracker;
    }

    public int getLightValue() {
        return Math.min(8, this.getScaledEnergyStored(9));
    }

    public String getName() {
        return "tile.thermalexpansion.energycell." + BlockEnergyCell.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void onNeighborTileChange(int tileX, int tileY, int tileZ) {
        super.onNeighborTileChange(tileX, tileY, tileZ);
        this.updateAdjacentHandler(tileX, tileY, tileZ);
    }

    protected void updateAdjacentHandlers() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            this.adjacentHandlers[i] = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tile, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i ^ 1]) ? (IEnergyHandler)tile : null;
        }
        this.cached = true;
    }

    protected void updateAdjacentHandler(int x, int y, int z) {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        int side = BlockHelper.determineAdjacentSide((TileEntity)this, (int)x, (int)y, (int)z);
        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
        this.adjacentHandlers[side] = EnergyHelper.isEnergyHandlerFromSide((TileEntity)tile, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[side ^ 1]) ? (IEnergyHandler)tile : null;
    }

    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (!this.cached) {
            this.onNeighborBlockChange();
        }
        if (this.redstoneControlOrDisable()) {
            int i;
            for (i = this.outputTracker; i < 6 && this.energyStorage.getEnergyStored() > 0; ++i) {
                this.transferEnergy(i);
            }
            for (i = 0; i < this.outputTracker && this.energyStorage.getEnergyStored() > 0; ++i) {
                this.transferEnergy(i);
            }
            this.outputTracker = (byte)(this.outputTracker + 1);
            this.outputTracker = (byte)(this.outputTracker % 6);
        }
        if (this.timeCheck()) {
            int energyStage;
            int curScale = this.getScaledEnergyStored(15);
            if (curScale != this.compareTracker) {
                this.compareTracker = curScale;
                this.callNeighborTileChange();
            }
            if (this.energyTracker != (energyStage = this.getLightValue())) {
                this.energyTracker = energyStage;
                this.sendUpdatePacket(Side.CLIENT);
            }
        }
    }

    public void setEnergyStored(int quantity) {
        this.energyStorage.setEnergyStored(quantity);
    }

    protected void transferEnergy(int bSide) {
        if (this.sideCache[bSide] != 1) {
            return;
        }
        if (this.adjacentHandlers[bSide] == null) {
            return;
        }
        this.energyStorage.modifyEnergyStored(-this.adjacentHandlers[bSide].receiveEnergy(ForgeDirection.VALID_DIRECTIONS[bSide ^ 1], Math.min(this.energySend, this.energyStorage.getEnergyStored()), false));
    }

    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public Payload getDescriptionPayload() {
        Payload payload = super.getDescriptionPayload();
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    public Payload getGuiPayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.GUI.ordinal());
        payload.addInt(this.energySend);
        payload.addInt(this.energyReceive);
        payload.addInt(this.energyStorage.getEnergyStored());
        return payload;
    }

    public Payload getModePayload() {
        Payload payload = Payload.getInfoPayload((TileEntity)this);
        payload.addByte(TEProps.PacketID.MODE.ordinal());
        payload.addInt(MathHelper.clampI((int)this.energySend, (int)0, (int)MAX_SEND[this.getType()]));
        payload.addInt(MathHelper.clampI((int)this.energyReceive, (int)0, (int)MAX_RECEIVE[this.getType()]));
        return payload;
    }

    @Override
    public void handleTilePacket(Payload payload) {
        super.handleTilePacket(payload);
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            this.energyStorage.setEnergyStored(payload.getInt());
        }
    }

    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.energySend = payload.getInt();
                this.energyReceive = payload.getInt();
                this.energyStorage.setEnergyStored(payload.getInt());
                return;
            }
            case MODE: {
                this.energySend = payload.getInt();
                this.energyReceive = payload.getInt();
                return;
            }
        }
    }

    public void sendModePacket() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getModePayload().getPacket());
        }
    }

    public int getEnergy() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergy() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int getScaledEnergyStored(int scale) {
        return this.energyStorage.getEnergyStored() * scale / this.energyStorage.getMaxEnergyStored();
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && ServerHelper.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((Packet)this.getGuiPayload().getPacket(), (EntityPlayer)((EntityPlayer)iCrafting));
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.type = nbt.func_74771_c("Type");
        this.outputTracker = nbt.func_74771_c("Tracker");
        this.energySend = nbt.func_74762_e("Send");
        this.energyReceive = nbt.func_74762_e("Recv");
        this.energySend = MathHelper.clampI((int)this.energySend, (int)0, (int)MAX_SEND[this.type]);
        this.energyReceive = MathHelper.clampI((int)this.energyReceive, (int)0, (int)MAX_RECEIVE[this.type]);
        this.energyStorage = new EnergyStorage(STORAGE[this.type], MAX_RECEIVE[this.type]);
        this.energyStorage.readFromNBT(nbt);
        this.energyTracker = Math.min(8, this.getScaledEnergyStored(9));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("Type", this.type);
        nbt.func_74774_a("Tracker", this.outputTracker);
        nbt.func_74768_a("Send", this.energySend);
        nbt.func_74768_a("Recv", this.energyReceive);
        this.energyStorage.writeToNBT(nbt);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] == 2) {
            return this.energyStorage.receiveEnergy(Math.min(maxReceive, this.energyReceive), simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] == 1) {
            return this.energyStorage.extractEnergy(Math.min(maxExtract, this.energySend), simulate);
        }
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        if (from == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.sideCache[from.ordinal()] > 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean allowYAxisFacing() {
        return false;
    }

    @Override
    public boolean rotateBlock() {
        super.rotateBlock();
        this.updateAdjacentHandlers();
        return true;
    }

    @Override
    public int getNumConfig(int side) {
        return 3;
    }

    @Override
    public Icon getBlockTexture(int side, int pass) {
        if (pass == 0) {
            return this.type < 2 ? IconRegistry.getIcon((String)"StorageRedstone") : IconRegistry.getIcon((String)"FluidRedstone");
        }
        if (pass == 1) {
            return IconRegistry.getIcon((String)"Cell", (int)(this.type * 2));
        }
        if (pass == 2) {
            return IconRegistry.getIcon((String)BlockEnergyCell.textureSelection, (int)this.sideCache[side]);
        }
        int energy = Math.min(8, this.getScaledEnergyStored(9));
        return side != this.facing ? IconRegistry.getIcon((String)BlockEnergyCell.textureSelection, (int)0) : IconRegistry.getIcon((String)"CellMeter", (int)energy);
    }

    static {
        MAX_SEND = new int[]{10000, 80, 400, 2000, 10000};
        MAX_RECEIVE = new int[]{0, 80, 400, 2000, 10000};
        STORAGE = new int[]{10000, 400000, 2000000, 10000000, 50000000};
        DEFAULT_SIDES = new byte[]{1, 2, 2, 2, 2, 2};
    }

    public static class SideType {
        public static final byte NONE = 0;
        public static final byte OUTPUT = 1;
        public static final byte INPUT = 2;
    }
}

