/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.Payload;
import cofh.util.InventoryHelper;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import cofh.util.inventory.InventoryCraftingFalse;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.NetHandler;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.BlockMachine;
import thermalexpansion.block.machine.TileMachineBase;
import thermalexpansion.block.machine.TileMachineEnergized;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.SchematicHelper;

public class TileAssembler
extends TileMachineEnergized
implements IFluidHandler {
    public static final int TYPE = BlockMachine.Types.ASSEMBLER.ordinal();
    public static final int PROCESS_ENERGY = 2;
    FluidTank tank = new FluidTank(10000);
    public boolean needsCraft = false;
    private boolean needsCache = true;
    ItemStack recipeOutput;
    int outputTracker;
    InventoryCrafting tempCraft = new InventoryCraftingFalse(3, 3);
    ItemStack[] recipeSlot = new ItemStack[9];
    String[] recipeOre = new String[9];
    FluidStack[] filledContainer = new FluidStack[9];

    public static void initialize() {
        TileAssembler.sideData[TileAssembler.TYPE] = new TileMachineBase.SideConfig();
        TileAssembler.sideData[TileAssembler.TYPE].numGroup = 3;
        TileAssembler.sideData[TileAssembler.TYPE].slotGroups = new int[][]{new int[0], {3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20}, {1}};
        TileAssembler.sideData[TileAssembler.TYPE].allowInsertion = new boolean[]{false, true, false};
        TileAssembler.sideData[TileAssembler.TYPE].allowExtraction = new boolean[]{false, false, true};
        TileAssembler.sideData[TileAssembler.TYPE].sideTex = new int[]{0, 1, 4};
        TileAssembler.energyData[TileAssembler.TYPE] = new TileMachineEnergized.EnergyConfig();
        energyData[TYPE].setEnergyParams(20);
        TileAssembler.guiIds[TileAssembler.TYPE] = ThermalExpansion.proxy.registerGui("Assembler", "machine", true);
        GameRegistry.registerTileEntity(TileAssembler.class, (String)"cofh.thermalexpansion.Assembler");
    }

    public TileAssembler() {
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[21];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public int getChargeSlot() {
        return 2;
    }

    public boolean canCreate(ItemStack recipe) {
        return recipe != null && (this.inventory[1] == null || recipe.func_77969_a(this.inventory[1]) && this.inventory[1].field_77994_a + recipe.field_77994_a <= recipe.func_77976_d());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateOutput() {
        if (this.inventory[0] == null) return;
        if (this.needsCache) {
            this.recipeOutput = SchematicHelper.getOutput(this.inventory[0], this.field_70331_k);
            for (int i = 0; i < 9; ++i) {
                this.recipeSlot[i] = SchematicHelper.getSchematicSlot(this.inventory[0], i);
                this.filledContainer[i] = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.recipeSlot[i]);
                this.recipeOre[i] = SchematicHelper.getSchematicOreSlot(this.inventory[0], i);
            }
            this.needsCache = false;
        }
        if (this.recipeOutput == null) {
            this.isActive = false;
            return;
        }
        if (this.canCreate(this.recipeOutput)) {
            if (this.createItem()) {
                this.recipeOutput = ItemHelper.findMatchingRecipe((InventoryCrafting)this.tempCraft, (World)this.field_70331_k);
                if (this.recipeOutput == null) return;
                if (this.inventory[1] == null) {
                    this.inventory[1] = this.recipeOutput.func_77946_l();
                } else {
                    this.inventory[1].field_77994_a += this.recipeOutput.field_77994_a;
                }
                this.isActive = true;
                return;
            }
            if (this.energyStorage.getEnergyStored() >= 2) {
                this.needsCraft = false;
            }
            this.wasActive = true;
            this.isActive = false;
            return;
        }
        if (this.isActive) {
            this.wasActive = true;
        }
        this.isActive = false;
    }

    public boolean createItem() {
        if (this.energyStorage.getEnergyStored() < 2) {
            return false;
        }
        ItemStack[] invCopy = InventoryHelper.cloneInventory((ItemStack[])this.inventory);
        FluidStack fluidCopy = null;
        if (this.tank.getFluid() != null) {
            fluidCopy = this.tank.getFluid().copy();
        }
        boolean found = false;
        for (int i = 0; i < 9; ++i) {
            if (fluidCopy != null && fluidCopy.isFluidEqual(this.filledContainer[i]) && fluidCopy.amount >= this.filledContainer[i].amount) {
                fluidCopy.amount -= this.filledContainer[i].amount;
                this.tempCraft.func_70299_a(i, this.recipeSlot[i].func_77946_l());
                continue;
            }
            if (this.recipeSlot[i] != null) {
                for (int j = 2; j < invCopy.length; ++j) {
                    if (invCopy[j] == null || !ItemHelper.craftingEquivalent((ItemStack)invCopy[j], (ItemStack)this.recipeSlot[i], (String)this.recipeOre[i], (ItemStack)this.recipeOutput)) continue;
                    this.tempCraft.func_70299_a(i, invCopy[j].func_77946_l());
                    --invCopy[j].field_77994_a;
                    if (invCopy[j].func_77973_b().func_77634_r()) {
                        ItemStack containerStack = invCopy[j].func_77973_b().getContainerItemStack(invCopy[j]);
                        if (containerStack.func_77984_f() && containerStack.func_77960_j() > containerStack.func_77958_k()) {
                            containerStack = null;
                        }
                        if (!(containerStack == null || invCopy[j].func_77973_b().func_77630_h(invCopy[j]) && InventoryHelper.addItemStackToInventory((ItemStack[])invCopy, (ItemStack)containerStack, (int)3))) {
                            if (invCopy[j].field_77994_a <= 0) {
                                invCopy[j] = containerStack;
                                if (containerStack.field_77994_a <= 0) {
                                    invCopy[j].field_77994_a = 1;
                                }
                            } else {
                                return false;
                            }
                        }
                    }
                    if (invCopy[j].field_77994_a <= 0) {
                        invCopy[j] = null;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
                found = false;
                continue;
            }
            this.tempCraft.func_70299_a(i, null);
        }
        this.inventory = invCopy;
        if (fluidCopy == null || fluidCopy.amount <= 0) {
            fluidCopy = null;
        }
        this.tank.setFluid(fluidCopy);
        this.energyStorage.modifyEnergyStored(-2);
        return true;
    }

    @Override
    protected void transferProducts() {
        if (this.inventory[1] == null) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.transferItem(1, 64, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (ServerHelper.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.redstoneControlOrDisable()) {
            if (this.needsCraft) {
                this.updateOutput();
            }
            if (this.timeCheck()) {
                this.transferProducts();
            }
        } else {
            if (this.isActive) {
                this.wasActive = true;
            }
            this.isActive = false;
        }
        this.updateIfChanged(curActive);
        this.chargeEnergy();
    }

    @Override
    public Payload getGuiPayload() {
        Payload payload = super.getGuiPayload();
        payload.addFluidStack(this.getTankFluid());
        return payload;
    }

    @Override
    public void handleTileInfoPacket(Payload payload, NetHandler handler) {
        switch (TEProps.PacketID.values()[payload.getByte()]) {
            case GUI: {
                this.isActive = payload.getBool();
                this.processMax = payload.getInt();
                this.processRem = payload.getInt();
                this.energyStorage.setEnergyStored(payload.getInt());
                this.tank.setFluid(payload.getFluidStack());
                return;
            }
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.outputTracker = nbt.func_74762_e("Output");
        this.needsCraft = true;
        this.needsCache = true;
        this.tank.readFromNBT(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Output", this.outputTracker);
        this.tank.writeToNBT(nbt);
    }

    @Override
    public void func_70296_d() {
        this.needsCraft = true;
        super.func_70296_d();
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        this.needsCraft = true;
        this.needsCache = this.needsCache ? true : slot == 0;
        return super.func_70298_a(slot, amount);
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.needsCraft = true;
        this.needsCache = this.needsCache ? true : slot == 0;
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        int filled = this.tank.fill(resource, doFill);
        if (doFill && filled > 0) {
            this.needsCraft = true;
        }
        return filled;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from == ForgeDirection.UNKNOWN || this.sideCache[from.ordinal()] != 2) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

