/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.entity.monster;

import cofh.entity.EntitySelectorInRangeByType;
import cofh.util.ItemHelper;
import cofh.util.ServerHelper;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import thermalexpansion.core.TEProps;
import thermalexpansion.entity.projectile.EntityBlizzBall;
import thermalexpansion.entity.projectile.EntityBlizzSpike;
import thermalexpansion.item.TEItems;
import thermalexpansion.util.Utils;

public class EntityBlizz
extends EntityMob {
    protected float heightOffset = 0.5f;
    protected int heightOffsetUpdateTime;
    protected int firingState;
    protected static final String soundAmbient = Utils.getSoundName("mob/blizz/cryosound");
    protected static final String soundLiving = Utils.getSoundName("mob/blizz/breathe");
    protected static final String soundSpike = Utils.getSoundName("mob/blizz/spike");
    protected static final int soundAmbientFrequency = 42;

    public static void initialize() {
        TEProps.entityIdBlizz = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityBlizz.class, (String)"Blizz", (int)TEProps.entityIdBlizz, (int)14744575, (int)7071487);
        List<BiomeGenBase> validBiomes = Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.FROZEN));
        ArrayList types = Lists.newArrayList();
        ArrayList fine = Lists.newArrayList((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.END, BiomeDictionary.Type.FROZEN});
        for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL)) {
            if (biome.func_76736_e() || validBiomes.contains(biome)) continue;
            types.clear();
            types.addAll(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)));
            types.removeAll(fine);
            if (types.size() != 0) continue;
            validBiomes.add(biome);
        }
        types.clear();
        EntityRegistry.addSpawn(EntityBlizz.class, (int)4, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])validBiomes.toArray(new BiomeGenBase[0]));
    }

    public EntityBlizz(World world) {
        super(world);
        this.field_70728_aV = 10;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new Byte(0));
    }

    protected String func_70639_aQ() {
        return soundLiving;
    }

    protected String func_70621_aR() {
        return "mob.blaze.hit";
    }

    protected String func_70673_aS() {
        return "mob.blaze.death";
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }

    public float func_70013_c(float par1) {
        return 2.0f;
    }

    public void func_70636_d() {
        if (ServerHelper.isServerWorld((World)this.field_70170_p)) {
            Entity target;
            --this.heightOffsetUpdateTime;
            if (this.heightOffsetUpdateTime <= 0) {
                this.heightOffsetUpdateTime = 100;
                this.heightOffset = 0.5f + (float)this.field_70146_Z.nextGaussian() * 3.0f;
            }
            if ((target = this.func_70777_m()) != null && target.field_70163_u + (double)target.func_70047_e() > this.field_70163_u + (double)this.func_70047_e() + (double)this.heightOffset) {
                this.field_70181_x += ((double)0.3f - this.field_70181_x) * (double)0.3f;
            }
        }
        if (this.field_70146_Z.nextInt(42) == 0) {
            this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, soundAmbient, 0.4f + 0.2f * this.field_70146_Z.nextFloat(), this.field_70146_Z.nextFloat() * 0.7f + 0.3f);
        }
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_72869_a("snowballpoof", this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * ((double)this.field_70131_O * 0.2), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    protected Entity func_70782_k() {
        EntityPlayer player = this.field_70170_p.func_72856_b((Entity)this, 16.0);
        if (player != null && this.func_70685_l((Entity)player)) {
            return player;
        }
        return this.getClosestVictim(16.0);
    }

    public Entity getClosestVictim(double dist) {
        EntitySelectorInRangeByType entsel;
        AxisAlignedBB aabb = AxisAlignedBB.func_72332_a().func_72299_a(this.field_70165_t - dist, this.field_70163_u - dist, this.field_70161_v - dist, this.field_70165_t + dist, this.field_70163_u + dist, this.field_70161_v + dist);
        List entities = this.field_70170_p.func_94576_a((Entity)this, aabb, (IEntitySelector)(entsel = new EntitySelectorInRangeByType((Entity)this, dist, new Class[]{EntityBlaze.class, EntityAnimal.class})));
        if (entities.isEmpty()) {
            return null;
        }
        Entity victim = null;
        boolean hasBlaze = false;
        double closest = Double.MAX_VALUE;
        for (Entity entity : entities) {
            boolean isBlaze = entity instanceof EntityBlaze;
            if (hasBlaze && !isBlaze) continue;
            double distVsq = this.func_70068_e(entity);
            if ((!isBlaze || hasBlaze) && !(distVsq < closest)) continue;
            closest = distVsq;
            victim = entity;
            hasBlaze |= isBlaze;
        }
        return victim;
    }

    protected void func_70785_a(Entity target, float distance) {
        if (this.field_70724_aR <= 0 && distance < 2.0f && target.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && target.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(target);
        } else if (distance < 30.0f) {
            double dX = target.field_70165_t - this.field_70165_t;
            double dZ = target.field_70161_v - this.field_70161_v;
            if (this.field_70724_aR == 0) {
                if (target instanceof EntityBlizz || target.isCreatureType(EnumCreatureType.creature, false)) {
                    EntityBlizzBall snowball = new EntityBlizzBall(this.field_70170_p, (EntityLivingBase)this);
                    double dSY = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - snowball.field_70163_u;
                    float f1 = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ)) * 0.2f;
                    snowball.func_70186_c(dX, dSY + (double)f1, dZ, 1.6f, 12.0f);
                    this.func_85030_a("random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.field_70170_p.func_72838_d((Entity)snowball);
                    this.func_70784_b(null);
                    this.field_70724_aR = 80;
                    this.firingState = 0;
                    this.setInAttackMode(false);
                } else {
                    ++this.firingState;
                    if (this.firingState == 1) {
                        this.field_70724_aR = 60;
                        this.setInAttackMode(true);
                    } else if (this.firingState <= 5) {
                        this.field_70724_aR = 6;
                    } else {
                        this.field_70724_aR = 80;
                        this.firingState = 0;
                        this.setInAttackMode(false);
                    }
                    if (this.firingState > 1) {
                        EntityLivingBase tgt = (EntityLivingBase)target;
                        float f1 = MathHelper.func_76129_c((float)distance) * 0.5f;
                        double dY = tgt.field_70121_D.field_72338_b + (double)(tgt.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                        EntityBlizzSpike spike = new EntityBlizzSpike(this.field_70170_p, (EntityLivingBase)this, dX + this.field_70146_Z.nextGaussian() * (double)f1, dY, dZ + this.field_70146_Z.nextGaussian() * (double)f1);
                        spike.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
                        this.func_85030_a(soundSpike, 2.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                        this.field_70170_p.func_72838_d((Entity)spike);
                    }
                }
            }
            this.field_70177_z = (float)(Math.atan2(dZ, dX) * 180.0 / Math.PI) - 90.0f;
            this.field_70787_b = true;
        }
    }

    protected void func_70069_a(float par1) {
    }

    protected int func_70633_aT() {
        return Item.field_77768_aD.field_77779_bT;
    }

    protected void func_70628_a(boolean wasHitByPlayer, int looting) {
        if (wasHitByPlayer) {
            int i;
            int items = this.field_70146_Z.nextInt(4 + looting);
            for (i = 0; i < items; ++i) {
                this.func_70025_b(this.func_70633_aT(), 1);
            }
            items = this.field_70146_Z.nextInt(2 + looting);
            for (i = 0; i < items; ++i) {
                this.func_70099_a(ItemHelper.cloneStack((ItemStack)TEItems.rodBlizz, (int)1), 0.0f);
            }
        }
    }

    public boolean isInAttackMode() {
        return (this.field_70180_af.func_75683_a(16) & 1) != 0;
    }

    public void setInAttackMode(boolean mode) {
        byte b0 = this.field_70180_af.func_75683_a(16);
        b0 = mode ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_75692_b(16, (Object)b0);
    }

    public boolean func_70601_bi() {
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        int bId = this.field_70170_p.func_72798_a(x, y - 1, z);
        Block block = Block.field_71973_m[bId];
        if (bId == Block.field_72037_aS.field_71990_ca || bId == Block.field_72036_aT.field_71990_ca || bId == Block.field_72039_aU.field_71990_ca || bId == Block.field_71981_t.field_71990_ca && super.func_70814_o()) {
            return super.func_70601_bi();
        }
        return false;
    }

    protected boolean func_70814_o() {
        return true;
    }
}

