/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.part.conduit.energy;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cofh.api.energy.IEnergyHandler;
import cofh.util.BlockHelper;
import cofh.util.EnergyHelper;
import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.item.TEItems;
import thermalexpansion.part.conduit.ConduitBase;
import thermalexpansion.part.conduit.Grid;
import thermalexpansion.part.conduit.IConduit;
import thermalexpansion.part.conduit.ItemConduitPart;
import thermalexpansion.part.conduit.energy.GridEnergy;
import thermalexpansion.util.Utils;

public class ConduitEnergy
extends ConduitBase
implements IEnergyHandler,
IConduit {
    IEnergyHandler[] importantCache = new IEnergyHandler[6];
    PowerHandler.PowerReceiver[] importantCache2;
    public int energyForGrid = 0;
    public int lastStoredValue = 0;
    public GridEnergy myGrid;
    public boolean trackEnergyUsage = false;
    public int energyUsed = 0;
    public int energyUsedTracker = 0;
    public List<EntityPlayer> playersTracking;
    static int[][] sideTypes = new int[3][3];
    static int[][] modeTypes = new int[3][2];
    static int[] _TYPE;
    static int[] _RENDER_TYPE;
    public static final int[] NODE_STORAGE;
    public static final int[] NODE_TRANSFER;

    public static void initialize() {
    }

    public ConduitEnergy(byte type) {
        super(type);
    }

    @Override
    public void setGrid(Grid newGrid) {
        super.setGrid(newGrid);
        this.myGrid = (GridEnergy)newGrid;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.energyForGrid = nbt.func_74762_e("Energy");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.myGrid != null) {
            if (this.isNode) {
                this.lastStoredValue = this.myGrid.getNodeShare(this);
                nbt.func_74768_a("Energy", this.lastStoredValue);
            }
        } else if (this.energyForGrid > 0) {
            nbt.func_74768_a("Energy", this.energyForGrid);
        } else {
            this.energyForGrid = 0;
        }
    }

    @Override
    public void doOutput() {
        int i;
        if (this.myGrid == null) {
            return;
        }
        int energyUsed = 0;
        int sideEnergy = this.myGrid.getDistributionSide(this);
        for (i = this.sideTracker; i < 6; ++i) {
            energyUsed += this.transfer(i, sideEnergy);
        }
        for (i = 0; i < this.sideTracker; ++i) {
            energyUsed += this.transfer(i, sideEnergy);
        }
        this.myGrid.myStorage.extractEnergy(energyUsed, false);
        if (this.trackEnergyUsage) {
            this.energyUsed += energyUsed;
            ++this.energyUsedTracker;
            if (this.energyUsedTracker >= 20) {
                this.trackEnergyUsage = false;
                for (i = 0; this.playersTracking != null && i < this.playersTracking.size(); ++i) {
                    this.playersTracking.get(i).func_70006_a(ChatMessageComponent.func_111066_d((String)(StringHelper.localize((String)"message.thermalexpansion.conduit.energy2") + " (" + this.energyUsedTracker + " " + StringHelper.localize((String)"message.thermalexpansion.conduit.energy3") + "): " + this.getAverageTransfer())));
                }
                this.energyUsed = 0;
                this.energyUsedTracker = 0;
                this.playersTracking = null;
            }
        }
        this.increaseTracker();
    }

    public int getAverageTransfer() {
        if (this.energyUsedTracker <= 0) {
            return 0;
        }
        return this.energyUsed / this.energyUsedTracker;
    }

    protected int transfer(int bSide, int available) {
        if (this.sideType[bSide] == 2 && this.sideMode[bSide] == 1) {
            PowerHandler.PowerReceiver tileHandler;
            if (this.cacheType[bSide] == ConduitBase.CacheTypes.NOT_SET) {
                this.cacheSide(bSide);
            }
            ForgeDirection sideFD = ForgeDirection.VALID_DIRECTIONS[bSide].getOpposite();
            if (this.cacheType[bSide] == ConduitBase.CacheTypes.IMPORTANT) {
                IEnergyHandler TETile = this.getImportant(bSide);
                if (TETile != null) {
                    return TETile.receiveEnergy(sideFD, available, false);
                }
            } else if (this.cacheType[bSide] == ConduitBase.CacheTypes.IMPORTANT2 && (tileHandler = this.getImportant2(bSide)) != null) {
                int powerToSend = MathHelper.floor((double)(tileHandler.getMaxEnergyStored() - tileHandler.getEnergyStored()));
                powerToSend = Math.min(powerToSend, available / 10);
                return MathHelper.ceil((double)tileHandler.receiveEnergy(PowerHandler.Type.PIPE, powerToSend, sideFD)) * 10;
            }
        }
        return 0;
    }

    public void cacheSide(int side) {
        TileEntity adjTile = BlockHelper.getAdjacentTileEntity((TileEntity)this.tile(), (int)side);
        if (adjTile instanceof IEnergyHandler) {
            this.importantCache[side] = (IEnergyHandler)adjTile;
            this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT;
        } else if (adjTile instanceof IPowerReceptor) {
            if (this.importantCache2 == null) {
                this.importantCache2 = new PowerHandler.PowerReceiver[6];
            }
            this.importantCache2[side] = ((IPowerReceptor)adjTile).getPowerReceiver(ForgeDirection.VALID_DIRECTIONS[side].getOpposite());
            this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT2;
        } else {
            this.sideType[side] = 0;
        }
    }

    public IEnergyHandler getImportant(int side) {
        return this.importantCache[side];
    }

    public PowerHandler.PowerReceiver getImportant2(int side) {
        return this.importantCache2[side];
    }

    @Override
    public void getTileInfo(List<String> info, ForgeDirection side, EntityPlayer player, boolean debug) {
        if (ServerHelper.isClientWorld((World)this.world())) {
            return;
        }
        if (this.gridBase == null) {
            info.add("Grid: Null");
            return;
        }
        if (debug) {
            try {
                if (this.myGrid != null) {
                    this.myGrid.destroyGrid();
                    this.calculateGrid();
                    info.add(this.myGrid == null ? "Grid Null" : "Conduits: " + this.myGrid.conduitSet.size() + ", Nodes: " + this.myGrid.nodeSet.size());
                    info.add("Grid Max: " + this.myGrid.myStorage.getMaxEnergyStored());
                    info.add("Grid Cur: " + this.myGrid.myStorage.getEnergyStored());
                } else {
                    info.add("Null Grid");
                    this.calculateGrid();
                }
                info.add("SideType: " + Arrays.toString(this.sideType));
                info.add("Internal Type: " + this.conduitType);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                info.add("Info Not Available");
                return;
            }
        }
        if (this.isNode) {
            if (this.playersTracking == null) {
                this.playersTracking = new LinkedList<EntityPlayer>();
            }
            this.playersTracking.add(player);
            this.trackEnergyUsage = true;
            info.add(StringHelper.localize((String)"message.thermalexpansion.conduit.energy1") + "...");
        } else {
            float saturation = 100 * this.myGrid.myStorage.getEnergyStored() / this.myGrid.myStorage.getMaxEnergyStored();
            info.add(StringHelper.localize((String)"message.thermalexpansion.conduit.energy0") + ": " + String.format("%.1f", Float.valueOf(saturation)) + "%");
        }
    }

    @Override
    public ConduitEnergy getConduitEnergy() {
        return this;
    }

    @Override
    public int isEnergyConduit() {
        return this.conduitType;
    }

    @Override
    public boolean isImportant(TileEntity curTile, int side) {
        return !(curTile instanceof IConduit) && (EnergyHelper.isEnergyHandlerFromSide((TileEntity)curTile, (ForgeDirection)ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[side])) || Utils.isPowerReceptorFromSide(curTile, ForgeDirection.getOrientation((int)ForgeDirection.OPPOSITES[side])));
    }

    @Override
    public boolean isConduit(TileEntity curTile) {
        return curTile instanceof IConduit && this.isEnergyConduit() == ((IConduit)curTile).isEnergyConduit();
    }

    @Override
    public void cacheImportant(TileEntity theTile, int side) {
        if (theTile instanceof IEnergyHandler) {
            this.importantCache[side] = (IEnergyHandler)theTile;
            this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT;
        } else if (theTile instanceof IPowerReceptor) {
            if (this.importantCache2 == null) {
                this.importantCache2 = new PowerHandler.PowerReceiver[6];
            }
            this.importantCache2[side] = ((IPowerReceptor)theTile).getPowerReceiver(ForgeDirection.VALID_DIRECTIONS[side].getOpposite());
            this.cacheType[side] = ConduitBase.CacheTypes.IMPORTANT2;
        }
    }

    @Override
    public Grid createNewGrid() {
        return new GridEnergy(this, NODE_STORAGE[this.conduitType], NODE_TRANSFER[this.conduitType]);
    }

    @Override
    public void tileUnloading() {
        if (this.isNode) {
            this.myGrid.myStorage.extractEnergy(this.lastStoredValue, false);
        }
    }

    @Override
    public String getType() {
        return "ConduitEnergy" + this.conduitType;
    }

    @Override
    public ItemStack pickItem(MovingObjectPosition hit) {
        return new ItemStack((Item)ItemConduitPart.itemConduit, 1, (int)this.conduitType);
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> myList = new LinkedList<ItemStack>();
        if (this.hasServo) {
            myList.add(TEItems.pneumaticServo.func_77946_l());
        }
        myList.add(new ItemStack((Item)ItemConduitPart.itemConduit, 1, (int)this.conduitType));
        return myList;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.myGrid != null && this.sideMode[from.ordinal()] == 1) {
            return this.myGrid.myStorage.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canInterface(ForgeDirection from) {
        return this.sideMode[from.ordinal()] == 1;
    }

    public int getEnergyStored(ForgeDirection from) {
        if (this.myGrid != null && this.sideMode[from.ordinal()] == 1) {
            return this.myGrid.myStorage.getEnergyStored();
        }
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        if (this.myGrid != null && this.sideMode[from.ordinal()] == 1) {
            return this.myGrid.myStorage.getMaxEnergyStored();
        }
        return 0;
    }

    @Override
    public int getRenderType() {
        return _RENDER_TYPE[this.conduitType];
    }

    @Override
    public int getConnectionType(int side) {
        return this.sideType[side] == 2 ? modeTypes[this.conduitType][this.sideMode[side]] : sideTypes[this.conduitType][this.sideType[side]];
    }

    static {
        for (int i = 0; i < SubTypes.values().length; ++i) {
            ConduitEnergy.sideTypes[i][0] = BlockConduit.ConnectionTypes.NONE.ordinal();
            ConduitEnergy.sideTypes[i][1] = BlockConduit.ConnectionTypes.CONDUIT.ordinal();
        }
        ConduitEnergy.sideTypes[SubTypes.LOW.ordinal()][2] = BlockConduit.ConnectionTypes.ENERGY_BASIC.ordinal();
        ConduitEnergy.sideTypes[SubTypes.MID.ordinal()][2] = BlockConduit.ConnectionTypes.ENERGY_HARDENED.ordinal();
        ConduitEnergy.sideTypes[SubTypes.HIGH.ordinal()][2] = BlockConduit.ConnectionTypes.ENERGY_REINFORCED.ordinal();
        ConduitEnergy.modeTypes[SubTypes.LOW.ordinal()][0] = BlockConduit.ConnectionTypes.ENERGY_BASIC_BLOCKED.ordinal();
        ConduitEnergy.modeTypes[SubTypes.LOW.ordinal()][1] = BlockConduit.ConnectionTypes.ENERGY_BASIC.ordinal();
        ConduitEnergy.modeTypes[SubTypes.MID.ordinal()][0] = BlockConduit.ConnectionTypes.ENERGY_HARDENED_BLOCKED.ordinal();
        ConduitEnergy.modeTypes[SubTypes.MID.ordinal()][1] = BlockConduit.ConnectionTypes.ENERGY_HARDENED.ordinal();
        ConduitEnergy.modeTypes[SubTypes.HIGH.ordinal()][0] = BlockConduit.ConnectionTypes.ENERGY_REINFORCED_BLOCKED.ordinal();
        ConduitEnergy.modeTypes[SubTypes.HIGH.ordinal()][1] = BlockConduit.ConnectionTypes.ENERGY_REINFORCED.ordinal();
        _TYPE = new int[]{BlockConduit.ConduitTypes.ENERGY_BASIC.ordinal(), BlockConduit.ConduitTypes.ENERGY_HARDENED.ordinal(), BlockConduit.ConduitTypes.ENERGY_REINFORCED.ordinal()};
        _RENDER_TYPE = new int[]{BlockConduit.RenderTypes.ENERGY_BASIC.ordinal(), BlockConduit.RenderTypes.ENERGY_HARDENED.ordinal(), BlockConduit.RenderTypes.ENERGY_REINFORCED.ordinal()};
        NODE_STORAGE = new int[]{480, 2400, 60000};
        NODE_TRANSFER = new int[]{80, 400, 10000};
    }

    public static enum SubTypes {
        LOW,
        MID,
        HIGH;

    }
}

