/*
 * Decompiled with CFR 0.152.
 */
package iguanaman.iguanatweakstconstruct;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import iguanaman.iguanatweakstconstruct.IguanaLog;
import iguanaman.iguanatweakstconstruct.IguanaTweaksTConstruct;
import iguanaman.iguanatweakstconstruct.RecipeRemover;
import iguanaman.iguanatweakstconstruct.configs.IguanaConfig;
import iguanaman.iguanatweakstconstruct.util.IguanaPartBuildRecipe;
import iguanaman.iguanatweakstconstruct.util.IguanaPartCraftingHandler;
import iguanaman.iguanatweakstconstruct.util.IguanaPatternCraftingHandler;
import iguanaman.iguanatweakstconstruct.util.IguanaToolBuildRecipe;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tconstruct.common.TContent;
import tconstruct.items.Pattern;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.ToolMaterial;

public class VariousTweaks {
    public static void init() {
        try {
            Class<?> clazz = Class.forName(TContent.class.getName());
            Field fld = clazz.getField("supressMissingToolLogs");
            fld.setBoolean(fld, true);
        }
        catch (Exception e) {
            IguanaLog.log("Failed to suppress missing tool logs");
            e.printStackTrace();
        }
        if (IguanaConfig.removeStoneTorchRecipe) {
            IguanaLog.log("Removing stone torch recipe");
            RecipeRemover.removeAnyRecipe(new ItemStack(TContent.stoneTorch, 4));
        }
        if (IguanaConfig.addFlintRecipe) {
            IguanaLog.log("Adding gravel to flint recipe");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Item.field_77804_ap), (Object[])new Object[]{Block.field_71940_F, Block.field_71940_F, Block.field_71940_F, Block.field_71940_F});
        }
        IguanaLog.log("Softening seared blocks");
        TContent.smeltery.func_71848_c(1.5f);
        TContent.lavaTank.func_71848_c(1.5f);
        TContent.searedBlock.func_71848_c(1.5f);
        TContent.castingChannel.func_71848_c(1.5f);
        IguanaLog.log("Making non-metal parts reusable in part builder");
        int[] nonMetals = new int[]{0, 1, 3, 4, 5, 6, 7, 8, 9, 17};
        PatternBuilder pb = PatternBuilder.instance;
        for (int p = 0; p < IguanaTweaksTConstruct.toolParts.size(); ++p) {
            for (int m = 0; m < nonMetals.length; ++m) {
                ToolMaterial mat = TConstructRegistry.getMaterial(m);
                int cost = ((Pattern)TContent.woodPattern).getPatternCost(new ItemStack(TContent.woodPattern, 1, p + 1));
                if ((cost = Math.round((float)cost / 2.0f - 0.5f)) <= 0) continue;
                Item part = IguanaTweaksTConstruct.toolParts.get(p);
                ItemStack partStack = new ItemStack(part, 1, nonMetals[m]);
                pb.registerMaterial(partStack, cost, mat.name());
            }
        }
        IguanaLog.log("Removing restricted parts from Tinker House chest");
        for (int i = 0; i < IguanaTweaksTConstruct.toolParts.size(); ++i) {
            Item part = IguanaTweaksTConstruct.toolParts.get(i);
            if (IguanaConfig.restrictedWoodParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 0));
            }
            if (!IguanaConfig.allowStoneTools || IguanaConfig.restrictedStoneParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 1));
            }
            if (IguanaConfig.restrictedFlintParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 3));
            }
            if (IguanaConfig.restrictedCactusParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 4));
            }
            if (IguanaConfig.restrictedBoneParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 5));
            }
            if (IguanaConfig.restrictedPaperParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 9));
            }
            if (IguanaConfig.restrictedSlimeParts.contains(i + 1)) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 8));
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 17));
            }
            if (IguanaConfig.removeIronParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 2));
            }
            if (IguanaConfig.removeObsidianParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 6));
            }
            if (IguanaConfig.removeCobaltParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 10));
            }
            if (IguanaConfig.removeArditeParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 11));
            }
            if (IguanaConfig.removeManyullumParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 12));
            }
            if (IguanaConfig.removeBronzeParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 14));
            }
            if (IguanaConfig.removeAlumiteParts) {
                TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 15));
            }
            if (!IguanaConfig.removeSteelParts) continue;
            TContent.tinkerHouseChest.removeItem(new ItemStack(part, 1, 16));
        }
        if (IguanaConfig.easyBlankPatternRecipe) {
            IguanaLog.log("Adding easy blank pattern recipe");
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(TContent.blankPattern), new Object[]{true, new Object[]{"ss", "ss", Character.valueOf('s'), "stickWood"}}));
        }
        if (IguanaConfig.easyPatternCrafting) {
            int x;
            IguanaLog.log("Adding rotating pattern crafting recipes");
            GameRegistry.registerCraftingHandler((ICraftingHandler)new IguanaPatternCraftingHandler());
            String[] patternName = new String[]{"ingot", "rod", "pickaxe", "shovel", "axe", "swordblade", "largeguard", "mediumguard", "crossbar", "binding", "frypan", "sign", "knifeblade", "chisel", "largerod", "toughbinding", "largeplate", "broadaxe", "scythe", "excavator", "largeblade", "hammerhead", "fullguard", "bowstring", "fletching", "arrowhead"};
            ArrayList<Integer> patternIds = new ArrayList<Integer>();
            for (x = 1; x < patternName.length; ++x) {
                if (IguanaConfig.restrictedBoneParts.contains(x) && IguanaConfig.restrictedCactusParts.contains(x) && IguanaConfig.restrictedFlintParts.contains(x) && IguanaConfig.restrictedPaperParts.contains(x) && IguanaConfig.restrictedSlimeParts.contains(x) && IguanaConfig.restrictedWoodParts.contains(x) && (!IguanaConfig.allowStoneTools || IguanaConfig.restrictedFlintParts.contains(x)) && x < 23) continue;
                patternIds.add(x);
            }
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(TContent.woodPattern, 1, ((Integer)patternIds.get(0)).intValue()), (Object[])new Object[]{new ItemStack(TContent.blankPattern, 1, 0)});
            for (x = 0; x < patternIds.size(); ++x) {
                int pmeta = (Integer)patternIds.get(x);
                if (x == patternIds.size() - 1) {
                    GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(TContent.woodPattern, 1, ((Integer)patternIds.get(0)).intValue()), (Object[])new Object[]{new ItemStack(TContent.woodPattern, 1, pmeta)});
                    continue;
                }
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(TContent.woodPattern, 1, ((Integer)patternIds.get(x + 1)).intValue()), (Object[])new Object[]{new ItemStack(TContent.woodPattern, 1, pmeta)});
            }
        }
        if (IguanaConfig.easyPartCrafting) {
            IguanaLog.log("Adding easy part crafting");
            GameRegistry.addRecipe((IRecipe)new IguanaPartBuildRecipe());
            GameRegistry.registerCraftingHandler((ICraftingHandler)new IguanaPartCraftingHandler());
        }
        if (IguanaConfig.easyToolCreation || IguanaConfig.easyToolModification) {
            IguanaLog.log("Adding easy tool crafting");
            GameRegistry.addRecipe((IRecipe)new IguanaToolBuildRecipe());
        }
    }
}

