/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.api.value;

import java.util.Arrays;
import java.util.Iterator;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerArrayInts;
import stanhebben.minetweaker.api.value.TweakerByte;
import stanhebben.minetweaker.api.value.TweakerValue;

public class TweakerArrayBytes
extends TweakerArray {
    private byte[] data;
    private int size;

    public TweakerArrayBytes() {
        this.data = new byte[16];
        this.size = 0;
    }

    public TweakerArrayBytes(byte[] data) {
        this.size = data.length;
        if (data.length < 16) {
            data = Arrays.copyOf(data, 16);
        }
        this.data = data;
    }

    @Override
    public int size() {
        return this.size;
    }

    public byte getByte(int index) {
        return this.data[index];
    }

    public void addByte(byte value) {
        if (this.size == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        this.data[this.size++] = value;
    }

    public void addByte(int index, byte value) {
        if (this.size == this.data.length) {
            this.data = Arrays.copyOf(this.data, this.data.length * 2);
        }
        for (int i = this.size; i > index; --i) {
            this.data[i] = this.data[i - 1];
        }
        this.data[index] = value;
        ++this.size;
    }

    public byte removeByte(int index) {
        byte result = this.data[index];
        for (int i = index; i < this.size - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.size;
        return result;
    }

    @Override
    public TweakerValue get(int index) {
        return new TweakerByte(this.data[index]);
    }

    @Override
    public TweakerValue remove(int index) {
        return new TweakerByte(this.removeByte(index));
    }

    @Override
    public TweakerValue addAssign(TweakerValue value) {
        if (value == null) {
            throw new TweakerExecuteException("Cannot convert null to a byte value");
        }
        this.addByte(value.toByte("value cannot be converted to a byte").get());
        return this;
    }

    @Override
    public TweakerValue subAssign(TweakerValue value) {
        if (value == null) {
            throw new TweakerExecuteException("Cannot convert null to a byte value");
        }
        byte bvalue = value.toByte("value cannot be converted to a byte").get();
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != bvalue) continue;
            this.removeByte(i);
            return this;
        }
        return this;
    }

    @Override
    public Iterator<TweakerValue> iterator() {
        return new Iterator<TweakerValue>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < TweakerArrayBytes.this.size;
            }

            @Override
            public TweakerValue next() {
                return new TweakerByte(TweakerArrayBytes.this.data[this.i++]);
            }

            @Override
            public void remove() {
                --this.i;
                TweakerArrayBytes.this.removeByte(this.i);
            }
        };
    }

    @Override
    public TweakerArrayBytes asByteArray() {
        return this;
    }

    @Override
    public TweakerArrayInts asIntArray() {
        int[] data = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            data[i] = this.data[i];
        }
        return new TweakerArrayInts(data);
    }

    @Override
    public TweakerValue index(String index) {
        if (index == null) {
            throw new TweakerExecuteException("Cannot index a byte array with a null value");
        }
        if (index.equals("copy")) {
            return new TweakerArrayBytes(Arrays.copyOf(this.data, this.size));
        }
        return super.index(index);
    }

    @Override
    public cl toTagValue(String name) {
        return new bw(name, this.size < this.data.length ? Arrays.copyOf(this.data, this.size) : this.data);
    }
}

