/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.base.functions;

import java.util.ArrayList;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.TweakerExecuteException;
import stanhebben.minetweaker.api.TweakerNameSpace;
import stanhebben.minetweaker.api.value.TweakerArray;
import stanhebben.minetweaker.api.value.TweakerFunction;
import stanhebben.minetweaker.api.value.TweakerItemStack;
import stanhebben.minetweaker.api.value.TweakerItemStackPattern;
import stanhebben.minetweaker.api.value.TweakerValue;
import stanhebben.minetweaker.base.actions.AddRecipeAction;
import stanhebben.minetweaker.base.functions.recipes.ShapelessAdvancedRecipe;
import stanhebben.minetweaker.base.functions.recipes.ShapelessFunctionRecipes;
import stanhebben.minetweaker.base.functions.recipes.ShapelessOreFunctionRecipe;

public class AddShapelessFunction
extends TweakerFunction {
    public static final AddShapelessFunction INSTANCE = new AddShapelessFunction();

    private AddShapelessFunction() {
    }

    @Override
    public TweakerValue call(TweakerNameSpace namespace, TweakerValue ... arguments) {
        if (arguments.length < 2) {
            throw new TweakerExecuteException("addShapeless requires at least 2 arguments");
        }
        TweakerItemStack target = AddShapelessFunction.notNull(arguments[0], "shapeless recipe output must not be null").toItemStack("shapeless recipe output must be an item stack");
        TweakerArray recipe = AddShapelessFunction.notNull(arguments[1], "shapeless recipe must not be null").toArray("shapeless recipe must be an array of recipe items");
        boolean hasAdvancedItems = false;
        boolean hasOreItems = false;
        for (int i = 0; i < recipe.size(); ++i) {
            TweakerValue item = recipe.get(i);
            if (item == null) continue;
            if (item.asRecipeItem() != null) {
                hasOreItems |= item.asRecipeItem().getClass() == String.class;
                continue;
            }
            if (item.asItemStackPattern() != null) {
                hasAdvancedItems = true;
                continue;
            }
            throw new TweakerExecuteException("shapeless recipe items must be a valid item stack pattern");
        }
        if (hasAdvancedItems) {
            TweakerItemStackPattern[] recipeArray = new TweakerItemStackPattern[recipe.size()];
            for (int i = 0; i < recipe.size(); ++i) {
                TweakerValue value = recipe.get(i);
                recipeArray[i] = value == null ? null : value.asItemStackPattern();
            }
            if (arguments.length >= 3) {
                Tweaker.apply(new AddRecipeAction(new ShapelessAdvancedRecipe(target, recipeArray, arguments[2])));
            } else {
                Tweaker.apply(new AddRecipeAction(new ShapelessAdvancedRecipe(target, recipeArray, null)));
            }
        } else if (hasOreItems) {
            Object[] recipeArray = new Object[recipe.size()];
            for (int i = 0; i < recipeArray.length; ++i) {
                TweakerValue value = recipe.get(i);
                recipeArray[i] = value == null ? null : value.toRecipeItem("error");
            }
            if (arguments.length >= 3) {
                Tweaker.apply(new AddRecipeAction((aah)new ShapelessOreFunctionRecipe(target.get(), recipeArray, arguments[2])));
            } else {
                Tweaker.apply(new AddRecipeAction((aah)new ShapelessOreRecipe(target.get(), recipeArray)));
            }
        } else {
            ArrayList<ye> recipeArray = new ArrayList<ye>();
            for (int i = 0; i < recipe.size(); ++i) {
                TweakerValue value = recipe.get(i);
                recipeArray.add((ye)(value == null ? null : value.toRecipeItem("error")));
            }
            if (arguments.length >= 3) {
                Tweaker.apply(new AddRecipeAction((aah)new ShapelessFunctionRecipes(target.get(), recipeArray, arguments[2])));
            } else {
                Tweaker.apply(new AddRecipeAction((aah)new aaj(target.get(), recipeArray)));
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "MineTweaker:recipes.addShapeless";
    }
}

