/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.minetweaker.mods.forestry.actions;

import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FuelManager;
import java.util.logging.Level;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerLiquid;

public class BronzeEngineRemoveFuelAction
implements IUndoableAction {
    private final TweakerLiquid liquid;
    private EngineBronzeFuel fuel;

    public BronzeEngineRemoveFuelAction(TweakerLiquid liquid) {
        this.liquid = liquid;
    }

    @Override
    public void apply() {
        this.fuel = (EngineBronzeFuel)FuelManager.bronzeEngineFuel.remove(this.liquid.get());
        if (this.fuel == null) {
            Tweaker.log(Level.WARNING, "Biogas engine fuel " + this.liquid.getDisplayName() + " not found");
        }
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        if (this.fuel != null) {
            FuelManager.bronzeEngineFuel.put(this.liquid.get(), this.fuel);
        }
    }

    @Override
    public String describe() {
        return "Removing biogas engine fuel " + this.liquid.getDisplayName();
    }

    @Override
    public String describeUndo() {
        return "Restoring biogas engine fuel " + this.liquid.getDisplayName();
    }
}

