/*
 * Decompiled with CFR 0.152.
 */
package cofh.gui.client;

import cofh.gui.GuiBase;
import cofh.gui.GuiBaseAdv;
import cofh.gui.GuiTextList;
import cofh.gui.container.ContainerFriendsList;
import cofh.gui.element.ElementButton;
import cofh.gui.element.TabInfo;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.social.RegistryFriends;
import cofh.social.SocialPacketHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiPlayerInfo;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiFriendsList
extends GuiBaseAdv {
    static final String TEXTURE_PATH = "cofh:textures/gui/FriendsList.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("cofh:textures/gui/FriendsList.png");
    static final String INFO = "Add/Remove Friends!\n\nFriends not provided.\n\nMom/Dad does not count as a friend.";
    static final int TB_HEIGHT = 12;
    GuiTextField tbName;
    GuiTextList taOnlineList;
    public GuiTextList taFriendsList;
    ElementButton flUp;
    ElementButton flDown;
    ElementButton olUp;
    ElementButton olDown;
    ElementButton addName;
    ElementButton removeName;
    String tempName = "";
    int tbNameX = 0;
    int tbNameY = 0;
    int taX = 0;
    int taY = 0;
    int taflX = 0;
    int taflY = 0;

    public GuiFriendsList(InventoryPlayer inventory) {
        super(new ContainerFriendsList(inventory), TEXTURE);
        this.name = "info.cofh.friendsList";
        this.drawInventory = false;
        this.field_74195_c = 188;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab(new TabInfo((GuiBase)this, INFO));
        this.tbNameX = this.field_74198_m + 8 + 4;
        this.tbNameY = this.field_74197_n + 15 + 2;
        this.taX = this.field_74198_m + 8;
        this.taY = this.field_74197_n + 32;
        this.taflX = this.field_74198_m + 8;
        this.taflY = this.field_74197_n + 80;
        String temp = "";
        if (this.tbName != null) {
            temp = this.tbName.func_73781_b();
        }
        this.tbName = new GuiTextField(this.field_73886_k, this.tbNameX, this.tbNameY, 128, 12);
        this.tbName.func_73804_f(20);
        this.tbName.func_73782_a(temp);
        this.tbName.func_73786_a(false);
        this.taFriendsList = new GuiTextList(this.field_73886_k, this.taflX, this.taflY, 128, 10);
        this.taFriendsList.textLines = RegistryFriends.clientPlayerFriends;
        this.taFriendsList.drawBackground = false;
        this.taFriendsList.drawBorder = false;
        this.taOnlineList = new GuiTextList(this.field_73886_k, this.taX, this.taY, 128, 4);
        this.taOnlineList.textLines = this.getOnlineNames();
        this.taOnlineList.drawBackground = false;
        this.taOnlineList.drawBorder = false;
        this.addName = new ElementButton(this, 139, 13, "SetName", 208, 128, 208, 144, 208, 160, 16, 16, TEXTURE_PATH);
        this.removeName = new ElementButton(this, 155, 13, "RemoveName", 224, 128, 224, 144, 224, 160, 16, 16, TEXTURE_PATH);
        this.olUp = new ElementButton(this, 147, 33, "OnlineUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.olDown = new ElementButton(this, 147, 58, "OnlineDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.flUp = new ElementButton(this, 147, 87, "FriendsUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.flDown = new ElementButton(this, 147, 159, "FriendsDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.addElement(this.addName);
        this.addElement(this.removeName);
        this.addElement(this.olUp);
        this.addElement(this.olDown);
        this.addElement(this.flUp);
        this.addElement(this.flDown);
        this.updateButtons();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equals("SetName")) {
            PacketUtils.sendToServer(Payload.getPayload(SocialPacketHandler.packetID).addByte(SocialPacketHandler.Type.ADD_FRIEND.ordinal()).addString(this.tbName.func_73781_b()).getPacket());
        } else if (buttonName.equals("RemoveName")) {
            PacketUtils.sendToServer(Payload.getPayload(SocialPacketHandler.packetID).addByte(SocialPacketHandler.Type.REMOVE_FRIEND.ordinal()).addString(this.tbName.func_73781_b()).getPacket());
        } else if (buttonName.equals("OnlineUp")) {
            this.taOnlineList.scrollDown();
        } else if (buttonName.equals("OnlineDown")) {
            this.taOnlineList.scrollUp();
        } else if (buttonName.equals("FriendsUp")) {
            this.taFriendsList.scrollDown();
        } else if (buttonName.equals("FriendsDown")) {
            this.taFriendsList.scrollUp();
        }
    }

    @Override
    protected void func_74185_a(float f, int x, int y) {
        super.func_74185_a(f, x, y);
        this.field_73882_e.field_71446_o.func_110577_a(TEXTURE);
        this.tbName.func_73795_f();
        this.taOnlineList.drawText();
        this.taFriendsList.drawText();
    }

    @Override
    protected void func_74189_g(int x, int y) {
        super.func_74189_g(x, y);
    }

    public void func_73874_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_73874_b();
    }

    public void func_73876_c() {
        this.tbName.func_73780_a();
    }

    protected void func_73869_a(char i, int j) {
        this.tbName.func_73802_a(i, j);
        if (j == 1) {
            this.field_73882_e.field_71439_g.func_71053_j();
            return;
        }
        if (this.tbName.func_73806_l() && j == 28) {
            this.field_73882_e.field_71416_A.func_77366_a("random.click", 1.0f, 0.7f);
        }
        this.updateButtons();
    }

    @Override
    protected void func_73864_a(int mX, int mY, int mButton) {
        int textAreaX = this.taFriendsList.xPos - this.field_74198_m;
        int textAreaY = this.taFriendsList.yPos - this.field_74197_n;
        int onlineX = this.taOnlineList.xPos - this.field_74198_m;
        int onlineY = this.taOnlineList.yPos - this.field_74197_n;
        if (onlineX <= this.mouseX && this.mouseX < onlineX + this.taOnlineList.width && this.mouseY >= onlineY && this.mouseY < onlineY + this.taOnlineList.height) {
            if (!this.taOnlineList.mouseClicked(this.mouseX, this.mouseY, mButton, onlineY).equalsIgnoreCase(this.tbName.func_73781_b())) {
                this.tbName.func_73782_a(this.taOnlineList.mouseClicked(this.mouseX, this.mouseY, mButton, onlineY));
            }
        } else if (textAreaX <= this.mouseX && this.mouseX < textAreaX + this.taFriendsList.width && this.mouseY >= textAreaY && this.mouseY < textAreaY + this.taFriendsList.height) {
            if (!this.taFriendsList.mouseClicked(this.mouseX, this.mouseY, mButton, textAreaY).equalsIgnoreCase(this.tbName.func_73781_b())) {
                this.tbName.func_73782_a(this.taFriendsList.mouseClicked(this.mouseX, this.mouseY, mButton, textAreaY));
            }
        } else if (this.tbNameX - this.field_74198_m <= this.mouseX && this.mouseX < this.tbNameX - this.field_74198_m + this.tbName.func_73801_o() && this.mouseY >= this.tbNameY - this.field_74197_n && this.mouseY < this.tbNameY - this.field_74197_n + 12) {
            this.tbName.func_73796_b(true);
        } else {
            super.func_73864_a(mX, mY, mButton);
        }
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.canScrollUpFriend()) {
            this.flUp.setActive();
        } else {
            this.flUp.setDisabled();
        }
        if (this.canScrollDownFriend()) {
            this.flDown.setActive();
        } else {
            this.flDown.setDisabled();
        }
        if (this.canScrollUpOnline()) {
            this.olUp.setActive();
        } else {
            this.olUp.setDisabled();
        }
        if (this.canScrollDownOnline()) {
            this.olDown.setActive();
        } else {
            this.olDown.setDisabled();
        }
        if (RegistryFriends.clientPlayerFriends.contains(this.tbName.func_73781_b().toLowerCase())) {
            this.addName.setDisabled();
            this.removeName.setActive();
        } else {
            this.addName.setActive();
            this.removeName.setDisabled();
        }
    }

    @Override
    public void func_73867_d() {
        super.func_73867_d();
        int textAreaX = this.taFriendsList.xPos - this.field_74198_m;
        int textAreaY = this.taFriendsList.yPos - this.field_74197_n;
        int onlineX = this.taOnlineList.xPos - this.field_74198_m;
        int onlineY = this.taOnlineList.yPos - this.field_74197_n;
        if (textAreaX <= this.mouseX && this.mouseX < textAreaX + this.taFriendsList.width && this.mouseY >= textAreaY && this.mouseY < textAreaY + this.taFriendsList.height) {
            int wheelDir = Mouse.getEventDWheel();
            if (wheelDir < 0) {
                this.taFriendsList.scrollUp();
            }
            if (wheelDir > 0) {
                this.taFriendsList.scrollDown();
            }
        } else if (onlineX <= this.mouseX && this.mouseX < onlineX + this.taOnlineList.width && this.mouseY >= onlineY && this.mouseY < onlineY + this.taOnlineList.height) {
            int wheelDir = Mouse.getEventDWheel();
            if (wheelDir < 0) {
                this.taOnlineList.scrollUp();
            }
            if (wheelDir > 0) {
                this.taOnlineList.scrollDown();
            }
        }
        this.updateButtons();
    }

    private boolean canScrollUpOnline() {
        return this.taOnlineList.startLine != 0;
    }

    private boolean canScrollDownOnline() {
        return this.taOnlineList.textLines.size() > this.taOnlineList.displayLines && this.taOnlineList.startLine < this.taOnlineList.textLines.size() - this.taOnlineList.displayLines;
    }

    private boolean canScrollUpFriend() {
        return this.taFriendsList.startLine != 0;
    }

    private boolean canScrollDownFriend() {
        return this.taFriendsList.textLines.size() > this.taFriendsList.displayLines && this.taFriendsList.startLine < this.taFriendsList.textLines.size() - this.taFriendsList.displayLines;
    }

    public List<String> getOnlineNames() {
        LinkedList<String> online = new LinkedList<String>();
        for (Object curObj : Minecraft.func_71410_x().field_71439_g.field_71174_a.field_72559_c) {
            online.add(((GuiPlayerInfo)curObj).field_78831_a);
        }
        return online;
    }
}

