/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IFacingLogic;
import tconstruct.library.util.IMasterLogic;
import tsteelworks.TSteelworks;
import tsteelworks.blocks.logic.TurbineLogic;
import tsteelworks.client.block.MachineRender;
import tsteelworks.lib.TSteelworksRegistry;
import tsteelworks.lib.blocks.TSInventoryBlock;

public class MachineBlock
extends TSInventoryBlock {
    static ArrayList<CoordTuple> directions = new ArrayList(6);

    public MachineBlock(int id) {
        super(id, Material.field_76243_f);
        this.func_71848_c(3.0f);
        this.func_71894_b(20.0f);
        this.func_71849_a((CreativeTabs)TSteelworksRegistry.SteelworksCreativeTab);
        this.func_71864_b("tsteelworks.Machine");
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return null;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        return new TurbineLogic();
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        if (heldItem != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)player.func_71045_bC());
            if (liquid == null) {
                return false;
            }
            if (!liquid.getFluid().equals(FluidRegistry.getFluid((String)"steam"))) {
                return false;
            }
            TurbineLogic logic = (TurbineLogic)world.func_72796_p(x, y, z);
            if (liquid != null) {
                int amount = logic.fill(ForgeDirection.UNKNOWN, liquid, false);
                if (amount == liquid.amount) {
                    logic.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, MachineBlock.consumeItem(heldItem));
                    }
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().func_77634_r()) {
                return stack.func_77973_b().getContainerItemStack(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return null;
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"turbine_front", "turbine_side", "turbine_back"};
        return textureNames;
    }

    @Override
    public void func_94332_a(IconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new Icon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("tsteelworks:" + textureNames[i]);
        }
    }

    public Icon func_71858_a(int side, int meta) {
        if (meta == 0) {
            return this.icons[this.getTextureIndex(side)];
        }
        return this.icons[0];
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        if (meta == 0) {
            if (side == direction) {
                return this.icons[0];
            }
            if (side / 2 == direction / 2) {
                return this.icons[2];
            }
            return this.icons[1];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        return this.getTextureIndex(side, false);
    }

    public int getTextureIndex(int side, boolean alt) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return alt ? 9 : 1;
    }

    public int func_71857_b() {
        return MachineRender.model;
    }

    public void func_71862_a(World world, int x, int y, int z, Random random) {
        if (MachineBlock.isActive((IBlockAccess)world, x, y, z)) {
            TileEntity logic = world.func_72796_p(x, y, z);
            byte face = 0;
            if (logic instanceof IFacingLogic) {
                face = ((IFacingLogic)logic).getRenderDirection();
            }
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.5f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.35f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            switch (face) {
                case 4: {
                    world.func_72869_a("explode", (double)(f - 0.35f), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 5: {
                    world.func_72869_a("explode", (double)(f + 0.35f), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                    break;
                }
                case 2: {
                    world.func_72869_a("explode", (double)(f + f4), (double)f1, (double)(f2 - 0.35f), 0.0, 0.0, 0.0);
                    break;
                }
                case 3: {
                    world.func_72869_a("explode", (double)(f + f4), (double)f1, (double)(f2 + 0.35f), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_72796_p(x, y, z);
        return logic instanceof IMasterLogic;
    }

    boolean activeRedstone(World world, int x, int y, int z) {
        Block wire = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (wire != null && wire.field_71990_ca == Block.field_72075_av.field_71990_ca) {
            return world.func_72805_g(x, y, z) > 0;
        }
        return false;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack(id, 1, 0));
    }

    public void func_71863_a(World world, int x, int y, int z, int nBlockID) {
        TileEntity logic = world.func_72796_p(x, y, z);
        if (logic instanceof TurbineLogic) {
            ((TurbineLogic)logic).setActive(world.func_72864_z(x, y, z));
        }
    }

    @Override
    public int func_71899_b(int meta) {
        return meta;
    }

    public int func_71925_a(Random random) {
        return 1;
    }

    @Override
    public Object getModInstance() {
        return TSteelworks.instance;
    }

    static {
        directions.add(new CoordTuple(0, -1, 0));
        directions.add(new CoordTuple(0, 1, 0));
        directions.add(new CoordTuple(0, 0, -1));
        directions.add(new CoordTuple(0, 0, 1));
        directions.add(new CoordTuple(-1, 0, 0));
        directions.add(new CoordTuple(1, 0, 0));
    }
}

