/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

public class SteamFluidBlock
extends BlockFluidClassic {
    public Icon stillIcon;
    public Icon flowIcon;
    boolean alpha = true;
    protected int quantaPerBlock = 1;

    public SteamFluidBlock(int id, Fluid fluid, Material material) {
        super(id, fluid, material);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.stillIcon = iconRegister.func_94245_a("tsteelworks:liquid_steam");
        this.flowIcon = iconRegister.func_94245_a("tsteelworks:liquid_steam_flow");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.stillIcon;
        }
        return this.flowIcon;
    }

    public void func_71847_b(World world, int x, int y, int z, Random rand) {
        int quantaRemaining = this.quantaPerBlock - world.func_72805_g(x, y, z);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (world.func_72798_a(x, y2, z) == this.field_71990_ca || world.func_72798_a(x - 1, y2, z) == this.field_71990_ca || world.func_72798_a(x + 1, y2, z) == this.field_71990_ca || world.func_72798_a(x, y2, z - 1) == this.field_71990_ca || world.func_72798_a(x, y2, z + 1) == this.field_71990_ca) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_94571_i(x, y, z);
                } else {
                    world.func_72921_c(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.func_72836_a(x, y, z, this.field_71990_ca, this.tickRate);
                    world.func_72898_h(x, y, z, this.field_71990_ca);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (this.canDisplace((IBlockAccess)world, x, y - this.densityDir, z)) {
            this.flowIntoBlock(world, x, y - this.densityDir, z, 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, x, y, z) || !this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
            boolean[] flowTo;
            if (world.func_72798_a(x, y - this.densityDir, z) == this.field_71990_ca) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    public boolean isFlowingVertically(IBlockAccess world, int x, int y, int z) {
        return world.func_72798_a(x, y - this.densityDir, z) == this.field_71990_ca || world.func_72798_a(x, y, z) == this.field_71990_ca && this.canFlowInto(world, x, y - this.densityDir, z);
    }

    public Vec3 getFlowVector(IBlockAccess world, int x, int y, int z) {
        Vec3 vec = world.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y, z);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y, z2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.func_72803_f(x2, y, z2).func_76230_c() || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y - 1, z2)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.func_72441_c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.func_72441_c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
        }
        if (world.func_72798_a(x, y + 1, z) == this.field_71990_ca) {
            boolean flag;
            boolean bl = flag = this.func_71924_d(world, x, y, z - 1, 2) || this.func_71924_d(world, x, y, z + 1, 3) || this.func_71924_d(world, x - 1, y, z, 4) || this.func_71924_d(world, x + 1, y, z, 5) || this.func_71924_d(world, x, y - 1, z - 1, 2) || this.func_71924_d(world, x, y - 1, z + 1, 3) || this.func_71924_d(world, x - 1, y - 1, z, 4) || this.func_71924_d(world, x + 1, y - 1, z, 5);
            if (flag) {
                vec = vec.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.func_72432_b();
        return vec;
    }
}

