/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.blocks.logic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.common.TContent;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IFacingLogic;
import tconstruct.library.util.IMasterLogic;
import tconstruct.library.util.IServantLogic;
import tsteelworks.blocks.logic.HighOvenDuctLogic;
import tsteelworks.blocks.logic.TSMultiServantLogic;
import tsteelworks.common.TSContent;
import tsteelworks.inventory.DeepTankContainer;
import tsteelworks.lib.ConfigCore;
import tsteelworks.lib.crafting.AlloyInfo;

public class DeepTankLogic
extends TileEntity
implements IFacingLogic,
IFluidTank,
IMasterLogic {
    public ArrayList<FluidStack> fluidlist = new ArrayList();
    boolean structureHasBottom;
    boolean structureHasTop;
    boolean needsUpdate;
    boolean containsAlloy = false;
    boolean activeTurbineAttached = false;
    public boolean validStructure;
    byte direction;
    public CoordTuple centerPos;
    int tick;
    int maxLiquid;
    int currentLiquid;
    int numBricks;
    public int innerMaxX = 0;
    public int innerMaxZ = 0;
    public int layers;
    public final int innerMaxSpace = 9;
    Random rand = new Random();
    ArrayList glassBlocks = this.getRegisteredGlassIDs();

    public int xDistanceToRim() {
        return this.innerMaxX / 2 + 1;
    }

    public int zDistanceToRim() {
        return this.innerMaxZ / 2 + 1;
    }

    public int innerSpaceTotal() {
        return this.innerMaxX * this.innerMaxZ;
    }

    public int layerFluidCapacity() {
        int multiplicator = ConfigCore.deeptankCapacityMultiplier;
        return 1000 * multiplicator * this.innerSpaceTotal();
    }

    void adjustLayers(int lay, boolean forceAdjust) {
        if (lay != this.layers || forceAdjust) {
            this.needsUpdate = true;
            this.layers = lay;
            this.maxLiquid = this.layerFluidCapacity() * lay;
        }
    }

    public Container getGuiContainer(InventoryPlayer inventoryplayer, World world, int x, int y, int z) {
        return new DeepTankContainer(inventoryplayer, this);
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this) {
            return false;
        }
        return entityplayer.func_70011_f((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public String getDefaultName() {
        return "tank.DeepTank";
    }

    public boolean isStructureValid() {
        return this.validStructure;
    }

    public byte getRenderDirection() {
        return this.direction;
    }

    public ForgeDirection getForgeDirection() {
        return ForgeDirection.VALID_DIRECTIONS[this.direction];
    }

    public void setDirection(int side) {
    }

    public void setDirection(float yaw, float pitch, EntityLivingBase player) {
        int facing = MathHelper.func_76128_c((double)((double)(yaw / 360.0f) + 0.5)) & 3;
        switch (facing) {
            case 0: {
                this.direction = (byte)2;
                break;
            }
            case 1: {
                this.direction = (byte)5;
                break;
            }
            case 2: {
                this.direction = (byte)3;
                break;
            }
            case 3: {
                this.direction = (byte)4;
            }
        }
    }

    public void func_70316_g() {
        ++this.tick;
        if (this.tick % 20 == 0) {
            if (!this.validStructure) {
                this.checkValidPlacement();
            }
            if (this.needsUpdate) {
                this.needsUpdate = false;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
        if (this.tick == 40 && this.activeTurbineAttached) {
            this.dealloyFluids();
        }
        if (this.tick == 60) {
            this.tick = 0;
        }
    }

    public void func_70296_d() {
        this.func_70316_g();
        super.func_70296_d();
        this.needsUpdate = true;
    }

    public void notifyChange(IServantLogic servant, int x, int y, int z) {
        this.checkValidPlacement();
    }

    public void checkValidPlacement() {
        int[] center = this.scanGlassLayerCenter();
        this.alignControllerLayer(center[0], this.field_70330_m, center[1]);
    }

    void alignControllerLayer(int x, int y, int z) {
        int xPos;
        if (x == this.field_70329_l && z == this.field_70327_n) {
            return;
        }
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        int brickCounter = 0;
        int glassCounter = 0;
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            for (int zPos = z - innerCenterZ; zPos <= z + innerCenterZ; ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || !this.validGlassID(block.field_71990_ca)) continue;
                glassCounter += this.checkBricks(xPos, y, zPos, true);
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            brickCounter += this.checkBricks(xPos, y, z - innerCenterZ, false);
            brickCounter += this.checkBricks(xPos, y, z + innerCenterZ, false);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            brickCounter += this.checkBricks(x - innerCenterX, y, zPos, false);
            brickCounter += this.checkBricks(x + innerCenterX, y, zPos, false);
        }
        if (!this.validateRimmedLayer(glassCounter, brickCounter)) {
            return;
        }
        this.checkValidStructure(x, y, z, glassCounter + brickCounter);
    }

    public void checkValidStructure(int x, int y, int z, int compareBricks) {
        boolean oldStructureHasBottom = this.structureHasBottom;
        boolean oldStructureHasTop = this.structureHasTop;
        this.structureHasBottom = false;
        this.structureHasTop = false;
        int checkedLayers = 0;
        if (this.checkSameLevel(x, y, z, compareBricks)) {
            ++checkedLayers;
            int checkUp = this.recurseStructureUp(x, y + 1, z, 0, compareBricks);
            int checkDown = this.recurseStructureDown(x, y - 1, z, 0, compareBricks);
            checkedLayers += checkUp;
            checkedLayers += checkDown;
            if (checkUp > 0 && !this.structureHasBottom) {
                this.validateBottom(x, y, z, 0, compareBricks);
            }
            if (checkDown > 0 && !this.structureHasTop) {
                this.validateTop(x, y, z, 0, compareBricks);
            }
        }
        if (oldStructureHasBottom != this.structureHasBottom || oldStructureHasTop != this.structureHasTop || this.layers != checkedLayers) {
            if (this.structureHasBottom && this.structureHasTop && checkedLayers > 0) {
                this.adjustLayers(checkedLayers, false);
                this.validStructure = true;
            } else {
                this.validStructure = false;
            }
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public boolean checkSameLevel2(int x, int y, int z, int compareBricks) {
        return this.checkStructureGlobal(x, y, z, compareBricks, -1, 0, 0, 0) == 0;
    }

    public int recurseStructureUp2(int x, int y, int z, int count, int compareBricks) {
        return this.checkStructureGlobal(x, y, z, compareBricks, count, -1, 1, -1);
    }

    public int recurseStructureDown2(int x, int y, int z, int count, int compareBricks) {
        return this.checkStructureGlobal(x, y, z, compareBricks, count, -1, -1, -1);
    }

    public int checkStructureGlobal(int x, int y, int z, int compareBricks, int count, int modX, int modY, int modZ) {
        int xPos;
        this.numBricks = 0;
        Block block = null;
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        boolean isMiddleLayer = count > -1;
        for (xPos = x - (innerCenterX + modX); xPos <= x + (innerCenterX + modX); ++xPos) {
            for (int zPos = z - (innerCenterZ + modZ); zPos <= z + (innerCenterZ + modZ); ++zPos) {
                block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || !this.validGlassID(block.field_71990_ca)) continue;
                if (!isMiddleLayer) {
                    this.numBricks += this.checkBricks(xPos, y, zPos, true);
                    continue;
                }
                if (block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                return this.validGlassID(block.field_71990_ca) ? this.validateTop(x, y, z, count, compareBricks) : count;
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - innerCenterZ, isMiddleLayer);
            this.numBricks += this.checkBricks(xPos, y, z + innerCenterZ, isMiddleLayer);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            this.numBricks += this.checkBricks(x - innerCenterX, y, zPos, isMiddleLayer);
            this.numBricks += this.checkBricks(x + innerCenterX, y, zPos, isMiddleLayer);
        }
        if (!isMiddleLayer) {
            return this.numBricks == compareBricks ? 0 : 1;
        }
        if (this.numBricks != compareBricks - this.innerSpaceTotal()) {
            return count;
        }
        return this.checkStructureGlobal(x, y + modY, z, compareBricks, ++count, modX, modY, modZ);
    }

    public boolean checkSameLevel(int x, int y, int z, int compareBricks) {
        int xPos;
        this.numBricks = 0;
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            for (int zPos = z - innerCenterZ; zPos <= z + innerCenterZ; ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || !this.validGlassID(block.field_71990_ca)) continue;
                this.numBricks += this.checkBricks(xPos, y, zPos, true);
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - innerCenterZ, false);
            this.numBricks += this.checkBricks(xPos, y, z + innerCenterZ, false);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            this.numBricks += this.checkBricks(x - innerCenterX, y, zPos, false);
            this.numBricks += this.checkBricks(x + innerCenterX, y, zPos, false);
        }
        return this.numBricks == compareBricks;
    }

    public int recurseStructureUp(int x, int y, int z, int count, int compareBricks) {
        int xPos;
        this.numBricks = 0;
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        for (xPos = x - (innerCenterX - 1); xPos <= x + (innerCenterX - 1); ++xPos) {
            for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || !this.validGlassID(block.field_71990_ca) || block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                return this.validGlassID(block.field_71990_ca) ? this.validateTop(x, y, z, count, compareBricks) : count;
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - innerCenterZ, true);
            this.numBricks += this.checkBricks(xPos, y, z + innerCenterZ, true);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            this.numBricks += this.checkBricks(x - innerCenterX, y, zPos, true);
            this.numBricks += this.checkBricks(x + innerCenterX, y, zPos, true);
        }
        if (this.numBricks != compareBricks - this.innerSpaceTotal()) {
            return count;
        }
        return this.recurseStructureUp(x, y + 1, z, ++count, compareBricks);
    }

    public int recurseStructureDown(int x, int y, int z, int count, int compareBricks) {
        int xPos;
        this.numBricks = 0;
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        for (xPos = x - (innerCenterX - 1); xPos <= x + (innerCenterX - 1); ++xPos) {
            for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
                Block block = Block.field_71973_m[this.field_70331_k.func_72798_a(xPos, y, zPos)];
                if (block == null || !this.validGlassID(block.field_71990_ca) || block == null || block.isAirBlock(this.field_70331_k, xPos, y, zPos)) continue;
                return this.validGlassID(block.field_71990_ca) ? this.validateBottom(x, y, z, count, compareBricks) : count;
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            this.numBricks += this.checkBricks(xPos, y, z - innerCenterZ, true);
            this.numBricks += this.checkBricks(xPos, y, z + innerCenterZ, true);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            this.numBricks += this.checkBricks(x - innerCenterX, y, zPos, true);
            this.numBricks += this.checkBricks(x + innerCenterX, y, zPos, true);
        }
        if (this.numBricks != compareBricks - this.innerSpaceTotal()) {
            return count;
        }
        return this.recurseStructureDown(x, y - 1, z, ++count, compareBricks);
    }

    public int validateTop(int x, int y, int z, int count, int compareBricks) {
        int xPos;
        int topBricks = 0;
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            for (int zPos = z - innerCenterZ; zPos <= z + innerCenterZ; ++zPos) {
                if (!this.validGlassID(this.field_70331_k.func_72798_a(xPos, y, zPos))) continue;
                topBricks += this.checkBricks(xPos, y, zPos, true);
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            topBricks += this.checkBricks(xPos, y, z - innerCenterZ, false);
            topBricks += this.checkBricks(xPos, y, z + innerCenterZ, false);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            topBricks += this.checkBricks(x - innerCenterX, y, zPos, false);
            topBricks += this.checkBricks(x + innerCenterX, y, zPos, false);
        }
        this.structureHasTop = topBricks == compareBricks;
        return count;
    }

    public int validateBottom(int x, int y, int z, int count, int compareBricks) {
        int xPos;
        int bottomBricks = 0;
        int innerCenterX = this.xDistanceToRim();
        int innerCenterZ = this.zDistanceToRim();
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            for (int zPos = z - innerCenterZ; zPos <= z + innerCenterZ; ++zPos) {
                if (!this.validGlassID(this.field_70331_k.func_72798_a(xPos, y, zPos))) continue;
                bottomBricks += this.checkBricks(xPos, y, zPos, true);
            }
        }
        for (xPos = x - innerCenterX; xPos <= x + innerCenterX; ++xPos) {
            bottomBricks += this.checkBricks(xPos, y, z - innerCenterZ, false);
            bottomBricks += this.checkBricks(xPos, y, z + innerCenterZ, false);
        }
        for (int zPos = z - (innerCenterZ - 1); zPos <= z + (innerCenterZ - 1); ++zPos) {
            bottomBricks += this.checkBricks(x - innerCenterX, y, zPos, false);
            bottomBricks += this.checkBricks(x + innerCenterX, y, zPos, false);
        }
        boolean bl = this.structureHasBottom = bottomBricks == compareBricks;
        if (this.structureHasBottom) {
            this.centerPos = new CoordTuple(x, y + 1, z);
        }
        return count;
    }

    int checkBricks(int x, int y, int z, boolean glassOnly) {
        TSMultiServantLogic servant;
        TileEntity te;
        int tempBricks = 0;
        int blockID = this.field_70331_k.func_72798_a(x, y, z);
        if (glassOnly && this.validGlassID(blockID)) {
            ++tempBricks;
        }
        if (glassOnly && this.validBlockID(blockID)) {
            te = this.field_70331_k.func_72796_p(x, y, z);
            if (te instanceof HighOvenDuctLogic) {
                return tempBricks++;
            }
            if (te instanceof TSMultiServantLogic) {
                servant = (TSMultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (servant.verifyMaster(this, this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                        ++tempBricks;
                    }
                } else if (servant.setMaster(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                    ++tempBricks;
                }
            }
        }
        if (!glassOnly && this.validBlockID(blockID)) {
            te = this.field_70331_k.func_72796_p(x, y, z);
            if (te == this) {
                ++tempBricks;
            }
            if (te instanceof HighOvenDuctLogic) {
                return tempBricks++;
            }
            if (te instanceof TSMultiServantLogic) {
                servant = (TSMultiServantLogic)te;
                if (servant.hasValidMaster()) {
                    if (servant.verifyMaster(this, this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                        ++tempBricks;
                    }
                } else if (servant.setMaster(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                    ++tempBricks;
                }
            }
        }
        return tempBricks;
    }

    int verifyComponent(TileEntity tileentity) {
        int tempBricks = 0;
        if (tileentity instanceof HighOvenDuctLogic) {
            return tempBricks++;
        }
        if (tileentity instanceof TSMultiServantLogic) {
            TSMultiServantLogic servant = (TSMultiServantLogic)tileentity;
            if (servant.hasValidMaster()) {
                if (servant.verifyMaster(this, this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                    ++tempBricks;
                }
            } else if (servant.setMaster(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                ++tempBricks;
            }
        }
        return tempBricks;
    }

    private int[] scanGlassLayerCenter() {
        int centerX = 0;
        int centerZ = 0;
        switch (this.getRenderDirection()) {
            case 2: {
                int x;
                Block block;
                for (int z = this.field_70327_n + 1; z < this.field_70327_n + 10 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, z)]) != null && this.validGlassID(block.field_71990_ca); ++z) {
                    centerZ += this.checkBricks(this.field_70329_l, this.field_70330_m, z, true);
                }
                if (centerZ != 1 && centerZ % 2 == 0) break;
                this.innerMaxZ = centerZ;
                if ((centerZ = centerZ / 2 + 1) == 0) break;
                for (x = this.field_70329_l; x >= this.field_70329_l - 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, this.field_70330_m, this.field_70327_n + centerZ)]) != null && this.validGlassID(block.field_71990_ca); --x) {
                    centerX += this.checkBricks(x, this.field_70330_m, this.field_70327_n + centerZ, true);
                }
                for (x = this.field_70329_l + 1; x <= this.field_70329_l + 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, this.field_70330_m, this.field_70327_n + centerZ)]) != null && this.validGlassID(block.field_71990_ca); ++x) {
                    centerX += this.checkBricks(x, this.field_70330_m, this.field_70327_n + centerZ, true);
                }
                if (centerX != 1 && centerX % 2 == 0) break;
                this.innerMaxX = centerX;
                if ((centerX = centerX / 2 + 1) == 0) break;
                return new int[]{this.field_70329_l, this.field_70327_n + centerZ};
            }
            case 3: {
                int x;
                Block block;
                for (int z = this.field_70327_n - 1; z > this.field_70327_n - 10 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, z)]) != null && this.validGlassID(block.field_71990_ca); --z) {
                    centerZ += this.checkBricks(this.field_70329_l, this.field_70330_m, z, true);
                }
                if (centerZ != 1 && centerZ % 2 == 0) break;
                this.innerMaxZ = centerZ;
                if ((centerZ = centerZ / 2 + 1) == 0) break;
                for (x = this.field_70329_l; x >= this.field_70329_l - 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, this.field_70330_m, this.field_70327_n - centerZ)]) != null && this.validGlassID(block.field_71990_ca); --x) {
                    centerX += this.checkBricks(x, this.field_70330_m, this.field_70327_n - centerZ, true);
                }
                for (x = this.field_70329_l + 1; x <= this.field_70329_l + 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, this.field_70330_m, this.field_70327_n - centerZ)]) != null && this.validGlassID(block.field_71990_ca); ++x) {
                    centerX += this.checkBricks(x, this.field_70330_m, this.field_70327_n - centerZ, true);
                }
                if (centerX != 1 && centerX % 2 == 0) break;
                this.innerMaxX = centerX;
                if ((centerX = centerX / 2 + 1) == 0) break;
                return new int[]{this.field_70329_l, this.field_70327_n - centerZ};
            }
            case 4: {
                int z;
                Block block;
                for (int x = this.field_70329_l + 1; x < this.field_70329_l + 10 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, this.field_70330_m, this.field_70327_n)]) != null && this.validGlassID(block.field_71990_ca); ++x) {
                    centerX += this.checkBricks(x, this.field_70330_m, this.field_70327_n, true);
                }
                if (centerX != 1 && centerX % 2 == 0) break;
                this.innerMaxX = centerX;
                if ((centerX = centerX / 2 + 1) == 0) break;
                for (z = this.field_70327_n; z >= this.field_70327_n - 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l + centerX, this.field_70330_m, z)]) != null && this.validGlassID(block.field_71990_ca); --z) {
                    centerZ += this.checkBricks(this.field_70329_l + centerX, this.field_70330_m, z, true);
                }
                for (z = this.field_70327_n + 1; z <= this.field_70327_n + 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l + centerX, this.field_70330_m, z)]) != null && this.validGlassID(block.field_71990_ca); ++z) {
                    centerZ += this.checkBricks(this.field_70329_l + centerX, this.field_70330_m, z, true);
                }
                if (centerZ != 1 && centerZ % 2 == 0) break;
                this.innerMaxZ = centerZ;
                if ((centerZ = centerZ / 2 + 1) == 0) break;
                return new int[]{this.field_70329_l + centerX, this.field_70327_n};
            }
            case 5: {
                int z;
                Block block;
                for (int x = this.field_70329_l - 1; x > this.field_70329_l - 10 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(x, this.field_70330_m, this.field_70327_n)]) != null && this.validGlassID(block.field_71990_ca); --x) {
                    centerX += this.checkBricks(x, this.field_70330_m, this.field_70327_n, true);
                }
                if (centerX != 1 && centerX % 2 == 0) break;
                this.innerMaxX = centerX;
                if ((centerX = centerX / 2 + 1) == 0) break;
                for (z = this.field_70327_n; z >= this.field_70327_n - 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l - centerX, this.field_70330_m, z)]) != null && this.validGlassID(block.field_71990_ca); --z) {
                    centerZ += this.checkBricks(this.field_70329_l - centerX, this.field_70330_m, z, true);
                }
                for (z = this.field_70327_n + 1; z <= this.field_70327_n + 4 && (block = Block.field_71973_m[this.field_70331_k.func_72798_a(this.field_70329_l - centerX, this.field_70330_m, z)]) != null && this.validGlassID(block.field_71990_ca); ++z) {
                    centerZ += this.checkBricks(this.field_70329_l - centerX, this.field_70330_m, z, true);
                }
                if (centerZ != 1 && centerZ % 2 == 0) break;
                this.innerMaxZ = centerZ;
                if ((centerZ = centerZ / 2 + 1) == 0) break;
                return new int[]{this.field_70329_l - centerX, this.field_70327_n};
            }
        }
        return new int[]{this.field_70329_l, this.field_70330_m};
    }

    public boolean validateRimmedLayer(int innerbricks, int outerbricks) {
        int total = innerbricks + outerbricks;
        if (this.innerMaxX == 1 || this.innerMaxZ == 1) {
            return Arrays.asList(9, 15, 21, 27, 33).contains(total);
        }
        if (this.innerMaxX == 3 || this.innerMaxZ == 3) {
            return Arrays.asList(25, 35, 45, 55).contains(total);
        }
        if (this.innerMaxX == 5 || this.innerMaxZ == 5) {
            return Arrays.asList(49, 63, 77).contains(total);
        }
        if (this.innerMaxX == 7 || this.innerMaxZ == 7) {
            return Arrays.asList(81, 99).contains(total);
        }
        if (this.innerMaxX == 9 || this.innerMaxZ == 9) {
            return total == 121;
        }
        return false;
    }

    boolean validBlockID(int blockID) {
        return blockID == TSContent.highoven.field_71990_ca;
    }

    boolean validGlassID(int blockID) {
        return this.glassBlocks.contains(blockID);
    }

    ArrayList getRegisteredGlassIDs() {
        ArrayList oreDict = OreDictionary.getOres((String)"glass");
        ArrayList<Object> glasses = new ArrayList<Object>();
        glasses.add(Block.field_71973_m[Block.field_71946_M.field_71990_ca]);
        glasses.add(Block.field_71973_m[TContent.clearGlass.field_71990_ca]);
        glasses.add(Block.field_71973_m[TContent.stainedGlassClear.field_71990_ca]);
        glasses.add(Block.field_71973_m[TContent.lavaTank.field_71990_ca]);
        if (ConfigCore.modTankGlassBlocks.length >= 1) {
            for (int id : ConfigCore.modTankGlassBlocks) {
                glasses.add(Block.field_71973_m[id]);
            }
        }
        if (!oreDict.isEmpty()) {
            for (ItemStack glass : oreDict) {
                glasses.add(Block.field_71973_m[glass.field_77993_c].field_71990_ca);
            }
            HashSet<Object> temp = new HashSet<Object>();
            temp.addAll(glasses);
            glasses.clear();
            glasses.addAll(temp);
            return glasses;
        }
        return oreDict;
    }

    public int getCapacity() {
        return this.maxLiquid;
    }

    public int getTotalLiquid() {
        return this.currentLiquid;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (!this.isStructureValid()) {
            return null;
        }
        if (this.fluidlist.size() == 0) {
            return null;
        }
        FluidStack liquid = this.fluidlist.get(0);
        if (liquid != null) {
            if (liquid.amount - maxDrain <= 0) {
                FluidStack liq = liquid.copy();
                if (doDrain) {
                    this.fluidlist.remove(liquid);
                    this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                    this.currentLiquid = 0;
                    this.needsUpdate = true;
                }
                this.containsAlloy = this.containsAlloy();
                return liq;
            }
            if (doDrain && maxDrain > 0) {
                liquid.amount -= maxDrain;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                this.currentLiquid -= maxDrain;
                this.needsUpdate = true;
            }
            this.containsAlloy = this.containsAlloy();
            return new FluidStack(liquid.fluidID, maxDrain, liquid.tag);
        }
        this.containsAlloy = this.containsAlloy();
        return new FluidStack(0, 0);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (!this.isStructureValid()) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        this.addFluidToTank(copy, false);
        return resource.amount - copy.amount;
    }

    boolean addFluidToTank(FluidStack liquid, boolean first) {
        if (!this.isStructureValid()) {
            return false;
        }
        this.needsUpdate = true;
        if (this.fluidlist.size() == 0) {
            this.fluidlist.add(liquid.copy());
            this.currentLiquid += liquid.amount;
            this.containsAlloy = this.containsAlloy();
            return true;
        }
        if (liquid.amount + this.currentLiquid > this.maxLiquid) {
            return false;
        }
        this.currentLiquid += liquid.amount;
        boolean added = false;
        for (int i = 0; i < this.fluidlist.size(); ++i) {
            FluidStack l = this.fluidlist.get(i);
            if (l.isFluidEqual(liquid)) {
                l.amount += liquid.amount;
                added = true;
            }
            if (l.amount > 0) continue;
            this.fluidlist.remove(l);
            --i;
        }
        if (!added) {
            if (first) {
                this.fluidlist.add(0, liquid.copy());
            } else {
                this.fluidlist.add(liquid.copy());
            }
        }
        this.containsAlloy = this.containsAlloy();
        return true;
    }

    public FluidStack getFluid() {
        if (!this.isStructureValid()) {
            return null;
        }
        if (this.fluidlist.size() == 0) {
            return null;
        }
        return this.fluidlist.get(0);
    }

    public List<FluidStack> getAllFluids() {
        return this.fluidlist;
    }

    public int getTotalFluidAmount() {
        if (this.fluidlist.size() == 0) {
            return this.currentLiquid;
        }
        int amt = 0;
        for (int i = 0; i < this.fluidlist.size(); ++i) {
            FluidStack l = this.fluidlist.get(i);
            amt += l.amount;
        }
        return amt;
    }

    public int getFluidAmount() {
        return this.currentLiquid;
    }

    public int getFillRatio() {
        return this.currentLiquid <= 0 ? 0 : this.maxLiquid / this.getTotalFluidAmount();
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public FluidTankInfo[] getMultiTankInfo() {
        FluidTankInfo[] info = new FluidTankInfo[this.fluidlist.size() + 1];
        for (int i = 0; i < this.fluidlist.size(); ++i) {
            FluidStack fluid = this.fluidlist.get(i);
            info[i] = new FluidTankInfo(fluid.copy(), fluid.amount);
        }
        info[this.fluidlist.size()] = new FluidTankInfo(null, this.maxLiquid - this.currentLiquid);
        return info;
    }

    public void setTurbineAttached(boolean flag) {
        this.activeTurbineAttached = flag;
    }

    public boolean isTurbineAttached() {
        return this.activeTurbineAttached;
    }

    boolean containsAlloy() {
        for (FluidStack fluid : this.fluidlist) {
            if (!this.fluidIsAlloy(fluid)) continue;
            return true;
        }
        return false;
    }

    boolean fluidIsAlloy(FluidStack fluidstack) {
        for (int i = 0; i < AlloyInfo.alloys.size(); ++i) {
            if (fluidstack.getFluid() != AlloyInfo.alloys.get((int)i).result.copy().getFluid()) continue;
            return true;
        }
        return false;
    }

    void dealloyFluids() {
        if (!this.isStructureValid()) {
            return;
        }
        if (!this.containsAlloy) {
            return;
        }
        for (int i = 0; i < this.fluidlist.size(); ++i) {
            FluidStack alloy = this.fluidlist.get(i).copy();
            if (!this.fluidIsAlloy(alloy)) continue;
            ArrayList<FluidStack> fluids = AlloyInfo.deAlloy(alloy);
            this.fluidlist.remove(i);
            for (int j = 0; j < fluids.size(); ++j) {
                FluidStack liquid = fluids.get(j);
                this.addFluidToTank(liquid, true);
            }
        }
    }

    public void func_70307_a(NBTTagCompound tags) {
        this.layers = tags.func_74762_e("Layers");
        this.innerMaxX = tags.func_74762_e("InnerMaxX");
        this.innerMaxZ = tags.func_74762_e("InnerMaxZ");
        super.func_70307_a(tags);
        this.containsAlloy = tags.func_74767_n("ContainsAlloy");
        int[] center = tags.func_74759_k("CenterPos");
        this.centerPos = center.length > 2 ? new CoordTuple(center[0], center[1], center[2]) : new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.direction = tags.func_74771_c("Direction");
        this.currentLiquid = tags.func_74762_e("CurrentLiquid");
        this.maxLiquid = tags.func_74762_e("MaxLiquid");
        NBTTagList liquidTag = tags.func_74761_m("Liquids");
        this.fluidlist.clear();
        for (int iter = 0; iter < liquidTag.func_74745_c(); ++iter) {
            NBTTagCompound nbt = (NBTTagCompound)liquidTag.func_74743_b(iter);
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
            if (fluid == null) continue;
            this.fluidlist.add(fluid);
        }
    }

    public void func_70310_b(NBTTagCompound tags) {
        super.func_70310_b(tags);
        tags.func_74757_a("ContainsAlloy", this.containsAlloy);
        int[] center = new int[3];
        center = this.centerPos == null ? new int[]{this.field_70329_l, this.field_70330_m, this.field_70327_n} : new int[]{this.centerPos.x, this.centerPos.y, this.centerPos.z};
        tags.func_74783_a("CenterPos", center);
        tags.func_74774_a("Direction", this.direction);
        tags.func_74768_a("CurrentLiquid", this.currentLiquid);
        tags.func_74768_a("MaxLiquid", this.maxLiquid);
        tags.func_74768_a("InnerMaxZ", this.innerMaxZ);
        tags.func_74768_a("InnerMaxX", this.innerMaxX);
        tags.func_74768_a("Layers", this.layers);
        NBTTagList taglist = new NBTTagList();
        for (FluidStack liquid : this.fluidlist) {
            NBTTagCompound nbt = new NBTTagCompound();
            liquid.writeToNBT(nbt);
            taglist.func_74742_a((NBTBase)nbt);
        }
        tags.func_74782_a("Liquids", (NBTBase)taglist);
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
        this.func_70296_d();
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        this.needsUpdate = true;
    }

    public CoordTuple getCoord() {
        return new CoordTuple(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public boolean isValid() {
        return this.validStructure;
    }

    public int getBlockId() {
        return this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }
}

