/*
 * Decompiled with CFR 0.152.
 */
package tsteelworks.client.pages;

import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tconstruct.client.gui.PartCrafterGui;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.tools.ToolMaterial;
import tsteelworks.client.pages.TSBookPage;
import tsteelworks.lib.client.TSClientRegistry;

public class TSMaterialPage
extends TSBookPage {
    String title;
    ItemStack[] icons;
    String iconText;
    ToolMaterial material;

    @Override
    public void readPageFromXML(Element element) {
        NodeList nodes = element.getElementsByTagName("title");
        if (nodes != null) {
            this.title = nodes.item(0).getTextContent();
        }
        this.icons = new ItemStack[4];
        nodes = element.getElementsByTagName("text");
        if (nodes != null) {
            this.iconText = nodes.item(0).getTextContent();
        }
        if ((nodes = element.getElementsByTagName("icon")) != null) {
            this.icons[0] = TSClientRegistry.getManualIcon(nodes.item(0).getTextContent());
        }
        this.material = (nodes = element.getElementsByTagName("toolmaterial")) != null && nodes.getLength() > 0 ? TConstructRegistry.getMaterial((String)nodes.item(0).getTextContent()) : TConstructRegistry.getMaterial((String)this.title);
        nodes = element.getElementsByTagName("material").item(0).getChildNodes();
        this.icons[1] = TSClientRegistry.getManualIcon(nodes.item(1).getTextContent());
        this.icons[2] = PatternBuilder.instance.getShardFromSet(this.material.name());
        this.icons[3] = PatternBuilder.instance.getRodFromSet(this.material.name());
    }

    @Override
    public void renderContentLayer(int localWidth, int localHeight) {
        String heart;
        this.manual.fonts.drawString("\u00a7n" + this.title, localWidth + 70, localHeight + 4, 0);
        this.manual.fonts.drawSplitString(this.iconText, localWidth, localHeight + 16, 178, 0);
        this.manual.fonts.drawString("Material: ", localWidth + 108, localHeight + 40, 0);
        this.manual.fonts.drawString("Shard: ", localWidth + 108, localHeight + 72, 0);
        this.manual.fonts.drawString("Rod: ", localWidth + 108, localHeight + 104, 0);
        GL11.glEnable((int)32826);
        RenderHelper.func_74520_c();
        this.manual.renderitem.zLevel = 100.0f;
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().field_71446_o, this.icons[1], localWidth + 108, localHeight + 50);
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().field_71446_o, this.icons[2], localWidth + 108, localHeight + 82);
        this.manual.renderitem.renderItemAndEffectIntoGUI(this.manual.fonts, this.manual.getMC().field_71446_o, this.icons[3], localWidth + 108, localHeight + 114);
        this.manual.renderitem.zLevel = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
        String icon = this.icons[1].func_82840_a((EntityPlayer)this.manual.getMC().field_71439_g, false).get(0).toString();
        int iconOffset = icon.length() > 12 ? 0 : 3;
        this.manual.fonts.drawSplitString(icon, localWidth + 128, localHeight + 50 + iconOffset, 52, 0);
        if (this.icons[2] != null) {
            icon = this.icons[2].func_82840_a((EntityPlayer)this.manual.getMC().field_71439_g, false).get(0).toString();
            iconOffset = icon.length() > 12 ? 0 : 3;
            this.manual.fonts.drawSplitString(this.icons[2].func_82840_a((EntityPlayer)this.manual.getMC().field_71439_g, false).get(0).toString(), localWidth + 128, localHeight + 82 + iconOffset, 52, 0);
        }
        if (this.icons[3] != null) {
            icon = this.icons[3].func_82840_a((EntityPlayer)this.manual.getMC().field_71439_g, false).get(0).toString();
            iconOffset = icon.length() > 12 ? 0 : 3;
            this.manual.fonts.drawSplitString(this.icons[3].func_82840_a((EntityPlayer)this.manual.getMC().field_71439_g, false).get(0).toString(), localWidth + 128, localHeight + 114 + iconOffset, 52, 0);
        }
        this.manual.fonts.drawString("Durability: " + this.material.durability(), localWidth, localHeight + 40, 0);
        this.manual.fonts.drawString("Handle Modifier: " + this.material.handleDurability() + "x", localWidth, localHeight + 50, 0);
        this.manual.fonts.drawString("Full Tool Durability: " + (int)((float)this.material.durability() * this.material.handleDurability()), localWidth, localHeight + 60, 0);
        this.manual.fonts.drawString("Mining Speed: " + (float)this.material.toolSpeed() / 100.0f, localWidth, localHeight + 80, 0);
        this.manual.fonts.drawString("Mining Level: " + this.material.harvestLevel() + " (" + PartCrafterGui.getHarvestLevelName((int)this.material.harvestLevel()) + ")", localWidth, localHeight + 90, 0);
        int attack = this.material.attack();
        String string = heart = attack == 2 ? " Heart" : " Hearts";
        if (attack % 2 == 0) {
            this.manual.fonts.drawString("Base Attack: " + this.material.attack() / 2 + heart, localWidth, localHeight + 100, 0);
        } else {
            this.manual.fonts.drawString("Base Attack: " + (float)this.material.attack() / 2.0f + heart, localWidth, localHeight + 100, 0);
        }
        int offset = 0;
        String ability = this.material.ability();
        if (!ability.equals("")) {
            this.manual.fonts.drawString("Material Trait: " + this.material.ability(), localWidth, localHeight + 120 + 10 * offset, 0);
            ++offset;
            if (ability.equals("Writable")) {
                this.manual.fonts.drawString("+1 Modifiers", localWidth, localHeight + 120 + 10 * offset, 0);
            }
        }
        if (this.material.reinforced() > 0) {
            this.manual.fonts.drawString("Material Trait: Reinforced", localWidth, localHeight + 120 + 10 * offset, 0);
            this.manual.fonts.drawString("Reinforced level: " + this.material.reinforced(), localWidth, localHeight + 120 + 10 * ++offset, 0);
            ++offset;
        }
        if (this.material.shoddy() > 0.0f) {
            this.manual.fonts.drawString("Stonebound level: " + this.material.shoddy(), localWidth, localHeight + 120 + 10 * offset, 0);
            ++offset;
        } else if (this.material.shoddy() < 0.0f) {
            this.manual.fonts.drawString("Splintering level: " + -this.material.shoddy(), localWidth, localHeight + 120 + 10 * offset, 0);
            ++offset;
        }
    }
}

