/*
 * Decompiled with CFR 0.152.
 */
package mods.neiplugins;

import codechicken.nei.ItemList;
import java.util.ArrayList;
import mods.neiplugins.NEIPlugins;
import mods.neiplugins.common.FirstTickHandler;
import mods.neiplugins.common.IFirstTickHandler;
import mods.neiplugins.common.IPlugin;
import mods.neiplugins.interfaces.IItemListLoaded;

public class NEIPlugins_ItemListFix
implements IPlugin,
IFirstTickHandler {
    public static final String PLUGIN_NAME = "NEIPlugins_ItemListFix";
    public static final String PLUGIN_VERSION = "1.0.0";
    public static final String REQUIRED_MOD = "";
    private static boolean itemListLoaded = true;
    private static boolean configLoaded = false;
    private static ArrayList<IItemListLoaded> handlers = new ArrayList();

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public String getPluginVersion() {
        return PLUGIN_VERSION;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static void addHandler(IItemListLoaded handler) {
        handlers.add(handler);
        String name = handler.getClass().getName();
        try {
            name = handler.getName();
            if (configLoaded) {
                handler.onLoadConfig();
                NEIPlugins.logFine("IItemListLoaded.onLoadConfig(): {0}", name);
            }
            if (itemListLoaded) {
                handler.onItemListLoaded();
                NEIPlugins.logFine("IItemListLoaded.onItemListLoaded(): {0}", name);
            }
        }
        catch (Throwable ex) {
            NEIPlugins.logWarningEx("Error in {0}", ex, name);
        }
    }

    @Override
    public void init() {
        itemListLoaded = false;
        configLoaded = false;
        FirstTickHandler.handlers.add(this);
    }

    @Override
    public void loadConfig() {
        configLoaded = true;
        for (IItemListLoaded handler : handlers) {
            String name = handler.getClass().getName();
            try {
                name = handler.getName();
                handler.onLoadConfig();
                NEIPlugins.logFine("IItemListLoaded.onLoadConfig(): {0}", name);
            }
            catch (Throwable ex) {
                NEIPlugins.logWarningEx("Error in {0}", ex, name);
            }
        }
    }

    @Override
    public boolean firstServerTick() {
        return true;
    }

    @Override
    public boolean firstClientTick() {
        if (ItemList.items.isEmpty()) {
            return false;
        }
        if (itemListLoaded) {
            return true;
        }
        itemListLoaded = true;
        for (IItemListLoaded handler : handlers) {
            String name = handler.getClass().getName();
            try {
                name = handler.getName();
                handler.onItemListLoaded();
                NEIPlugins.logFine("IItemListLoaded.onItemListLoaded(): {0}", name);
            }
            catch (Throwable ex) {
                NEIPlugins.logWarningEx("Error in {0}", ex, name);
            }
        }
        return itemListLoaded;
    }
}

