/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cluster.implementations;

import appeng.api.TileRef;
import appeng.api.WorldCoord;
import appeng.api.events.GridTileConnectivityEvent;
import appeng.me.cluster.IAECluster;
import appeng.me.tile.TileSpatialPylon;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class SpatialPylonCluster
implements IAECluster {
    public WorldCoord min;
    public WorldCoord max;
    public boolean isDestroyed = false;
    public Axis currentAxis = Axis.UNFORMED;
    List<TileRef<TileSpatialPylon>> line = new ArrayList<TileRef<TileSpatialPylon>>();
    public boolean isValid;

    public SpatialPylonCluster(WorldCoord _min, WorldCoord _max) {
        this.min = _min.copy();
        this.max = _max.copy();
        this.currentAxis = this.min.x != this.max.x ? Axis.X : (this.min.y != this.max.y ? Axis.Y : (this.min.z != this.max.z ? Axis.Z : Axis.UNFORMED));
    }

    @Override
    public void updateStatus(boolean updateGrid) {
        for (TileRef<TileSpatialPylon> r : this.line) {
            try {
                TileSpatialPylon tsp = r.getTile();
                MinecraftForge.EVENT_BUS.post((Event)new GridTileConnectivityEvent(tsp, tsp.getWorld(), tsp.getLocation()));
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void destroy() {
        if (this.isDestroyed) {
            return;
        }
        this.isDestroyed = true;
        for (TileRef<TileSpatialPylon> r : this.line) {
            try {
                r.getTile().updateStatus(null);
            }
            catch (Exception exception) {}
        }
    }

    public void setNetworkStatus(boolean _isValid) {
        this.isValid = _isValid;
        for (TileRef<TileSpatialPylon> r : this.line) {
            try {
                r.getTile().updateNetworkStatus(this.isValid);
            }
            catch (Exception e) {}
        }
    }

    public int tileCount() {
        return this.line.size();
    }

    public static enum Axis {
        X,
        Y,
        Z,
        UNFORMED;

    }
}

