/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.crafting;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.me.tiles.ITilePushable;
import appeng.api.me.util.ICraftingPattern;
import appeng.api.me.util.IMEInventory;
import appeng.common.AppEng;
import appeng.common.AppEngConfiguration;
import appeng.me.METhrottle;
import appeng.me.crafting.CraftRequest;
import appeng.me.crafting.CraftingJobPacket;
import appeng.me.tile.TileController;
import appeng.util.AEItemStack;
import appeng.util.Platform;
import java.util.Deque;
import net.minecraft.item.ItemStack;

public class PushCraftRequest
extends CraftRequest {
    ITilePushable ti;
    boolean canCraft;
    private METhrottle t;

    public PushCraftRequest(String NetworkID, ItemStack is, ITilePushable te, boolean allowCrafting) {
        super(NetworkID, is);
        this.ti = te;
        this.canCraft = allowCrafting;
        this.t = new METhrottle(5, AppEngConfiguration.automationMinTickRate, AppEngConfiguration.automationMinTickRate + 300);
        this.t.wakeUp();
        AppEng.craftingLog(NetworkID, is, " will push " + is.field_77994_a);
    }

    @Override
    public String requestType() {
        return "PushCraftRequest";
    }

    @Override
    public void populateJobPacket(CraftingJobPacket cjp) {
        for (CraftRequest cr : this.Prereqs) {
            cr.populateJobPacket(cjp);
        }
    }

    @Override
    protected void completePreReq(CraftRequest craftRequest) {
        super.completePreReq(craftRequest);
        this.t.wakeUp();
    }

    @Override
    public boolean Craft(TileController tc, ICraftingPattern pattern, IMEInventory invItemPool, IItemList all, Deque<CraftRequest> craftingQueue, Deque<CraftRequest> waitingQueue) {
        if (this.Prereqs.size() > 0) {
            return false;
        }
        if (this.t.process()) {
            int max_pushes = (int)(2.0f * this.t.getMultipler());
            while (this.req.getStackSize() > 0L) {
                if (max_pushes-- < 0) {
                    return true;
                }
                IAEItemStack b = this.req.copy();
                if (this.ti.canPushItem(Platform.getSharedItemStack(b))) {
                    IAEItemStack is = invItemPool.extractItems(b);
                    if (is == null && this.canRequestPrereqs()) {
                        if (this.canCraft) {
                            ItemStack ps = Platform.getSharedItemStack(this.req);
                            ps.field_77994_a = 1;
                            this.requestedPreReqs(tc.craftingRequest(ps));
                        } else {
                            ItemStack ps = Platform.getSharedItemStack(this.req);
                            ps.field_77994_a = 1;
                            this.requestedPreReqs(tc.waitingRequest(ps));
                        }
                        return true;
                    }
                    int pushed = 0;
                    if (tc.useMEEnergy(2.0f, "pushItem")) {
                        AppEng.craftingLog(this.NetworkID, this.req, " pushing.");
                        int prePush = (int)is.getStackSize();
                        is = AEItemStack.create(this.ti.pushItem(Platform.getSharedItemStack(is)));
                        pushed = is == null ? prePush : prePush - (int)is.getStackSize();
                    }
                    if (pushed > 0) {
                        this.t.hasAccomplishedWork();
                    }
                    for (int x = 0; x < pushed; ++x) {
                        this.markCrafted();
                    }
                    if (is == null) continue;
                    invItemPool.addItems(is);
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean requirePattern() {
        return false;
    }
}

