/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.IAEItemStack;
import appeng.api.IItemList;
import appeng.api.Materials;
import appeng.api.Util;
import appeng.api.config.CondenserOuput;
import appeng.api.config.IConfigEnum;
import appeng.api.me.items.IStorageComponent;
import appeng.api.me.tiles.IConfigureableTile;
import appeng.api.me.util.IConfigManager;
import appeng.api.me.util.IMEInventoryHandler;
import appeng.common.AppEngConfiguration;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.base.AppEngTile;
import appeng.common.network.IAppEngNetworkTile;
import appeng.gui.AppEngGuiHandler;
import appeng.interfaces.IConfigEnabledTile;
import appeng.interfaces.InvOperation;
import appeng.me.tile.IInternalInventory;
import appeng.util.ConfigManager;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileCondenser
extends AppEngTile
implements IInventory,
IConfigEnabledTile,
IConfigureableTile,
IAppEngNetworkTile {
    long matterEnergy = 0L;
    ConfigManager config = new ConfigManager(this);
    CondenserOuput configured = CondenserOuput.Trash;
    public AppEngInternalInventory output;
    public AppEngInternalInventory cell;
    public AppEngInternalInventory Installed;

    public long getRequiredPower() {
        if (this.configured == CondenserOuput.Singularity) {
            return AppEngConfiguration.condenserSingularies;
        }
        if (this.configured == CondenserOuput.MatterBalls) {
            return AppEngConfiguration.condenserMatterBalls;
        }
        try {
            return ((IStorageComponent)this.Installed.func_70301_a(0).func_77973_b()).getBytes(this.Installed.func_70301_a(0)) * 8;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getMatterEnergy() {
        return this.matterEnergy;
    }

    private boolean accumulateEnergy(long s) {
        if (s >= 0L) {
            if (this.Installed.func_70301_a(0) == null) {
                this.matterEnergy = 0L;
                this.triggerContainerUpdate();
                this.func_70296_d();
                return false;
            }
            int storageableEnergy = 0;
            try {
                storageableEnergy = ((IStorageComponent)this.Installed.func_70301_a(0).func_77973_b()).getBytes(this.Installed.func_70301_a(0)) * 8;
            }
            catch (Exception err) {
                // empty catch block
            }
            this.matterEnergy += s;
            if ((long)storageableEnergy < this.matterEnergy) {
                this.matterEnergy = storageableEnergy;
            }
            boolean response = false;
            if (this.configured == CondenserOuput.Singularity && storageableEnergy >= AppEngConfiguration.condenserSingularies) {
                response = this.CreateItem(Materials.matSingularity, AppEngConfiguration.condenserSingularies);
            } else if (this.configured == CondenserOuput.MatterBalls && storageableEnergy >= AppEngConfiguration.condenserMatterBalls) {
                response = this.CreateItem(Materials.matMatterBall, AppEngConfiguration.condenserMatterBalls);
            }
            this.scheduleBlockUpdate(1);
            this.func_70296_d();
            return response;
        }
        return false;
    }

    private boolean CreateItem(ItemStack x, int energyCost) {
        if (this.matterEnergy >= (long)energyCost) {
            ItemStack newItem = x.func_77946_l();
            newItem.field_77994_a = 1;
            InventoryAdaptor ia = InventoryAdaptor.getAdaptor(this.output, ForgeDirection.UNKNOWN);
            if (ia != null && null == ia.simulateAdd(newItem) && ia.addItems(newItem) == null) {
                this.matterEnergy -= (long)energyCost;
                this.triggerContainerUpdate();
                this.func_70296_d();
                this.scheduleBlockUpdate(5);
                return true;
            }
        }
        return false;
    }

    @Override
    public void InvChanged(IInternalInventory inv, int slot, InvOperation Operation) {
        if (inv == this.output && this.output.func_70301_a(0) == null) {
            this.gen();
        }
        if (inv == this.cell) {
            this.scheduleBlockUpdate(5);
        }
        if (inv == this.Installed) {
            this.gen();
        }
    }

    public TileCondenser() {
        this.config.RegisterSetting(this.configured);
        this.output = new AppEngInternalInventory(this, 1);
        this.cell = new AppEngInternalInventory(this, 1);
        this.Installed = new AppEngInternalInventory(this, 1);
    }

    @Override
    public void init() {
        super.init();
        this.scheduleBlockUpdate(5);
    }

    @Override
    public boolean requiresTickingUpdates() {
        return false;
    }

    @Override
    public void updateTileEntity() {
        IItemList il;
        IAEItemStack o;
        IMEInventoryHandler inv;
        if (this.cell.func_70301_a(0) != null && (inv = Util.getCellRegistry().getHandlerForCell(this.cell.func_70301_a(0))) != null && (o = (il = inv.getAvailableItems()).getFirstItem()) != null) {
            IAEItemStack is;
            if (o.getStackSize() > 512L) {
                o.setStackSize(512L);
            }
            if ((is = inv.extractItems(o)) != null) {
                this.accumulateEnergy(is.getStackSize());
                this.triggerContainerUpdate();
                this.scheduleBlockUpdate(5);
            }
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        NBTTagCompound invnbt = new NBTTagCompound();
        this.output.writeToNBT(invnbt);
        NBTTagCompound cellnbt = new NBTTagCompound();
        this.cell.writeToNBT(cellnbt);
        NBTTagCompound cellInstalledTag = new NBTTagCompound();
        if (this.Installed.func_70301_a(0) != null) {
            this.Installed.func_70301_a(0).func_77955_b(cellInstalledTag);
        }
        tagCompound.func_74766_a("output", invnbt);
        tagCompound.func_74766_a("cell", cellnbt);
        tagCompound.func_74766_a("installed", cellInstalledTag);
        tagCompound.func_74772_a("energy", this.matterEnergy);
        tagCompound.func_74778_a("mode", this.configured.toString());
    }

    @Override
    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.matterEnergy = tagCompound.func_74763_f("energy");
        this.output.readFromNBT(tagCompound.func_74775_l("output"));
        this.cell.readFromNBT(tagCompound.func_74775_l("cell"));
        this.Installed.func_70299_a(0, ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("installed")));
        this.configured = (CondenserOuput)this.config.loadSetting(this.configured, tagCompound, "mode");
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection dir) {
        return AppEngTextureRegistry.Blocks.BlockCondendser.get();
    }

    public int func_70302_i_() {
        return this.output.func_70302_i_() + 1;
    }

    public ItemStack func_70301_a(int i) {
        if (i == this.output.func_70302_i_()) {
            return null;
        }
        return this.output.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i == this.output.func_70302_i_()) {
            return null;
        }
        ItemStack out = this.output.func_70298_a(i, j);
        this.gen();
        return out;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == this.output.func_70302_i_()) {
            this.accumulateEnergy(itemstack.field_77994_a);
            this.triggerContainerUpdate();
            return;
        }
        this.output.func_70299_a(i, itemstack);
        this.gen();
    }

    public String func_70303_b() {
        return "ME Condenser";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == this.output.func_70302_i_();
    }

    @Override
    public void openGui(EntityPlayer p) {
        Platform.openGui(p, AppEngGuiHandler.GUI_CONDENSER, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void trashItem(IInventory trash) {
        for (int x = 0; x < trash.func_70302_i_(); ++x) {
            ItemStack s = trash.func_70301_a(x);
            if (s == null) continue;
            trash.func_70299_a(x, null);
            this.accumulateEnergy(s.field_77994_a);
            this.triggerContainerUpdate();
        }
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.Installed.func_70301_a(0) != null) {
            drops.add(this.Installed.func_70301_a(0));
        }
        return super.getDrops(w, x, y, z, drops);
    }

    public boolean upgrade(ItemStack is) {
        if (this.Installed.func_70301_a(0) == null) {
            this.Installed.func_70299_a(0, is);
            this.gen();
            return true;
        }
        return false;
    }

    private void gen() {
        while (this.accumulateEnergy(0L)) {
        }
    }

    @Override
    public List<String> getConfigurations() {
        return this.config.getConfigurations();
    }

    @Override
    public String nextConfiguration(String name) {
        return this.config.nextConfiguration(name);
    }

    @Override
    public String prevConfiguration(String name) {
        return this.config.prevConfiguration(name);
    }

    @Override
    public String setConfiguration(String name, String value) {
        return this.config.setConfiguration(name, value);
    }

    @Override
    public String getConfiguration(String name) {
        return this.config.getConfiguration(name);
    }

    @Override
    public List<String> getConfiguationOptions(String name) {
        return this.config.getConfiguationOptions(name);
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeLong(this.matterEnergy);
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.GUI;
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        this.matterEnergy = stream.readLong();
        return false;
    }

    @Override
    public void updateSetting(IConfigEnum newValue) {
        if (newValue instanceof CondenserOuput) {
            this.configured = (CondenserOuput)newValue;
            if (this.field_70331_k != null) {
                this.notifyNeightbors();
                this.gen();
            }
        }
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }
}

