/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.tile;

import appeng.api.me.items.ISpatialStorage;
import appeng.api.me.tiles.IGridMachine;
import appeng.api.me.util.IGridInterface;
import appeng.api.me.util.TransitionResult;
import appeng.common.AppEng;
import appeng.common.AppEngInternalInventory;
import appeng.common.AppEngTextureRegistry;
import appeng.common.network.IAppEngNetworkTile;
import appeng.me.basetiles.TileME;
import appeng.me.cache.SpatialPylonCache;
import appeng.util.Platform;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileSpatialIOPort
extends TileME
implements IGridMachine,
ISidedInventory,
IAppEngNetworkTile {
    public double powerRequired = 0.0;
    public double available = 0.0;
    public double effiency = 0.0;
    public AppEngInternalInventory item;
    int[] sides = new int[]{0, 1};

    public TileSpatialIOPort() {
        this.item = new AppEngInternalInventory(this, 2);
    }

    @Override
    public boolean requiresRedstoneUpdates() {
        return true;
    }

    @Override
    public void pulseRedStone() {
        if (Platform.isServer()) {
            World dest;
            ItemStack cell = this.item.func_70301_a(0);
            ISpatialStorage sc = AppEng.getApiInstance().getSpatialStorageForItem(cell);
            if (sc != null && (dest = sc.getWorld(cell)) == null) {
                World world = sc.createNewWorld(cell);
            }
            this.getTickHandler().tickCall(this, "tickActivation");
        }
    }

    public void tickActivation() {
        IGridInterface gi = this.getGrid();
        if (this.item.func_70301_a(1) == null && gi != null) {
            SpatialPylonCache spc;
            ItemStack cell = this.item.func_70301_a(0);
            ISpatialStorage sc = AppEng.getApiInstance().getSpatialStorageForItem(cell);
            if (sc != null && (spc = (SpatialPylonCache)gi.getCacheByID(SpatialPylonCache.index)).hasRegion() && spc.isValidRegion()) {
                float preq = (float)this.powerRequired;
                double pr = gi.canUsePower((float)this.powerRequired) - preq;
                if (Math.abs(pr) < 1.0) {
                    TransitionResult tr = sc.doSpatialTransition(cell, this.field_70331_k, spc.getMin(), spc.getMax(), true);
                    if (tr.success) {
                        gi.useMEEnergy((float)this.powerRequired, "SpatialTransition");
                        this.item.func_70299_a(0, null);
                        this.item.func_70299_a(1, cell);
                    }
                }
            }
        }
    }

    @Override
    public Icon getBlockTextureFromSide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return AppEngTextureRegistry.Blocks.BlockSpatialIOPortTop.get();
        }
        if (side == ForgeDirection.DOWN) {
            return AppEngTextureRegistry.Blocks.GenericBottom.get();
        }
        return AppEngTextureRegistry.Blocks.BlockSpatialIOPortSide.get();
    }

    @Override
    public boolean getDrops(World w, int x, int y, int z, List<ItemStack> drops) {
        if (this.item.func_70301_a(0) != null) {
            drops.add(this.item.func_70301_a(0));
        }
        if (this.item.func_70301_a(1) != null) {
            drops.add(this.item.func_70301_a(1));
        }
        return true;
    }

    @Override
    public void func_70310_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70310_b(par1nbtTagCompound);
        NBTTagCompound c = new NBTTagCompound();
        this.item.writeToNBT(c);
        par1nbtTagCompound.func_74766_a("inv", c);
    }

    @Override
    public void func_70307_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70307_a(par1nbtTagCompound);
        NBTTagCompound c = par1nbtTagCompound.func_74775_l("inv");
        this.item.readFromNBT(c);
    }

    @Override
    public float getPowerDrainPerTick() {
        return 1.0f;
    }

    public int func_70302_i_() {
        return this.item.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.item.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.item.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.item.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return "TileSpatialIOPort";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i == 0 ? this.isSpatialCell(itemstack) : false;
    }

    private boolean isSpatialCell(ItemStack cell) {
        ISpatialStorage sc = AppEng.getApiInstance().getSpatialStorageForItem(cell);
        return sc != null;
    }

    public int[] func_94128_d(int var1) {
        return this.sides;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.isCommonUseableByPlayer(entityplayer);
    }

    @Override
    public void configureTilePacket(DataOutputStream data) throws IOException {
        data.writeDouble(this.powerRequired);
        data.writeDouble(this.effiency);
        this.available = 0.0;
        IGridInterface gi = this.getGrid();
        if (gi != null) {
            this.available = gi.getAvailablePower();
        }
        data.writeDouble(this.available);
    }

    @Override
    public boolean handleTilePacket(DataInputStream stream) throws IOException {
        this.powerRequired = stream.readDouble();
        this.effiency = stream.readDouble();
        this.available = stream.readDouble();
        return false;
    }

    @Override
    public boolean syncStyle(IAppEngNetworkTile.SyncTime st) {
        return st == IAppEngNetworkTile.SyncTime.GUI;
    }
}

