/*
 * Decompiled with CFR 0.152.
 */
package redstonearsenal.item.tool;

import cofh.util.MathHelper;
import cofh.util.ServerHelper;
import cofh.util.StringHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import redstonearsenal.item.tool.ItemToolRF;

public class ItemShovelRF
extends ItemToolRF {
    public static Set<Block> effectiveBlocks = new HashSet<Block>();
    public static Set<Material> effectiveMaterials = new HashSet<Material>();
    int range = 5;

    public ItemShovelRF(int id, EnumToolMaterial toolMaterial) {
        this(id, toolMaterial, toolMaterial.func_77996_d());
    }

    public ItemShovelRF(int id, EnumToolMaterial toolMaterial, int harvestLevel) {
        super(id, toolMaterial);
        MinecraftForge.setToolClass((Item)this, (String)"shovel", (int)harvestLevel);
        this.damage = 3;
        this.energyPerUseCharged = 800;
    }

    @Override
    protected Set<Block> getEffectiveBlocks(ItemStack stack) {
        return effectiveBlocks;
    }

    @Override
    protected Set<Material> getEffectiveMaterials(ItemStack stack) {
        return effectiveMaterials;
    }

    protected boolean hoeBlock(World world, int x, int y, int z, int hitSide, EntityPlayer player) {
        int bId2;
        if (hitSide == 0) {
            return false;
        }
        Block block = Block.field_72050_aA;
        int bId = world.func_72798_a(x, y, z);
        boolean air = world.func_72799_c(x, y + 1, z);
        if (!air && (double)Block.field_71973_m[bId2 = world.func_72798_a(x, y + 1, z)].func_71934_m(world, x, y + 1, z) == 0.0) {
            this.harvestBlock(world, x, y + 1, z, player);
            air = true;
        }
        if (air && (bId == Block.field_71980_u.field_71990_ca || bId == Block.field_71979_v.field_71990_ca)) {
            world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), block.field_72020_cn.func_72675_d(), (block.field_72020_cn.func_72677_b() + 1.0f) / 2.0f, block.field_72020_cn.func_72678_c() * 0.8f);
            if (ServerHelper.isServerWorld((World)world)) {
                world.func_94575_c(x, y, z, block.field_71990_ca);
            }
            return true;
        }
        return false;
    }

    public boolean func_77641_a(Block block) {
        return block == Block.field_72037_aS ? true : block == Block.field_72039_aU;
    }

    public boolean func_77660_a(ItemStack stack, World world, int bId, int x, int y, int z, EntityLivingBase entity) {
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        if ((double)Block.field_71973_m[bId].func_71934_m(world, x, y, z) == 0.0) {
            return true;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (effectiveBlocks.contains(Block.field_71973_m[bId]) && this.isEmpowered(stack)) {
            int facing = MathHelper.floor((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            switch (facing) {
                case 0: {
                    for (int i = z; i < z + this.range && effectiveBlocks.contains(Block.field_71973_m[world.func_72798_a(x, y, i)]); ++i) {
                        this.harvestBlock(world, x, y, i, player);
                    }
                    break;
                }
                case 1: {
                    for (int i = x; i > x - this.range && effectiveBlocks.contains(Block.field_71973_m[world.func_72798_a(i, y, z)]); --i) {
                        this.harvestBlock(world, i, y, z, player);
                    }
                    break;
                }
                case 2: {
                    for (int i = z; i > z - this.range && effectiveBlocks.contains(Block.field_71973_m[world.func_72798_a(x, y, i)]); --i) {
                        this.harvestBlock(world, x, y, i, player);
                    }
                    break;
                }
                case 3: {
                    for (int i = x; i < x + this.range && effectiveBlocks.contains(Block.field_71973_m[world.func_72798_a(i, y, z)]); ++i) {
                        this.harvestBlock(world, i, y, z, player);
                    }
                    break;
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int hitSide, float hitX, float hitY, float hitZ) {
        if (!player.func_82247_a(x, y, z, hitSide, stack) || !player.field_71075_bZ.field_75098_d && this.getEnergyStored(stack) < this.getEnergyPerUse(stack)) {
            return false;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, x, y, z);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return true;
        }
        int hoeRange = 1;
        if (this.isEmpowered(stack)) {
            hoeRange = this.range;
        }
        int facing = MathHelper.floor((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        boolean used = false;
        switch (facing) {
            case 0: {
                for (int i = z; i < z + hoeRange && this.hoeBlock(world, x, y, i, hitSide, player); ++i) {
                    used = true;
                }
                break;
            }
            case 1: {
                for (int i = x; i > x - hoeRange && this.hoeBlock(world, i, y, z, hitSide, player); --i) {
                    used = true;
                }
                break;
            }
            case 2: {
                for (int i = z; i > z - hoeRange && this.hoeBlock(world, x, y, i, hitSide, player); --i) {
                    used = true;
                }
                break;
            }
            case 3: {
                for (int i = x; i < x + hoeRange && this.hoeBlock(world, i, y, z, hitSide, player); ++i) {
                    used = true;
                }
                break;
            }
        }
        if (used && !player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        return used;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        super.func_77624_a(stack, player, list, check);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        list.add(StringHelper.getFlavorText((String)"info.redstonearsenal.tool.shovel"));
    }

    static {
        for (Block block : ItemSpade.field_77866_c) {
            effectiveBlocks.add(block);
        }
    }
}

