/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.network.FMLNetworkHandler;
import cpw.mods.fml.common.network.FMLPacket;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.List;

public class ModMissingPacket
extends FMLPacket {
    private List<ModData> missing;
    private List<ModData> badVersion;

    public ModMissingPacket() {
        super(FMLPacket.Type.MOD_MISSING);
    }

    @Override
    public byte[] generatePacket(Object ... data) {
        ModContainer mc;
        ByteArrayDataOutput dat = ByteStreams.newDataOutput();
        List missing = (List)data[0];
        List badVersion = (List)data[1];
        dat.writeInt(missing.size());
        for (String missed : missing) {
            mc = Loader.instance().getIndexedModList().get(missed);
            dat.writeUTF(missed);
            dat.writeUTF(mc.getVersion());
        }
        dat.writeInt(badVersion.size());
        for (String bad : badVersion) {
            mc = Loader.instance().getIndexedModList().get(bad);
            dat.writeUTF(bad);
            dat.writeUTF(mc.getVersion());
        }
        return dat.toByteArray();
    }

    @Override
    public FMLPacket consumePacket(byte[] data) {
        ByteArrayDataInput dat = ByteStreams.newDataInput(data);
        int missingLen = dat.readInt();
        this.missing = Lists.newArrayListWithCapacity(missingLen);
        for (int i2 = 0; i2 < missingLen; ++i2) {
            ModData md = new ModData();
            md.modId = dat.readUTF();
            md.modVersion = dat.readUTF();
            this.missing.add(md);
        }
        int badVerLength = dat.readInt();
        this.badVersion = Lists.newArrayListWithCapacity(badVerLength);
        for (int i3 = 0; i3 < badVerLength; ++i3) {
            ModData md = new ModData();
            md.modId = dat.readUTF();
            md.modVersion = dat.readUTF();
            this.badVersion.add(md);
        }
        return this;
    }

    @Override
    public void execute(cm network, FMLNetworkHandler handler, ez netHandler, String userName) {
        FMLCommonHandler.instance().getSidedDelegate().displayMissingMods(this);
    }

    public List<ArtifactVersion> getModList() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ModData md : this.missing) {
            builder.add(new DefaultArtifactVersion(md.modId, VersionRange.createFromVersion(md.modVersion, null)));
        }
        for (ModData md : this.badVersion) {
            builder.add(new DefaultArtifactVersion(md.modId, VersionRange.createFromVersion(md.modVersion, null)));
        }
        return builder.build();
    }

    private static class ModData {
        String modId;
        String modVersion;

        private ModData() {
        }
    }
}

