/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class ConfigCategory
implements Map<String, Property> {
    private String name;
    private String comment;
    private ArrayList<ConfigCategory> children = new ArrayList();
    private Map<String, Property> properties = new TreeMap<String, Property>();
    public final ConfigCategory parent;
    private boolean changed = false;

    public ConfigCategory(String name) {
        this(name, null);
    }

    public ConfigCategory(String name, ConfigCategory parent) {
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConfigCategory) {
            ConfigCategory cat = (ConfigCategory)obj;
            return this.name.equals(cat.name) && this.children.equals(cat.children);
        }
        return false;
    }

    public String getQualifiedName() {
        return ConfigCategory.getQualifiedName(this.name, this.parent);
    }

    public static String getQualifiedName(String name, ConfigCategory parent) {
        return parent == null ? name : parent.getQualifiedName() + "." + name;
    }

    public ConfigCategory getFirstParent() {
        return this.parent == null ? this : this.parent.getFirstParent();
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public Map<String, Property> getValues() {
        return ImmutableMap.copyOf(this.properties);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Property get(String key) {
        return this.properties.get(key);
    }

    private void write(BufferedWriter out, String ... data) throws IOException {
        this.write(out, true, data);
    }

    private void write(BufferedWriter out, boolean new_line, String ... data) throws IOException {
        for (int x2 = 0; x2 < data.length; ++x2) {
            out.write(data[x2]);
        }
        if (new_line) {
            out.write(Configuration.NEW_LINE);
        }
    }

    public void write(BufferedWriter out, int indent) throws IOException {
        String pad0 = this.getIndent(indent);
        String pad1 = this.getIndent(indent + 1);
        String pad2 = this.getIndent(indent + 2);
        this.write(out, pad0, "####################");
        this.write(out, pad0, "# ", this.name);
        if (this.comment != null) {
            this.write(out, pad0, "#===================");
            Splitter splitter = Splitter.onPattern("\r?\n");
            for (String line : splitter.split(this.comment)) {
                this.write(out, pad0, "# ", line);
            }
        }
        this.write(out, pad0, "####################", Configuration.NEW_LINE);
        if (!Configuration.allowedProperties.matchesAllOf(this.name)) {
            this.name = '\"' + this.name + '\"';
        }
        this.write(out, pad0, this.name, " {");
        Property[] props = this.properties.values().toArray(new Property[this.properties.size()]);
        for (int x2 = 0; x2 < props.length; ++x2) {
            String propName;
            Property prop = props[x2];
            if (prop.comment != null) {
                if (x2 != 0) {
                    out.newLine();
                }
                Splitter splitter = Splitter.onPattern("\r?\n");
                for (String commentLine : splitter.split(prop.comment)) {
                    this.write(out, pad1, "# ", commentLine);
                }
            }
            if (!Configuration.allowedProperties.matchesAllOf(propName = prop.getName())) {
                propName = '\"' + propName + '\"';
            }
            if (prop.isList()) {
                char type = prop.getType().getID();
                this.write(out, pad1, String.valueOf(type), ":", propName, " <");
                for (String line : prop.getStringList()) {
                    this.write(out, pad2, line);
                }
                this.write(out, pad1, " >");
                continue;
            }
            if (prop.getType() == null) {
                this.write(out, pad1, propName, "=", prop.getString());
                continue;
            }
            char type = prop.getType().getID();
            this.write(out, pad1, String.valueOf(type), ":", propName, "=", prop.getString());
        }
        for (ConfigCategory child : this.children) {
            child.write(out, indent + 1);
        }
        this.write(out, pad0, "}", Configuration.NEW_LINE);
    }

    private String getIndent(int indent) {
        StringBuilder buf = new StringBuilder("");
        for (int x2 = 0; x2 < indent; ++x2) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        for (Property prop : this.properties.values()) {
            if (!prop.hasChanged()) continue;
            return true;
        }
        return false;
    }

    void resetChangedState() {
        this.changed = false;
        for (Property prop : this.properties.values()) {
            prop.resetChangedState();
        }
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Property get(Object key) {
        return this.properties.get(key);
    }

    @Override
    public Property put(String key, Property value) {
        this.changed = true;
        return this.properties.put(key, value);
    }

    @Override
    public Property remove(Object key) {
        this.changed = true;
        return this.properties.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Property> m2) {
        this.changed = true;
        this.properties.putAll(m2);
    }

    @Override
    public void clear() {
        this.changed = true;
        this.properties.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public Collection<Property> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Property>> entrySet() {
        return ImmutableSet.copyOf(this.properties.entrySet());
    }

    public Set<ConfigCategory> getChildren() {
        return ImmutableSet.copyOf(this.children);
    }

    public void removeChild(ConfigCategory child) {
        if (this.children.contains(child)) {
            this.children.remove(child);
            this.changed = true;
        }
    }
}

