/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import squeek.spiceoflife.ModConfig;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.proxy.ProxyHungerOverhaul;
import squeek.spiceoflife.proxy.ProxyTiC;

public class FoodValues {
    public int hunger;
    public float saturationModifier;

    public FoodValues(int hunger, float saturationModifier) {
        this.hunger = hunger;
        this.saturationModifier = saturationModifier;
    }

    public float getSaturationIncrement() {
        return (float)this.hunger * this.saturationModifier * 2.0f;
    }

    public FoodValues modify(float modifier) {
        this.hunger = (int)ModConfig.FOOD_HUNGER_ROUNDING_MODE.round((float)this.hunger * modifier);
        if (ModConfig.AFFECT_FOOD_SATURATION_MODIFIERS) {
            if (this.saturationModifier < 0.0f && ModConfig.AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS) {
                this.saturationModifier *= 2.0f - modifier;
            } else if (this.saturationModifier > 0.0f) {
                this.saturationModifier *= modifier;
            }
        }
        return this;
    }

    public FoodValues getModified(float modifier) {
        int modifiedHunger = (int)ModConfig.FOOD_HUNGER_ROUNDING_MODE.round((float)this.hunger * modifier);
        float modifiedSaturationModifier = this.saturationModifier;
        if (ModConfig.AFFECT_FOOD_SATURATION_MODIFIERS) {
            if (modifiedSaturationModifier < 0.0f && ModConfig.AFFECT_NEGATIVE_FOOD_SATURATION_MODIFIERS) {
                modifiedSaturationModifier *= 2.0f - modifier;
            } else if (modifiedSaturationModifier > 0.0f) {
                modifiedSaturationModifier *= modifier;
            }
        }
        return new FoodValues(modifiedHunger, modifiedSaturationModifier);
    }

    public static FoodValues get(ItemStack food) {
        if (!(food.func_77973_b() instanceof ItemFood)) {
            return null;
        }
        ItemFood itemFood = (ItemFood)food.func_77973_b();
        if (ProxyTiC.isSpecialFood((Item)itemFood)) {
            return ProxyTiC.getSpecialFoodValues(food);
        }
        if (ProxyHungerOverhaul.foodValuesWillBeModified(food)) {
            return ProxyHungerOverhaul.getModifiedFoodValues(itemFood);
        }
        return new FoodValues(itemFood.func_77847_f(), itemFood.func_77846_g());
    }

    public static FoodValues getModified(ItemStack food, float modifier) {
        return FoodValues.get(food).modify(modifier);
    }

    public static FoodValues getModified(ItemStack food, EntityPlayer player) {
        FoodValues defaultFoodValues = FoodValues.get(food);
        return defaultFoodValues.modify(FoodModifier.getFoodModifier(player, food, player.func_71024_bL(), defaultFoodValues.hunger, defaultFoodValues.saturationModifier));
    }

    public static float getSaturationModifierFromIncrement(float saturationIncrement, int hunger) {
        return hunger != 0 ? saturationIncrement / ((float)hunger * 2.0f) : 0.0f;
    }
}

