/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.GuiComponentSpriteButton;
import openmods.gui.component.GuiComponentStandardRecipePage;
import openmods.gui.component.IComponentListener;
import openmods.sync.SyncableString;
import openmods.utils.render.FakeIcon;

public class GuiComponentBook
extends BaseComponent
implements IComponentListener {
    private GuiComponentSprite imgLeftBackground = new GuiComponentSprite(0, 0, iconPageLeft, texture);
    private GuiComponentSprite imgRightBackground = new GuiComponentSprite(0, 0, iconPageRight, texture);
    private GuiComponentSpriteButton imgPrev = new GuiComponentSpriteButton(24, 158, iconPrev, iconPrevHover, texture);
    private GuiComponentSpriteButton imgNext;
    private GuiComponentLabel pageNumberLeft;
    private GuiComponentLabel pageNumberRight;
    private SyncableString strPageNumberLeft;
    private SyncableString strPageNumberRight;
    public static Icon iconPageLeft = FakeIcon.createSheetIcon(-45, 0, -211, 180);
    public static Icon iconPageRight = FakeIcon.createSheetIcon(0, 0, 211, 180);
    public static Icon iconPrev = FakeIcon.createSheetIcon(57, 226, 18, 10);
    public static Icon iconNext = FakeIcon.createSheetIcon(57, 213, 18, 10);
    public static Icon iconPrevHover = FakeIcon.createSheetIcon(80, 226, 18, 10);
    public static Icon iconNextHover = FakeIcon.createSheetIcon(80, 213, 18, 10);
    private static final ResourceLocation texture = new ResourceLocation("openmodslib:textures/gui/book.png");
    public List<BaseComponent> pages;
    private int index = 0;

    public GuiComponentBook() {
        super(0, 0);
        this.imgPrev.addListener(this);
        this.imgNext = new GuiComponentSpriteButton(380, 158, iconNext, iconNextHover, texture);
        this.imgNext.addListener(this);
        this.strPageNumberLeft = new SyncableString("[page]");
        this.strPageNumberRight = new SyncableString("[page]");
        this.pageNumberLeft = new GuiComponentLabel(85, 163, 100, 10, this.strPageNumberLeft);
        this.pageNumberLeft.setScale(0.5f);
        this.pageNumberRight = new GuiComponentLabel(295, 163, 100, 10, this.strPageNumberRight);
        this.pageNumberRight.setScale(0.5f);
        this.addComponent(this.imgLeftBackground);
        this.addComponent(this.imgRightBackground);
        this.addComponent(this.imgPrev);
        this.addComponent(this.imgNext);
        this.addComponent(this.pageNumberLeft);
        this.addComponent(this.pageNumberRight);
        this.pages = Lists.newArrayList();
    }

    public boolean gotoPage(BaseComponent page) {
        int pageIndex = this.pages.indexOf((Object)page);
        if (pageIndex > -1) {
            this.index = pageIndex % 2 == 1 ? pageIndex - 1 : pageIndex;
            this.enablePages();
            return true;
        }
        return false;
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    @Override
    public int getWidth() {
        return iconPageRight.func_94216_b() * 2;
    }

    @Override
    public int getHeight() {
        return iconPageRight.func_94216_b();
    }

    public void addPage(BaseComponent page) {
        this.addComponent(page);
        page.setEnabled(false);
        this.pages.add(page);
    }

    public boolean addStandardRecipePage(String modId, String name, Object item) {
        ItemStack stack = null;
        String type = "";
        if (item instanceof ItemStack) {
            stack = (ItemStack)item;
            String string = type = stack.func_77973_b() instanceof ItemBlock ? "tile" : "item";
        }
        if (item instanceof Item) {
            stack = new ItemStack((Item)item);
            type = "item";
        } else if (item instanceof Block) {
            stack = new ItemStack((Block)item);
            type = "tile";
        }
        if (stack != null) {
            String fullName = String.format("%s.%s.%s.name", type, modId, name);
            String description = String.format("%s.%s.%s.description", type, modId, name);
            String video = String.format("%s.%s.%s.video", type, modId, name);
            this.addPage(new GuiComponentStandardRecipePage(fullName, description, video, stack));
            return true;
        }
        return false;
    }

    public void gotoIndex(int i) {
        this.index = i;
        this.enablePages();
    }

    public void enablePages() {
        int i = 0;
        for (BaseComponent page : this.pages) {
            page.setEnabled(i == this.index || i == this.index + 1);
            ++i;
        }
        int totalPageCount = i % 2 == 0 ? i : i + 1;
        this.imgNext.setEnabled(this.index < this.pages.size() - 2);
        this.imgPrev.setEnabled(this.index > 0);
        this.strPageNumberLeft.setValue(String.format("Page %s of %s", this.index + 1, totalPageCount));
        this.strPageNumberRight.setValue(String.format("Page %s of %s", this.index + 2, totalPageCount));
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.imgRightBackground.setX(iconPageRight.func_94211_a());
        if (this.index + 1 < this.pages.size()) {
            this.pages.get(this.index + 1).setX(iconPageRight.func_94211_a());
        }
        super.render(minecraft, offsetX, offsetY, mouseX, mouseY);
    }

    @Override
    public void componentMouseDown(BaseComponent component, int offsetX, int offsetY, int button) {
        int oldIndex = this.index;
        if (component == this.imgPrev && this.index > 0) {
            this.index -= 2;
        }
        if (component == this.imgNext && this.index < this.pages.size() - 2) {
            this.index += 2;
        }
        if (oldIndex != this.index) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71416_A.func_77366_a("openmodslib:pageturn", 1.0f, 1.0f);
        }
        this.enablePages();
    }

    @Override
    public void componentMouseDrag(BaseComponent component, int offsetX, int offsetY, int button, long time) {
    }

    @Override
    public void componentMouseMove(BaseComponent component, int offsetX, int offsetY) {
    }

    @Override
    public void componentMouseUp(BaseComponent component, int offsetX, int offsetY, int button) {
    }

    @Override
    public void componentKeyTyped(BaseComponent component, char par1, int par2) {
    }
}

