/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import openmods.sync.SyncableObjectBase;

public class SyncableDouble
extends SyncableObjectBase {
    private double value;

    public SyncableDouble(double value) {
        this.value = value;
    }

    public SyncableDouble() {
    }

    public void setValue(double newValue) {
        if (newValue != this.value) {
            this.value = newValue;
            this.markDirty();
        }
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void readFromStream(DataInput stream) throws IOException {
        this.value = stream.readDouble();
    }

    @Override
    public void writeToStream(DataOutput stream, boolean fullData) throws IOException {
        stream.writeDouble(this.value);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag, String name) {
        tag.func_74780_a(name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag, String name) {
        this.value = tag.func_74769_h(name);
    }

    public void modify(float by) {
        this.setValue(this.value + (double)by);
    }
}

