/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.modifiers.tools.ToolModTypeFilter;

public class ModSmite
extends ToolModTypeFilter {
    String tooltipName = "\u00a7eSmite";
    int max = 36;
    String tagName;

    public ModSmite(String type, int effect, ItemStack[] items, int[] values) {
        super(effect, "ModSmite", items, values);
        this.tagName = type;
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0 && this.matchingAmount(input) <= this.max;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int increase = this.matchingAmount(input);
        if (tags.func_74764_b(this.key)) {
            int[] keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                int modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            int modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a7e" + this.tagName + " (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            int[] keyPair = new int[]{increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a7e" + this.tagName + " (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }
}

