/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.extrabees;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import java.awt.Rectangle;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.extrabees.AddonExtraBees;
import net.bdew.neiaddons.extrabees.AddonExtraBeesClient;
import net.bdew.neiaddons.extrabees.AlleleBeeChromosomePair;
import net.bdew.neiaddons.extrabees.SerumUtils;
import net.bdew.neiaddons.forestry.GeneticsUtils;
import net.bdew.neiaddons.utils.LabeledPositionedStack;
import net.minecraft.item.ItemStack;

public class IsolatorRecipeHandler
extends TemplateRecipeHandler {
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
            return;
        }
        if (!outputId.equals("isolator")) {
            return;
        }
        for (IAlleleBeeSpecies species : AddonExtraBees.allBeeSpecies) {
            IAllele[] template = AddonExtraBeesClient.beeRoot.getTemplate(species.getUID());
            if (template == null) {
                AddonExtraBees.instance.logWarning("Template for %s is null, wtf?", species.getUID());
                continue;
            }
            for (int i = 0; i < template.length; ++i) {
                if (template[i] == null || !SerumUtils.shouldMakeSerum(template[i].getUID(), i)) continue;
                ItemStack serum = SerumUtils.getSerum(template[i].getUID(), i);
                this.arecipes.add(new CachedSerumRecipe((IAlleleSpecies)species, serum));
            }
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (NEIAddons.fakeItemsOn) {
            result = NEIAddons.fakeItem.getOriginal(result);
        }
        if (!SerumUtils.isSerum(result)) {
            return;
        }
        AlleleBeeChromosomePair pair = SerumUtils.getData(result);
        if (pair == null) {
            return;
        }
        for (IAlleleBeeSpecies species : AddonExtraBees.allBeeSpecies) {
            IAllele[] template = AddonExtraBeesClient.beeRoot.getTemplate(species.getUID());
            if (template == null) {
                AddonExtraBees.instance.logWarning("Template for %s is null, wtf?", species.getUID());
                continue;
            }
            if (template[pair.chromosome] == null || !template[pair.chromosome].getUID().equals(pair.allele)) continue;
            this.arecipes.add(new CachedSerumRecipe((IAlleleSpecies)species, result));
        }
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(60, 26, 46, 15), "isolator", new Object[0]));
    }

    public void drawExtras(int recipe) {
        CachedSerumRecipe rec = (CachedSerumRecipe)((Object)this.arecipes.get(recipe));
        rec.bee.drawLabel();
    }

    public String getRecipeName() {
        return "Isolator";
    }

    public String getGuiTexture() {
        return "neiaddons:textures/gui/isolator.png";
    }

    public class CachedSerumRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        LabeledPositionedStack bee;
        PositionedStack serum;

        public CachedSerumRecipe(IAlleleSpecies species, ItemStack serumStack) {
            super((TemplateRecipeHandler)IsolatorRecipeHandler.this);
            this.bee = new LabeledPositionedStack(GeneticsUtils.stackFromSpecies(species, GeneticsUtils.RecipePosition.Offspring), 22, 21, species.getName(), 13);
            this.serum = new PositionedStack((Object)serumStack, 129, 25);
        }

        public PositionedStack getResult() {
            return this.serum;
        }

        public PositionedStack getIngredient() {
            return this.bee;
        }
    }
}

